/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.connectors.google.GoogleMTAPI;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.connectors.google.GoogleQueryBuilder;
import net.sf.okapi.connectors.google.GoogleResponseParser;
import net.sf.okapi.connectors.google.TranslationResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleMTAPIImpl
implements GoogleMTAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMTAPIImpl.class);
    private final String baseUrl;
    private GoogleMTv2Parameters params;
    private GoogleResponseParser parser = new GoogleResponseParser();

    public GoogleMTAPIImpl(String baseUrl, GoogleMTv2Parameters params) {
        this.baseUrl = baseUrl;
        this.params = params;
    }

    @Override
    public List<String> getLanguages() throws IOException, ParseException {
        URL url = new URL(this.baseUrl + "/languages?key=" + this.params.getApiKey());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        int code = conn.getResponseCode();
        if (code == 200) {
            return this.parser.parseLanguagesResponse(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
        }
        String errorBody = StreamUtil.streamUtf8AsString(conn.getErrorStream());
        throw this.parser.parseError(code, errorBody, null);
    }

    @Override
    public <T> List<TranslationResponse> translate(GoogleQueryBuilder<T> qb) throws IOException, ParseException {
        URL url = new URL(qb.getQuery());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        int code = conn.getResponseCode();
        if (code == 200) {
            List<String> translatedTexts = this.parser.parseResponse(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            ArrayList<TranslationResponse> responses = new ArrayList<TranslationResponse>();
            if (qb.getSourceCount() != translatedTexts.size()) {
                LOG.error("Received {} translations for {} sources in query {}", translatedTexts.size(), qb.getSourceCount(), qb.getQuery());
                throw new OkapiException("API returned incorrect number of translations (expected " + qb.getSourceCount() + ", got " + translatedTexts.size());
            }
            for (int i = 0; i < qb.getSourceCount(); ++i) {
                responses.add(new TranslationResponse(qb.getSourceTexts().get(i), translatedTexts.get(i)));
            }
            return responses;
        }
        String errorBody = StreamUtil.streamUtf8AsString(conn.getErrorStream());
        throw this.parser.parseError(code, errorBody, qb.getQuery());
    }

    @Override
    public <T> TranslationResponse translateSingleSegment(GoogleQueryBuilder<T> qb, String sourceText) throws IOException, ParseException {
        LOG.debug("Using POST query for source '{}...' of length {}", (Object)sourceText.substring(0, 32), (Object)sourceText.length());
        URL url = new URL(qb.getQuery());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        JSONObject json = new JSONObject();
        json.put("q", sourceText);
        try (OutputStreamWriter w = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
            w.write(json.toJSONString());
        }
        GoogleResponseParser parser = new GoogleResponseParser();
        int code = conn.getResponseCode();
        if (code == 200) {
            List<String> translatedTexts = parser.parseResponse(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            if (translatedTexts.size() != 1) {
                LOG.error("Received {} translations for {} sources in POST query {} with body '{}'", translatedTexts.size(), 1, qb.getQuery(), sourceText);
                throw new OkapiException("API returned incorrect number of translations (expected 1, got " + translatedTexts.size());
            }
            return new TranslationResponse(sourceText, translatedTexts.get(0));
        }
        String errorBody = StreamUtil.streamUtf8AsString(conn.getErrorStream());
        throw parser.parseError(code, errorBody, qb.toString());
    }
}

