/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import java.util.Scanner;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.markdown.MarkdownEventBuilder;
import net.sf.okapi.filters.markdown.Parameters;
import net.sf.okapi.filters.markdown.parser.MarkdownParser;
import net.sf.okapi.filters.markdown.parser.MarkdownToken;
import net.sf.okapi.filters.markdown.parser.MarkdownTokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class MarkdownFilter
extends AbstractFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkdownFilter.class);
    private MarkdownParser parser;
    private Parameters params = new Parameters();
    private RawDocument currentRawDocument;
    private BOMNewlineEncodingDetector detector;
    private MarkdownEventBuilder eventBuilder;

    public MarkdownFilter() {
        this.parser = new MarkdownParser(this.params);
        this.setMimeType("text/x-markdown");
        this.setMultilingual(false);
        this.setName("okf_markdown");
        this.setDisplayName("Markdown Filter");
        this.setFilterWriter(this.createFilterWriter());
        this.addConfiguration(new FilterConfiguration(this.getName(), "text/x-markdown", this.getClass().getName(), "Markdown", "Markdown files", null, ".md"));
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
            this.detector = null;
            this.eventBuilder = null;
        }
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return super.createFilterWriter();
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasQueuedEvents();
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.detector != null && this.detector.hasUtf8Bom();
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.detector != null && this.detector.hasUtf8Encoding();
    }

    @Override
    public Event next() {
        if (this.hasNext()) {
            return this.eventBuilder.next();
        }
        throw new IllegalStateException("No events available");
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.currentRawDocument = input;
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setNewlineType(this.detector.getNewlineType().toString());
        String detectedEncoding = this.getDetectedEncoding();
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        this.parser = new MarkdownParser(this.params);
        this.generateTokens();
        if (this.eventBuilder == null) {
            this.eventBuilder = new MarkdownEventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setPreserveWhitespace(true);
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
            this.eventBuilder.setCodeFinder(this.params.getCodeFinder());
        }
        this.generateEvents();
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
        this.createSkeletonWriter();
        this.getEncoderManager();
    }

    private String getDetectedEncoding() {
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            LOGGER.debug("Overridding user set encoding (if any). Setting auto-detected encoding {}.", (Object)detectedEncoding);
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            LOGGER.debug("Default encoding and detected encoding not found. Using best guess encoding {}", (Object)detectedEncoding);
        }
        return detectedEncoding;
    }

    private void generateTokens() {
        this.parser.setNewline(this.getNewlineType());
        try (Scanner scanner = new Scanner(this.currentRawDocument.getReader());){
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                this.parser.parse(scanner.next());
            }
        }
    }

    private void generateEvents() {
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        while (this.parser.hasNextToken()) {
            MarkdownToken token = this.parser.getNextToken();
            if (token.getType().equals((Object)MarkdownTokenType.INDENTED_CODE_BLOCK)) {
                boolean lastTokenNewline = false;
                if (!this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.startTextUnit();
                }
                while (this.parser.hasNextToken()) {
                    if (lastTokenNewline && !this.isIndented(token)) {
                        this.eventBuilder.endTextUnit();
                        break;
                    }
                    if (this.isIndented(token) || this.isNewline(token)) {
                        this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, token.getType().name(), token.getContent()));
                    } else {
                        this.eventBuilder.addToTextUnit(token.getContent());
                    }
                    lastTokenNewline = this.isNewline(token);
                    token = this.parser.getNextToken();
                }
            }
            if (this.isDocumentPart(token)) {
                if (this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.endTextUnit();
                }
                this.eventBuilder.startDocumentPart(token.getContent());
                this.eventBuilder.endDocumentPart();
                continue;
            }
            if (this.isCode(token)) {
                if (this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, token.getType().name(), token.getContent()));
                    continue;
                }
                this.eventBuilder.startDocumentPart(token.getContent());
                this.eventBuilder.endDocumentPart();
                continue;
            }
            if (token.isTranslatable()) {
                if (token.getContent().replaceAll("</?(\\w+)\\b[^>]*/?>", "").isEmpty() && this.isHtmlBlock(token)) {
                    this.eventBuilder.startDocumentPart(token.getContent());
                    this.eventBuilder.endDocumentPart();
                    continue;
                }
                if (!this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.startTextUnit();
                }
                this.eventBuilder.addToTextUnit(token.getContent());
                continue;
            }
            this.eventBuilder.startDocumentPart(token.getContent());
            this.eventBuilder.endDocumentPart();
        }
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit();
        }
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    private boolean isCode(MarkdownToken token) {
        return token != null && !this.isNewline(token) && !this.isHtmlBlock(token) && !token.getType().equals((Object)MarkdownTokenType.TEXT);
    }

    private boolean isHtmlBlock(MarkdownToken token) {
        return token.getType().equals((Object)MarkdownTokenType.HTML_BLOCK) || token.getType().equals((Object)MarkdownTokenType.HTML_COMMENT_BLOCK) || token.getType().equals((Object)MarkdownTokenType.HTML_INNER_BLOCK) || token.getType().equals((Object)MarkdownTokenType.HTML_INNER_BLOCK_COMMENT);
    }

    private boolean isNewline(MarkdownToken token) {
        return token != null && (token.getType().equals((Object)MarkdownTokenType.SOFT_LINE_BREAK) || token.getType().equals((Object)MarkdownTokenType.HARD_LINE_BREAK));
    }

    private boolean isDocumentPart(MarkdownToken token) {
        return token != null && (this.isNewline(token) || token.getType().equals((Object)MarkdownTokenType.BULLET_LIST_ITEM) || token.getType().equals((Object)MarkdownTokenType.ORDERED_LIST_ITEM) || token.getType().equals((Object)MarkdownTokenType.FENCED_CODE_BLOCK) || token.getType().equals((Object)MarkdownTokenType.FENCED_CODE_BLOCK_INFO) || token.getType().equals((Object)MarkdownTokenType.HEADING_PREFIX) || token.getType().equals((Object)MarkdownTokenType.HEADING_UNDERLINE) || token.getType().equals((Object)MarkdownTokenType.THEMATIC_BREAK) || token.getType().equals((Object)MarkdownTokenType.WHITE_SPACE) || token.getType().equals((Object)MarkdownTokenType.TABLE_PIPE) || token.getType().equals((Object)MarkdownTokenType.YAML_METADATA_HEADER));
    }

    private boolean isIndented(MarkdownToken token) {
        return token.getContent().contains("    ");
    }
}

