/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.filters.yaml.Parameters;
import net.sf.okapi.filters.yaml.parser.YamlScalarTypes;

public class YamlEncoder
implements IEncoder {
    private static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    private boolean escapeNonAscii = false;
    private String lineBreak = "\n";
    private String encoding;
    private Parameters params;
    private CharsetEncoder chsEnc = Charset.forName("UTF-8").newEncoder();
    private YamlScalarTypes scalarType = YamlScalarTypes.PLAIN;
    private boolean illegalCharWarning = false;

    @Override
    public void reset() {
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.chsEnc = Charset.forName(encoding).newEncoder();
        this.lineBreak = lineBreak;
        this.encoding = encoding;
        this.params = (Parameters)params;
        if (params != null) {
            this.escapeNonAscii = this.params.getEscapeNonAscii();
        }
    }

    @Override
    public String encode(String text, EncoderContext context) {
        switch (context) {
            case INLINE: {
                return text;
            }
            case SKELETON: {
                return text;
            }
            case TEXT: {
                if (this.scalarType != YamlScalarTypes.DOUBLE && this.scalarType != YamlScalarTypes.SINGLE) break;
                return this.encodeString(text);
            }
        }
        return text;
    }

    private String encodeString(String s) {
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int cp = s.codePointAt(i);
            t.append(this.encode(cp, EncoderContext.TEXT));
        }
        return t.toString();
    }

    @Override
    public String encode(char ch, EncoderContext context) {
        if (this.scalarType == YamlScalarTypes.LITERAL || this.scalarType == YamlScalarTypes.FOLDED || this.scalarType == YamlScalarTypes.PLAIN) {
            return String.valueOf(ch);
        }
        if (this.scalarType == YamlScalarTypes.SINGLE) {
            if (ch == '\'') {
                return "''";
            }
            return String.valueOf(ch);
        }
        if (this.scalarType == YamlScalarTypes.DOUBLE) {
            String data;
            if (ESCAPE_REPLACEMENTS.containsKey(Character.valueOf(ch))) {
                data = "\\" + ESCAPE_REPLACEMENTS.get(Character.valueOf(ch));
            } else if (this.escapeNonAscii || !this.isPrintable(ch)) {
                if (ch <= '\u00ff') {
                    String s = "0" + Integer.toString(ch, 16);
                    data = "\\x" + s.substring(s.length() - 2);
                } else if (ch >= '\ud800' && ch <= '\udbff') {
                    String s = "000" + Integer.toString(ch, 16);
                    data = "\\u" + s.substring(s.length() - 4);
                } else {
                    String s = "000" + Integer.toString(ch, 16);
                    data = "\\u" + s.substring(s.length() - 4);
                }
            } else {
                data = String.valueOf(ch);
            }
            return data;
        }
        return String.valueOf(ch);
    }

    private boolean isPrintable(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t' || c == '\u0085' || c >= '\u00a0' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                return new String(Character.toChars(value));
            }
            return this.encode((char)value, context);
        }
        return this.encode((char)value, context);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public boolean isIllegalCharWarning() {
        return this.illegalCharWarning;
    }

    public void setIllegalCharWarning(boolean illegalCharWarning) {
        this.illegalCharWarning = illegalCharWarning;
    }

    public YamlScalarTypes getScalarType() {
        return this.scalarType;
    }

    public void setScalarType(YamlScalarTypes scalarType) {
        this.scalarType = scalarType;
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0000'), "0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0007'), "a");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\b'), "b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\t'), "t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\n'), "n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u000b'), "v");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\f'), "f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\r'), "r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u001b'), "e");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0085'), "N");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u00a0'), "_");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2028'), "L");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2029'), "P");
    }
}

