/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.step;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.io.InputStreamFromOutputStream;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyXliffMergerStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFilter filter;
    private IFilterWriter writer;
    private IFilterConfigurationMapper fcMapper;
    private XLIFFFilter xlfReader;
    private String outputEncoding;
    private LocaleId trgLoc;
    private RawDocument originalDocument;

    @Override
    public String getName() {
        return "Legacy Original Document Xliff Merger";
    }

    @Override
    public String getDescription() {
        return "Legacy Merger which re-filters the original source file to provide the skeleton for merging, but does not use the newer lib-merge.";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.trgLoc = targetLocales.get(0);
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.originalDocument = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    protected Event handleRawDocument(final Event event) {
        InputStreamFromOutputStream<Void> is = new InputStreamFromOutputStream<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void produce(OutputStream sink) throws Exception {
                try {
                    LegacyXliffMergerStep.this.xlfReader = new XLIFFFilter();
                    LegacyXliffMergerStep.this.xlfReader.open(event.getRawDocument());
                    LegacyXliffMergerStep.this.filter = LegacyXliffMergerStep.this.fcMapper.createFilter(LegacyXliffMergerStep.this.originalDocument.getFilterConfigId(), LegacyXliffMergerStep.this.filter);
                    if (LegacyXliffMergerStep.this.filter == null) {
                        throw new OkapiFilterCreationException(String.format("Cannot create the filter or load the configuration for '%s'", LegacyXliffMergerStep.this.originalDocument.getFilterConfigId()));
                    }
                    LegacyXliffMergerStep.this.filter.open(LegacyXliffMergerStep.this.originalDocument);
                    LegacyXliffMergerStep.this.writer = LegacyXliffMergerStep.this.filter.createFilterWriter();
                    LegacyXliffMergerStep.this.writer.setOptions(LegacyXliffMergerStep.this.trgLoc, LegacyXliffMergerStep.this.outputEncoding);
                    LegacyXliffMergerStep.this.writer.setOutput(sink);
                    while (LegacyXliffMergerStep.this.filter.hasNext()) {
                        Event e = LegacyXliffMergerStep.this.filter.next();
                        if (e.getEventType() == EventType.TEXT_UNIT) {
                            LegacyXliffMergerStep.this.processTextUnit(e.getTextUnit());
                        }
                        LegacyXliffMergerStep.this.writer.handleEvent(e);
                    }
                }
                finally {
                    if (LegacyXliffMergerStep.this.xlfReader != null) {
                        LegacyXliffMergerStep.this.xlfReader.close();
                    }
                    if (LegacyXliffMergerStep.this.filter != null) {
                        LegacyXliffMergerStep.this.filter.close();
                    }
                    if (LegacyXliffMergerStep.this.writer != null) {
                        LegacyXliffMergerStep.this.writer.close();
                    }
                }
                return null;
            }
        };
        return new Event(EventType.RAW_DOCUMENT, new RawDocument(is, this.outputEncoding, this.trgLoc));
    }

    @Override
    public void cancel() {
    }

    @Override
    public void destroy() {
    }

    private ITextUnit getTextUnitFromXLIFF() {
        while (this.xlfReader.hasNext()) {
            Event event = this.xlfReader.next();
            if (event.getEventType() != EventType.TEXT_UNIT) continue;
            return event.getTextUnit();
        }
        return null;
    }

    private void processTextUnit(ITextUnit tu) {
        TextContainer srcCont;
        ITextUnit tuFromTrans;
        if (!tu.isTranslatable()) {
            return;
        }
        do {
            if ((tuFromTrans = this.getTextUnitFromXLIFF()) != null) continue;
            this.logger.warn("There is no more items in the package to merge with id=\"{}\".", (Object)tu.getId());
            return;
        } while (!tu.getId().equals(tuFromTrans.getId()));
        if (!tuFromTrans.hasTarget(this.trgLoc) && !tu.getSource().isEmpty()) {
            this.logger.warn("Item id=\"{}\": No translation provided; using source instead.", (Object)tu.getId());
            return;
        }
        TextContainer fromTrans = tuFromTrans.getTarget(this.trgLoc);
        if (fromTrans == null) {
            if (tuFromTrans.getSource().isEmpty()) {
                return;
            }
            this.logger.warn("Item id='{}': No target in XLIFF; using source instead.", (Object)tu.getId());
            return;
        }
        boolean mergeAsSegments = false;
        if (tu.getMimeType() != null && (tu.getMimeType().equals("application/x-ttx+xml") || tu.getMimeType().equals("application/x-xliff+xml"))) {
            mergeAsSegments = true;
        }
        ArrayList<Range> trgRanges = null;
        List<Range> srcRanges = null;
        if (mergeAsSegments) {
            trgRanges = new ArrayList<Range>();
            srcRanges = tuFromTrans.getSourceSegments().getRanges();
        }
        if (!fromTrans.contentIsOneSegment()) {
            fromTrans.getSegments().joinAll(trgRanges);
        }
        if (!tu.getSource().contentIsOneSegment()) {
            srcCont = tu.getSource().clone();
            srcCont.getSegments().joinAll();
        } else {
            srcCont = tu.getSource();
        }
        List<Code> transCodes = this.transferCodes(fromTrans, srcCont, tu);
        TextContainer trgCont = tu.createTarget(this.trgLoc, false, 7);
        if (!trgCont.contentIsOneSegment()) {
            trgCont.getSegments().joinAll();
        }
        try {
            trgCont.getFirstContent().setCodedText(fromTrans.getCodedText(), transCodes, false);
            if (mergeAsSegments) {
                trgCont.getSegments().create(trgRanges);
                tu.getSource().getSegments().create(srcRanges);
            }
        }
        catch (RuntimeException e) {
            this.logger.error("Inline code error with item id=\"{}\".\n{}", (Object)e.getLocalizedMessage(), (Object)tu.getId());
            tu.setTarget(this.trgLoc, tu.getSource());
        }
    }

    private List<Code> transferCodes(TextContainer fromTrans, TextContainer srcCont, ITextUnit tu) {
        int i;
        List<Code> transCodes = fromTrans.getFirstContent().getCodes();
        List<Code> oriCodes = srcCont.getFirstContent().getCodes();
        if (transCodes.size() == 0 && oriCodes.size() == 0) {
            return transCodes;
        }
        int[] oriIndices = new int[oriCodes.size()];
        for (int i2 = 0; i2 < oriIndices.length; ++i2) {
            oriIndices[i2] = i2;
        }
        int done = 0;
        for (i = 0; i < transCodes.size(); ++i) {
            Code transCode = transCodes.get(i);
            transCode.setOuterData(null);
            Code oriCode = null;
            for (int j = 0; j < oriIndices.length; ++j) {
                if (oriIndices[j] == -1 || oriCodes.get(oriIndices[j]).getId() != transCode.getId()) continue;
                oriCode = oriCodes.get(oriIndices[j]);
                oriIndices[j] = -1;
                ++done;
                break;
            }
            if (oriCode == null) {
                if (transCode.hasData()) continue;
                this.logger.warn("The extra target code id='{}' does not have corresponding data (item id='{}', name='{}')", transCode.getId(), tu.getId(), tu.getName() == null ? "" : tu.getName());
                continue;
            }
            if (oriCode.hasOuterData()) {
                transCode.setOuterData(oriCode.getOuterData());
            } else if (!transCode.hasData()) {
                transCode.setData(oriCode.getData());
            }
            transCode.setReferenceFlag(oriCode.hasReference());
        }
        if (oriCodes.size() > done) {
            for (i = 0; i < oriIndices.length; ++i) {
                Code code;
                if (oriIndices[i] == -1 || (code = oriCodes.get(oriIndices[i])).isDeleteable()) continue;
                this.logger.warn("The code id='{}' ({}) is missing in target (item id='{}', name='{}')", code.getId(), code.getData(), tu.getId(), tu.getName() == null ? "" : tu.getName());
                this.logger.info("Source='{}'", (Object)tu.getSource().toString());
            }
        }
        return transCodes;
    }
}

