/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.XLIFFException;

public class URIPrefixes {
    private final String REGISTRY_URL = "https://tools.oasis-open.org/version-control/browse/wsvn/xliff/trunk/xliff2-fragid/registry.txt?op=dl&isdir=0";
    private Map<String, List<String>> prefixes;
    private File extraPrefixes;

    public URIPrefixes() {
    }

    public URIPrefixes(File extraPrefixes) {
        this.extraPrefixes = extraPrefixes;
    }

    public void loadDefaults() {
        this.prefixes = this.loadFromPropertiesFile(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/prefixes.properties"));
    }

    private Map<String, List<String>> loadFromPropertiesFile(InputStream inputStream) {
        LinkedHashMap<String, List<String>> prefixes = new LinkedHashMap<String, List<String>>();
        Properties prop = new Properties();
        try {
            prop.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String prefix = (String)entry.getValue();
                if (prefix.length() < 2) {
                    throw new XLIFFException(String.format("The prefix '%s' is too short.", prefix));
                }
                if (!Util.isValidNmtoken(prefix)) {
                    throw new XLIFFException(String.format("The module or extension prefix '%s' is not an NMTOKEN.", prefix));
                }
                ArrayList<String> uris = (ArrayList<String>)prefixes.get(prefix);
                if (uris == null) {
                    uris = new ArrayList<String>();
                    prefixes.put(prefix, uris);
                }
                uris.add((String)entry.getKey());
            }
        }
        catch (IOException e) {
            throw new XLIFFException("Cannot load the prefixes.properties file from the resources.\n" + e.getLocalizedMessage());
        }
        return prefixes;
    }

    public void add(Map<String, String> map) {
        if (this.prefixes == null) {
            this.doAutoLoads();
        }
        for (String uri : map.keySet()) {
            String prefix = map.get(uri);
            List<String> uris = this.prefixes.get(prefix);
            if (uris == null) {
                uris = new ArrayList<String>();
                this.prefixes.put(prefix, uris);
            }
            uris.add(uri);
        }
    }

    public void addExtra(File inputFile) {
        if (this.prefixes == null) {
            this.loadDefaults();
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(inputFile);
            Map<String, List<String>> extraPrefixes = this.loadFromPropertiesFile(fis);
            if (extraPrefixes != null) {
                for (String key : extraPrefixes.keySet()) {
                    List<String> uris = this.prefixes.get(key);
                    if (uris == null) {
                        uris = new ArrayList<String>();
                        this.prefixes.put(key, uris);
                    }
                    uris.addAll((Collection<String>)extraPrefixes.get(key));
                }
            }
        }
        catch (Throwable e) {
            throw new XLIFFException("Cannot add extra prefixes.\n" + e.getLocalizedMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public List<String> resolve(String prefix) {
        if (this.prefixes == null) {
            this.doAutoLoads();
        }
        return this.prefixes.get(prefix);
    }

    public Map<String, List<String>> get() {
        if (this.prefixes == null) {
            this.doAutoLoads();
        }
        return this.prefixes;
    }

    public void doAutoLoads() {
        this.loadDefaults();
        if (this.extraPrefixes != null) {
            this.addExtra(this.extraPrefixes);
        }
    }

    public Map<String, List<String>> loadFromRegistry() {
        InputStream input = null;
        BufferedReader br = null;
        LinkedHashMap<String, List<String>> prefixes = new LinkedHashMap<String, List<String>>();
        try {
            URL url = new URL("https://tools.oasis-open.org/version-control/browse/wsvn/xliff/trunk/xliff2-fragid/registry.txt?op=dl&isdir=0");
            input = url.openStream();
            br = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                    line = br.readLine();
                    continue;
                }
                String[] parts = line.split("\t");
                if (parts.length != 2) {
                    throw new XLIFFException(String.format("The line '%s' is invalid.", line));
                }
                String prefix = parts[1];
                if (prefix.length() < 2) {
                    throw new XLIFFException(String.format("The prefix '%s' is too short.", prefix));
                }
                if (!Util.isValidNmtoken(prefix)) {
                    throw new XLIFFException(String.format("The module or extension prefix '%s' is not an NMTOKEN.", prefix));
                }
                ArrayList<String> uris = (ArrayList<String>)prefixes.get(prefix);
                if (uris == null) {
                    uris = new ArrayList<String>();
                    prefixes.put(prefix, uris);
                }
                uris.add(parts[0]);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new XLIFFException("Cannot load the prefixes registry.\n" + e.getLocalizedMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
        }
        return prefixes;
    }
}

