/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.options.DataHolder;

public class HtmlRendererOptions {
    public final String softBreak;
    public final boolean isSoftBreakAllSpaces;
    public final String hardBreak;
    public final String strongEmphasisStyleHtmlOpen;
    public final String strongEmphasisStyleHtmlClose;
    public final String emphasisStyleHtmlOpen;
    public final String emphasisStyleHtmlClose;
    public final String codeStyleHtmlOpen;
    public final String codeStyleHtmlClose;
    public final boolean escapeHtmlBlocks;
    public final boolean escapeHtmlCommentBlocks;
    public final boolean escapeInlineHtml;
    public final boolean escapeInlineHtmlComments;
    public final boolean percentEncodeUrls;
    public final int indentSize;
    public final boolean suppressHtmlBlocks;
    public final boolean suppressHtmlCommentBlocks;
    public final boolean suppressInlineHtml;
    public final boolean suppressInlineHtmlComments;
    public final boolean doNotRenderLinksInDocument;
    public final boolean renderHeaderId;
    public final boolean generateHeaderIds;
    public final String languageClassPrefix;
    public final String noLanguageClass;
    public final String sourcePositionAttribute;
    public final String inlineCodeSpliceClass;
    public final boolean sourcePositionParagraphLines;
    public final boolean sourceWrapHtmlBlocks;
    public final int formatFlags;
    public final int maxTrailingBlankLines;
    public final boolean htmlBlockOpenTagEol;
    public final boolean htmlBlockCloseTagEol;
    public final boolean unescapeHtmlEntities;

    public HtmlRendererOptions(DataHolder options) {
        this.softBreak = (String)HtmlRenderer.SOFT_BREAK.getFrom(options);
        this.isSoftBreakAllSpaces = Utils.isWhiteSpaceNoEOL((String)this.softBreak);
        this.hardBreak = (String)HtmlRenderer.HARD_BREAK.getFrom(options);
        this.strongEmphasisStyleHtmlOpen = (String)HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_OPEN.getFrom(options);
        this.strongEmphasisStyleHtmlClose = (String)HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_CLOSE.getFrom(options);
        this.emphasisStyleHtmlOpen = (String)HtmlRenderer.EMPHASIS_STYLE_HTML_OPEN.getFrom(options);
        this.emphasisStyleHtmlClose = (String)HtmlRenderer.EMPHASIS_STYLE_HTML_CLOSE.getFrom(options);
        this.codeStyleHtmlOpen = (String)HtmlRenderer.CODE_STYLE_HTML_OPEN.getFrom(options);
        this.codeStyleHtmlClose = (String)HtmlRenderer.CODE_STYLE_HTML_CLOSE.getFrom(options);
        this.escapeHtmlBlocks = (Boolean)HtmlRenderer.ESCAPE_HTML_BLOCKS.getFrom(options);
        this.escapeHtmlCommentBlocks = (Boolean)HtmlRenderer.ESCAPE_HTML_COMMENT_BLOCKS.getFrom(options);
        this.escapeInlineHtml = (Boolean)HtmlRenderer.ESCAPE_INLINE_HTML.getFrom(options);
        this.escapeInlineHtmlComments = (Boolean)HtmlRenderer.ESCAPE_INLINE_HTML_COMMENTS.getFrom(options);
        this.percentEncodeUrls = (Boolean)HtmlRenderer.PERCENT_ENCODE_URLS.getFrom(options);
        this.indentSize = (Integer)HtmlRenderer.INDENT_SIZE.getFrom(options);
        this.suppressHtmlBlocks = (Boolean)HtmlRenderer.SUPPRESS_HTML_BLOCKS.getFrom(options);
        this.suppressHtmlCommentBlocks = (Boolean)HtmlRenderer.SUPPRESS_HTML_COMMENT_BLOCKS.getFrom(options);
        this.suppressInlineHtml = (Boolean)HtmlRenderer.SUPPRESS_INLINE_HTML.getFrom(options);
        this.suppressInlineHtmlComments = (Boolean)HtmlRenderer.SUPPRESS_INLINE_HTML_COMMENTS.getFrom(options);
        this.doNotRenderLinksInDocument = (Boolean)HtmlRenderer.DO_NOT_RENDER_LINKS.getFrom(options);
        this.renderHeaderId = (Boolean)HtmlRenderer.RENDER_HEADER_ID.getFrom(options);
        this.generateHeaderIds = (Boolean)HtmlRenderer.GENERATE_HEADER_ID.getFrom(options);
        this.languageClassPrefix = (String)HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_PREFIX.getFrom(options);
        this.noLanguageClass = (String)HtmlRenderer.FENCED_CODE_NO_LANGUAGE_CLASS.getFrom(options);
        this.sourcePositionAttribute = (String)HtmlRenderer.SOURCE_POSITION_ATTRIBUTE.getFrom(options);
        this.sourcePositionParagraphLines = !this.sourcePositionAttribute.isEmpty() && (Boolean)HtmlRenderer.SOURCE_POSITION_PARAGRAPH_LINES.getFrom(options) != false;
        this.sourceWrapHtmlBlocks = !this.sourcePositionAttribute.isEmpty() && (Boolean)HtmlRenderer.SOURCE_WRAP_HTML_BLOCKS.getFrom(options) != false;
        this.formatFlags = (Integer)HtmlRenderer.FORMAT_FLAGS.getFrom(options);
        this.maxTrailingBlankLines = (Integer)HtmlRenderer.MAX_TRAILING_BLANK_LINES.getFrom(options);
        this.htmlBlockOpenTagEol = (Boolean)HtmlRenderer.HTML_BLOCK_OPEN_TAG_EOL.getFrom(options);
        this.htmlBlockCloseTagEol = (Boolean)HtmlRenderer.HTML_BLOCK_CLOSE_TAG_EOL.getFrom(options);
        this.unescapeHtmlEntities = (Boolean)HtmlRenderer.UNESCAPE_HTML_ENTITIES.getFrom(options);
        this.inlineCodeSpliceClass = (String)HtmlRenderer.INLINE_CODE_SPLICE_CLASS.getFrom(options);
    }
}

