/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.internal.BlockQuoteParser;
import com.vladsch.flexmark.internal.FencedCodeBlockParser;
import com.vladsch.flexmark.internal.HeadingParser;
import com.vladsch.flexmark.internal.HtmlDeepParser;
import com.vladsch.flexmark.internal.IndentedCodeBlockParser;
import com.vladsch.flexmark.internal.ListBlockParser;
import com.vladsch.flexmark.internal.ParagraphParser;
import com.vladsch.flexmark.internal.ThematicBreakParser;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class HtmlBlockParser
extends AbstractBlockParser {
    public static final String HTML_COMMENT_OPEN = "<!--";
    public static final String HTML_COMMENT_CLOSE = "-->";
    private final HtmlBlockBase block;
    private final Pattern closingPattern;
    private final HtmlDeepParser deepParser;
    private boolean finished = false;
    private BlockContent content = new BlockContent();
    private final boolean parseInnerHtmlComments;
    private final boolean myHtmlBlockDeepParseNonBlock;
    private final boolean myHtmlBlockDeepParseBlankLineInterrupts;
    private final boolean myHtmlBlockDeepParseMarkdownInterruptsClosed;
    private final boolean myHtmlBlockDeepParseBlankLineInterruptsPartialTag;
    private final boolean myHtmlBlockDeepParseIndentedCodeInterrupts;

    private HtmlBlockParser(DataHolder options, Pattern closingPattern, boolean isComment, HtmlDeepParser deepParser) {
        this.closingPattern = closingPattern;
        this.block = isComment ? new HtmlCommentBlock() : new HtmlBlock();
        this.deepParser = deepParser;
        this.parseInnerHtmlComments = (Boolean)options.get(Parser.PARSE_INNER_HTML_COMMENTS);
        this.myHtmlBlockDeepParseNonBlock = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSE_NON_BLOCK);
        this.myHtmlBlockDeepParseBlankLineInterrupts = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS);
        this.myHtmlBlockDeepParseMarkdownInterruptsClosed = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSE_MARKDOWN_INTERRUPTS_CLOSED);
        this.myHtmlBlockDeepParseBlankLineInterruptsPartialTag = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS_PARTIAL_TAG);
        this.myHtmlBlockDeepParseIndentedCodeInterrupts = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSE_INDENTED_CODE_INTERRUPTS);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (this.deepParser != null) {
            if (state.isBlank() && (this.deepParser.isHtmlClosed() || this.myHtmlBlockDeepParseBlankLineInterrupts && !this.deepParser.haveOpenRawTag() || this.myHtmlBlockDeepParseBlankLineInterruptsPartialTag && this.deepParser.isBlankLineIterruptible())) {
                return BlockContinue.none();
            }
            return BlockContinue.atIndex(state.getIndex());
        }
        if (this.finished) {
            return BlockContinue.none();
        }
        if (state.isBlank() && this.closingPattern == null) {
            return BlockContinue.none();
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        if (this.deepParser != null) {
            if (this.content.getLineCount() > 0) {
                this.deepParser.parseHtmlChunk((CharSequence)line, false, this.myHtmlBlockDeepParseNonBlock, false);
            }
        } else if (this.closingPattern != null && this.closingPattern.matcher((CharSequence)line).find()) {
            this.finished = true;
        }
        this.content.add(line, state.getIndent());
    }

    @Override
    public boolean canInterruptBy(BlockParserFactory blockParserFactory) {
        return this.myHtmlBlockDeepParseMarkdownInterruptsClosed && this.deepParser != null && !(blockParserFactory instanceof Factory) && (this.myHtmlBlockDeepParseIndentedCodeInterrupts || !(blockParserFactory instanceof IndentedCodeBlockParser.BlockFactory)) && this.deepParser.isHtmlClosed();
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return false;
    }

    @Override
    public boolean isInterruptible() {
        return this.myHtmlBlockDeepParseMarkdownInterruptsClosed && this.deepParser != null && this.deepParser.isHtmlClosed();
    }

    @Override
    public boolean isRawText() {
        return true;
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.content = null;
        if (!(this.block instanceof HtmlCommentBlock) && this.parseInnerHtmlComments) {
            int end;
            int index;
            int lastIndex = 0;
            BasedSequence chars = this.block.getContentChars();
            if (chars.eolLength() > 0) {
                chars = chars.midSequence(0, -1);
            }
            int length = chars.length();
            while (lastIndex < length && (index = chars.indexOf((CharSequence)HTML_COMMENT_OPEN, lastIndex)) >= 0 && (end = chars.indexOf((CharSequence)HTML_COMMENT_CLOSE, index + HTML_COMMENT_OPEN.length())) >= 0) {
                if (lastIndex < index) {
                    HtmlInnerBlock html = new HtmlInnerBlock(chars.subSequence(lastIndex, index));
                    this.block.appendChild((Node)html);
                }
                lastIndex = end + HTML_COMMENT_CLOSE.length();
                HtmlInnerBlockComment htmlComment = new HtmlInnerBlockComment(chars.subSequence(index, lastIndex));
                this.block.appendChild((Node)htmlComment);
            }
            if (lastIndex > 0 && lastIndex < chars.length()) {
                HtmlInnerBlock html = new HtmlInnerBlock(chars.subSequence(lastIndex, chars.length()));
                this.block.appendChild((Node)html);
            }
        }
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private Patterns myPatterns = null;
        private final boolean myHtmlCommentBlocksInterruptParagraph;
        private final boolean myHtmlBlockDeepParser;
        private final boolean myHtmlBlockDeepParseNonBlock;
        private final boolean myHtmlBlockDeepParseFirstOpenTagOnOneLine;

        private BlockFactory(DataHolder options) {
            super(options);
            this.myHtmlCommentBlocksInterruptParagraph = (Boolean)Parser.HTML_COMMENT_BLOCKS_INTERRUPT_PARAGRAPH.getFrom(options);
            this.myHtmlBlockDeepParser = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSER);
            this.myHtmlBlockDeepParseNonBlock = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSE_NON_BLOCK);
            this.myHtmlBlockDeepParseFirstOpenTagOnOneLine = (Boolean)options.get(Parser.HTML_BLOCK_DEEP_PARSE_FIRST_OPEN_TAG_ON_ONE_LINE);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence line = state.getLine();
            if (state.getIndent() < 4 && line.charAt(nextNonSpace) == '<' && !(matchedBlockParser.getBlockParser() instanceof HtmlBlockParser)) {
                if (this.myHtmlBlockDeepParser) {
                    HtmlDeepParser deepParser = new HtmlDeepParser();
                    deepParser.parseHtmlChunk((CharSequence)line.subSequence(nextNonSpace, line.length()), true, this.myHtmlBlockDeepParseNonBlock, this.myHtmlBlockDeepParseFirstOpenTagOnOneLine);
                    if (deepParser.hadHtml() && (deepParser.getHtmlMatch() != HtmlDeepParser.HtmlMatch.OPEN_TAG && (this.myHtmlCommentBlocksInterruptParagraph || deepParser.getHtmlMatch() != HtmlDeepParser.HtmlMatch.COMMENT) || !(matchedBlockParser.getBlockParser().getBlock() instanceof Paragraph))) {
                        return BlockStart.of(new HtmlBlockParser((DataHolder)state.getProperties(), null, deepParser.getHtmlMatch() == HtmlDeepParser.HtmlMatch.COMMENT, deepParser)).atIndex(state.getIndex());
                    }
                } else {
                    for (int blockType = 1; blockType <= 7; ++blockType) {
                        if (blockType == 7 && matchedBlockParser.getBlockParser().getBlock() instanceof Paragraph) continue;
                        if (this.myPatterns == null) {
                            this.myPatterns = new Patterns(state.getParsing());
                        }
                        Pattern opener = this.myPatterns.BLOCK_PATTERNS[blockType][0];
                        Pattern closer = this.myPatterns.BLOCK_PATTERNS[blockType][1];
                        boolean matches = opener.matcher((CharSequence)line.subSequence(nextNonSpace, line.length())).find();
                        if (!matches || !this.myHtmlCommentBlocksInterruptParagraph && blockType == this.myPatterns.COMMENT_PATTERN_INDEX && matchedBlockParser.getBlockParser() instanceof ParagraphParser) continue;
                        return BlockStart.of(new HtmlBlockParser((DataHolder)state.getProperties(), closer, blockType == this.myPatterns.COMMENT_PATTERN_INDEX, null)).atIndex(state.getIndex());
                    }
                }
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class, FencedCodeBlockParser.Factory.class));
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }

    private static class Patterns {
        public final int COMMENT_PATTERN_INDEX;
        public final Pattern[][] BLOCK_PATTERNS;

        public Patterns(Parsing parsing) {
            this.COMMENT_PATTERN_INDEX = 2;
            this.BLOCK_PATTERNS = new Pattern[][]{{null, null}, {Pattern.compile("^<(?:script|pre|style)(?:\\s|>|$)", 2), Pattern.compile("</(?:script|pre|style)>", 2)}, {Pattern.compile("^<!--"), Pattern.compile(HtmlBlockParser.HTML_COMMENT_CLOSE)}, {Pattern.compile("^<[?]"), Pattern.compile("\\?>")}, {Pattern.compile("^<![A-Z]"), Pattern.compile(">")}, {Pattern.compile("^<!\\[CDATA\\["), Pattern.compile("\\]\\]>")}, {Pattern.compile("^</?(?:address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul)(?:\\s|[/]?[>]|$)", 2), null}, {Pattern.compile("^(?:" + parsing.OPENTAG + '|' + parsing.CLOSETAG + ")\\s*$", 2), null}};
        }
    }
}

