/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.internal.inline;

import com.vladsch.flexmark.ast.DelimitedNodeImpl;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.internal.Delimiter;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.delimiter.DelimiterProcessor;
import com.vladsch.flexmark.parser.delimiter.DelimiterRun;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public abstract class EmphasisDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar;
    private final int multipleUse;

    protected EmphasisDelimiterProcessor(char delimiterChar, boolean strongWrapsEmphasis) {
        this.delimiterChar = delimiterChar;
        this.multipleUse = strongWrapsEmphasis ? 1 : 2;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    @Override
    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    @Override
    public int getMinLength() {
        return 1;
    }

    @Override
    public boolean canBeOpener(boolean leftFlanking, boolean rightFlanking, boolean beforeIsPunctuation, boolean afterIsPunctuation, boolean beforeIsWhitespace, boolean afterIsWhiteSpace) {
        return leftFlanking;
    }

    @Override
    public boolean canBeCloser(boolean leftFlanking, boolean rightFlanking, boolean beforeIsPunctuation, boolean afterIsPunctuation, boolean beforeIsWhitespace, boolean afterIsWhiteSpace) {
        return rightFlanking;
    }

    @Override
    public Node unmatchedDelimiterNode(InlineParser inlineParser, DelimiterRun delimiter) {
        return null;
    }

    @Override
    public int getDelimiterUse(DelimiterRun opener, DelimiterRun closer) {
        if ((opener.canClose() || closer.canOpen()) && (opener.length() + closer.length()) % 3 == 0) {
            return 0;
        }
        if (opener.length() < 3 || closer.length() < 3) {
            return Utils.min((int)closer.length(), (int[])new int[]{opener.length()});
        }
        return closer.length() % 2 == 0 ? 2 : this.multipleUse;
    }

    @Override
    public void process(Delimiter opener, Delimiter closer, int delimitersUsed) {
        DelimitedNodeImpl emphasis = delimitersUsed == 1 ? new Emphasis(opener.getTailChars(delimitersUsed), BasedSequence.NULL, closer.getLeadChars(delimitersUsed)) : new StrongEmphasis(opener.getTailChars(delimitersUsed), BasedSequence.NULL, closer.getLeadChars(delimitersUsed));
        opener.moveNodesBetweenDelimitersTo(emphasis, closer);
    }
}

