/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDocumentPanel;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class InputDocumentDialog {
    private Shell shell;
    private Object[] result;
    private InputDocumentPanel pnlMain;
    private Button chkAcceptAll;
    private OKCancelPanel pnlActions;

    public InputDocumentDialog(Shell parent, String captionText, IFilterConfigurationMapper fcMapper, boolean batchMode) {
        this.shell = new Shell(parent, 65648);
        if (captionText != null) {
            this.shell.setText(captionText);
        }
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout(new GridLayout());
        Composite cmpTmp = new Composite(this.shell, 2048);
        cmpTmp.setLayout(new GridLayout());
        GridData gdTmp = new GridData(1808);
        cmpTmp.setLayoutData(gdTmp);
        this.pnlMain = new InputDocumentPanel(cmpTmp, 0, 1, "Input document:", null, fcMapper);
        if (batchMode) {
            this.chkAcceptAll = new Button(cmpTmp, 32);
            this.chkAcceptAll.setText("Accept all next documents with their defaults.");
            gdTmp = new GridData(768);
            gdTmp.verticalIndent = 8;
            this.chkAcceptAll.setLayoutData(gdTmp);
        }
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                InputDocumentDialog.access$002(InputDocumentDialog.this, null);
                if (e.widget.getData().equals("h")) {
                    Util.openWikiTopic((String)"Input Document");
                    return;
                }
                if (e.widget.getData().equals("o") && !InputDocumentDialog.this.saveData()) {
                    return;
                }
                InputDocumentDialog.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(this.pnlActions.btOK);
        this.shell.pack();
        Point size = this.shell.getSize();
        this.shell.setMinimumSize(size);
        if (size.x < 600) {
            size.x = 600;
        }
        this.shell.setSize(size);
        Dialogs.centerWindow(this.shell, parent);
    }

    public Object[] showDialog() {
        this.shell.open();
        if (this.chkAcceptAll != null && this.chkAcceptAll.getSelection() && this.saveData()) {
            this.shell.close();
            return this.result;
        }
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    public void setAcceptAll(boolean acceptAll) {
        if (this.chkAcceptAll != null) {
            this.chkAcceptAll.setSelection(acceptAll);
        }
    }

    public void setData(String path, String configId, String encoding, LocaleId srcLoc, LocaleId trgLoc) {
        this.pnlMain.setDocumentPath(path == null ? "" : path);
        this.pnlMain.setFilterConfigurationId(configId);
        this.pnlMain.setEncoding(encoding);
        this.pnlMain.setSourceLocale(srcLoc);
        this.pnlMain.setTargetLocale(trgLoc);
        if (this.pnlMain.getFilterConfigurationId().isEmpty() && !this.pnlMain.getDocumentPath().isEmpty()) {
            this.pnlMain.guessConfiguration();
        }
        if (!this.pnlMain.getDocumentPath().isEmpty()) {
            this.pnlMain.guessLocales();
        }
    }

    public void setLocalesEditable(boolean editable) {
        this.pnlMain.setLocalesEditable(editable);
    }

    private boolean saveData() {
        this.result = null;
        if (!this.pnlMain.validate(true)) {
            return false;
        }
        this.result = new Object[6];
        this.result[0] = this.pnlMain.getDocumentPath();
        this.result[1] = this.pnlMain.getFilterConfigurationId();
        this.result[2] = this.pnlMain.getEncoding();
        this.result[3] = this.pnlMain.getSourceLocale();
        this.result[4] = this.pnlMain.getTargetLocale();
        this.result[5] = this.chkAcceptAll == null ? false : this.chkAcceptAll.getSelection();
        return true;
    }

    static /* synthetic */ Object[] access$002(InputDocumentDialog x0, Object[] x1) {
        x0.result = x1;
        return x1;
    }
}

