/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.changeTracking;

import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.changeTracking.Item;
import net.sf.okapi.lib.xliff2.core.BaseList;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;

public class Revision
extends BaseList<Item>
implements IWithExtAttributes {
    public static final String TAG_NAME = "revision";
    public static final String AUTHOR_ATTR_NAME = "author";
    public static final String DATETIME_ATTR_NAME = "datetime";
    public static final String VERSION_ATTR_NAME = "version";
    private String author;
    private String datetime;
    private String version;
    private ExtAttributes xattrs;

    public Revision() {
    }

    public Revision(Revision original) {
        super(original);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version != null && !Util.isValidNmtoken(version)) {
            throw new IllegalArgumentException(String.format("The value of '%s' must be an NMTOKEN.", VERSION_ATTR_NAME));
        }
        this.version = version;
    }

    @Override
    public ExtAttributes getExtAttributes() {
        if (this.xattrs == null) {
            this.xattrs = new ExtAttributes();
        }
        return this.xattrs;
    }

    @Override
    public void setExtAttributes(ExtAttributes attributes) {
        this.xattrs = attributes;
    }

    @Override
    public boolean hasExtAttribute() {
        return this.xattrs != null && !this.xattrs.isEmpty();
    }

    @Override
    public String getExtAttributeValue(String namespaceURI, String localName) {
        String xattrValue = null;
        if (this.hasExtAttribute()) {
            xattrValue = this.xattrs.getAttributeValue(namespaceURI, localName);
        }
        return xattrValue;
    }

    public String getAttributesString() {
        StringBuilder attrs = new StringBuilder();
        if (this.author != null && !this.author.isEmpty()) {
            attrs.append(" ");
            attrs.append(AUTHOR_ATTR_NAME);
            attrs.append("=\"");
            attrs.append(this.author);
            attrs.append("\"");
        }
        if (this.datetime != null && !this.datetime.isEmpty()) {
            attrs.append(" ");
            attrs.append(DATETIME_ATTR_NAME);
            attrs.append("=\"");
            attrs.append(this.datetime);
            attrs.append("\"");
        }
        if (this.version != null && !this.version.isEmpty()) {
            attrs.append(" ");
            attrs.append(VERSION_ATTR_NAME);
            attrs.append("=\"");
            attrs.append(this.version);
            attrs.append("\"");
        }
        return attrs.toString();
    }

    public String getOpeningTagName() {
        return "ctr:revision";
    }

    public String getClosingTag() {
        return "</ctr:revision>";
    }
}

