/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import net.sf.okapi.applications.rainbow.lib.ILog;
import net.sf.okapi.applications.rainbow.lib.Res;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogForm
implements ILog {
    private Shell shell;
    private Text edLog;
    private StringBuffer strLog = new StringBuffer();
    private Button btStop;
    private int errorCount;
    private int warningCount;
    private long data = 0L;
    private ProgressBar pbPrimary;
    private ProgressBar pbSecondary;
    private boolean inProgress = false;
    private IHelp help;
    private String helpPath;
    private long startTime;

    public LogForm(Shell p_Parent) {
        this.shell = new Shell(p_Parent, 3312);
        UIUtil.inheritIcon(this.shell, p_Parent);
        this.createContent();
    }

    private void createContent() {
        this.shell.setLayout((Layout)new GridLayout(4, false));
        this.shell.addListener(21, event -> {
            event.doit = false;
            this.hide();
        });
        int nWidth = 80;
        Button button = new Button((Composite)this.shell, 8);
        button.setText(Res.getString("LogForm.help"));
        GridData gdTmp = new GridData();
        gdTmp.widthHint = nWidth;
        button.setLayoutData((Object)gdTmp);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LogForm.this.help != null && LogForm.this.helpPath != null) {
                    LogForm.this.help.showTopic(null, LogForm.this.helpPath);
                }
            }
        });
        button = new Button((Composite)this.shell, 8);
        button.setText(Res.getString("LogForm.clear"));
        gdTmp = new GridData();
        gdTmp.widthHint = nWidth;
        button.setLayoutData((Object)gdTmp);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogForm.this.clear();
            }
        });
        this.btStop = new Button((Composite)this.shell, 8);
        this.btStop.setText(Res.getString("LogForm.stop"));
        gdTmp = new GridData();
        gdTmp.widthHint = nWidth;
        this.btStop.setLayoutData((Object)gdTmp);
        this.btStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogForm.this.cancel(true);
            }
        });
        button = new Button((Composite)this.shell, 8);
        button.setText(Res.getString("LogForm.close"));
        gdTmp = new GridData();
        gdTmp.widthHint = nWidth;
        button.setLayoutData((Object)gdTmp);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogForm.this.hide();
            }
        });
        this.pbPrimary = new ProgressBar((Composite)this.shell, 256);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.pbPrimary.setLayoutData((Object)gdTmp);
        this.pbSecondary = new ProgressBar((Composite)this.shell, 256);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.pbSecondary.setLayoutData((Object)gdTmp);
        this.edLog = new Text((Composite)this.shell, 2626);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        this.edLog.setLayoutData((Object)gdTmp);
        this.updateDisplay();
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        this.shell.setSize(600, 300);
    }

    private void updateDisplay() {
        Display disp = Display.getDefault();
        if (Thread.currentThread().getId() != disp.getThread().getId()) {
            return;
        }
        this.edLog.append(this.strLog.toString());
        this.strLog = new StringBuffer();
        this.btStop.setEnabled(this.inProgress);
        this.pbPrimary.setEnabled(this.inProgress);
        this.pbSecondary.setEnabled(this.inProgress);
        while (disp.readAndDispatch()) {
        }
    }

    @Override
    public boolean beginProcess(String p_sText) {
        if (this.inProgress()) {
            return false;
        }
        this.clear();
        this.startTime = System.currentTimeMillis();
        this.strLog.append(Res.getString("LogForm.startProcess"));
        if (p_sText != null && p_sText.length() > 0) {
            this.setLog(2, 0, p_sText);
        }
        this.warningCount = 0;
        this.errorCount = 0;
        this.inProgress = true;
        this.updateDisplay();
        return this.inProgress;
    }

    @Override
    public boolean beginTask(String p_sText) {
        if (p_sText != null && p_sText.length() > 0) {
            this.setLog(2, 0, p_sText);
        }
        return this.inProgress;
    }

    @Override
    public boolean canContinue() {
        return this.inProgress;
    }

    @Override
    public void cancel(boolean p_bAskConfirmation) {
        if (this.inProgress()) {
            if (p_bAskConfirmation) {
                // empty if block
            }
            this.endTask(null);
            this.endProcess(null);
        }
    }

    @Override
    public void clear() {
        this.edLog.setText("");
        this.strLog = new StringBuffer();
    }

    private String toHMSMS(long millis) {
        long hours = millis / 3600000L;
        long minutes = (millis -= hours * 3600000L) / 60000L;
        long seconds = (millis -= minutes * 60000L) / 1000L;
        return String.format("%dh %dm %ds %dms", hours, minutes, seconds, millis -= seconds * 1000L);
    }

    @Override
    public void endProcess(String p_sText) {
        if (this.inProgress) {
            if (p_sText != null && p_sText.length() > 0) {
                this.setLog(2, 0, p_sText);
            }
            this.strLog.append(String.format(Res.getString("LogForm.errorCount"), this.errorCount));
            this.strLog.append(String.format(Res.getString("LogForm.warningCount"), this.warningCount));
            this.strLog.append(String.format(Res.getString("LogForm.duration"), this.toHMSMS(System.currentTimeMillis() - this.startTime)));
            this.strLog.append(Res.getString("LogForm.endProcess"));
        }
        this.inProgress = false;
        this.updateDisplay();
    }

    @Override
    public void endTask(String p_sText) {
        if (this.inProgress && p_sText != null && p_sText.length() > 0) {
            this.setLog(2, 0, p_sText);
        }
    }

    @Override
    public boolean error(String p_sText) {
        return this.setLog(4, 0, p_sText);
    }

    @Override
    public long getCallerData() {
        return this.data;
    }

    @Override
    public int getErrorAndWarningCount() {
        return this.errorCount + this.warningCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public boolean inProgress() {
        return this.inProgress;
    }

    @Override
    public boolean message(String p_sText) {
        return this.setLog(2, 0, p_sText);
    }

    @Override
    public boolean newLine() {
        return this.setLog(2, 0, "\n");
    }

    @Override
    public void save(String path) {
    }

    @Override
    public void setCallerData(long newData) {
        this.data = newData;
    }

    @Override
    public void setHelp(IHelp helpParam, String helpPath) {
        this.help = helpParam;
        this.helpPath = helpPath;
    }

    @Override
    public boolean setLog(int p_nType, int p_nValue, String p_sValue) {
        switch (p_nType) {
            case 4: {
                this.strLog.append(Res.getString("LogForm.error") + p_sValue + "\n");
                this.updateDisplay();
                ++this.errorCount;
                break;
            }
            case 3: {
                this.strLog.append(Res.getString("LogForm.warning") + p_sValue + "\n");
                this.updateDisplay();
                ++this.warningCount;
                break;
            }
            case 2: {
                this.strLog.append(p_sValue + "\n");
                this.updateDisplay();
                break;
            }
            case 0: 
            case 1: {
                break;
            }
        }
        return this.canContinue();
    }

    @Override
    public void setMainProgressMode(int p_nValue) {
        if (p_nValue < 0) {
            p_nValue = 0;
        }
        if (p_nValue > 100) {
            p_nValue = 100;
        }
    }

    @Override
    public boolean setOnTop(boolean p_bValue) {
        return false;
    }

    @Override
    public void setSubProgressMode(int p_nValue) {
        if (p_nValue < 0) {
            p_nValue = 0;
        }
        if (p_nValue > 100) {
            p_nValue = 100;
        }
    }

    @Override
    public boolean warning(String p_sText) {
        return this.setLog(3, 0, p_sText);
    }

    @Override
    public void hide() {
        this.shell.setVisible(false);
    }

    @Override
    public void setTitle(String text) {
        this.shell.setText(text);
    }

    @Override
    public void show() {
        this.shell.setVisible(true);
        if (this.shell.getMinimized()) {
            this.shell.setMinimized(false);
        }
    }

    @Override
    public boolean isVisible() {
        return this.shell.isVisible();
    }
}

