/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.abstracteditor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.lib.extra.INotifiable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParametersEditor
implements IParametersEditor,
Listener,
INotifiable {
    private Shell shell;
    private boolean result = true;
    private OKCancelPanel pnlActions;
    private IParameters params;
    private IHelp help;
    private TabFolder pageContainer;
    private List<IDialogPage> pages = null;
    boolean readOnly = false;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters paramsObject, boolean readOnly, IContext context) {
        this.result = true;
        if (context == null) {
            return false;
        }
        this.readOnly = readOnly;
        Shell parent = (Shell)context.getObject("shell");
        try {
            if (this.pages == null) {
                this.pages = new ArrayList<IDialogPage>();
            } else {
                this.pages.clear();
            }
            this.help = (IHelp)context.getObject("help");
            this.shell = null;
            this.params = paramsObject;
            this.shell = new Shell(parent, 65648);
            this.create(parent);
            if (!this.result) {
                boolean bl = false;
                return bl;
            }
            this.showDialog();
            if (!this.result) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return this.result;
    }

    private void create(Shell p_Parent) {
        String caption = this.getCaption();
        if (!Util.isEmpty((String)caption)) {
            this.shell.setText(caption);
        }
        this.shell.setData("owner", this);
        if (p_Parent != null) {
            this.shell.setImage(p_Parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        this.pageContainer = new TabFolder(this.shell, 0);
        GridData gdTmp = new GridData(1808);
        this.pageContainer.setLayoutData(gdTmp);
        this.createPages(this.pageContainer);
        if (!this.result) {
            return;
        }
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (AbstractParametersEditor.this.help != null) {
                        AbstractParametersEditor.this.help.showWiki(AbstractParametersEditor.this.getWikiPage());
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!AbstractParametersEditor.this.checkCanClose(true)) {
                        return;
                    }
                    AbstractParametersEditor.this.result = AbstractParametersEditor.this.saveParameters();
                } else {
                    AbstractParametersEditor.this.result = false;
                    if (!AbstractParametersEditor.this.checkCanClose(false)) {
                        return;
                    }
                }
                AbstractParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        if (this.readOnly) {
            this.pnlActions.btOK.setEnabled(false);
        }
        gdTmp = new GridData(768);
        this.pnlActions.setLayoutData(gdTmp);
        this.shell.setDefaultButton(this.pnlActions.btOK);
        this.shell.pack();
        Rectangle minRect = this.shell.getBounds();
        Rectangle startRect = this.shell.getBounds();
        if (minRect.width > 500) {
            minRect.width = 500;
        }
        if (minRect.height > 400) {
            minRect.height = 400;
        }
        this.shell.setMinimumSize(minRect.width, minRect.height);
        this.shell.setSize(startRect.width, startRect.height);
        Dialogs.centerWindow(this.shell, p_Parent);
        this.loadParameters();
    }

    private void showDialog() {
        if (!this.result) {
            return;
        }
        for (IDialogPage page : this.pages) {
            if (page == null) continue;
            page.interop(null);
        }
        this.interop(null);
        this.result = false;
        this.shell.open();
        while (!this.shell.isDisposed()) {
            try {
                if (this.shell.getDisplay().readAndDispatch()) continue;
                this.shell.getDisplay().sleep();
            }
            catch (Exception E) {
                Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            }
        }
    }

    protected boolean loadParameters() {
        for (IDialogPage page : this.pages) {
            if (page == null) {
                return false;
            }
            if (page.load(this.params)) continue;
            Dialogs.showError(this.shell, String.format("Error loading parameters to the %s page.", this.getCaption(page)), null);
            return false;
        }
        for (IDialogPage page : this.pages) {
            if (page == null) {
                return false;
            }
            page.interop(null);
        }
        this.interop(null);
        return true;
    }

    protected boolean saveParameters() {
        if (this.readOnly) {
            Dialogs.showWarning(this.shell, "Editor in read-only mode, parameters are not saved.", null);
            return false;
        }
        for (IDialogPage page : this.pages) {
            if (page == null) {
                return false;
            }
            page.interop(null);
        }
        this.interop(null);
        for (IDialogPage page : this.pages) {
            if (page == null) {
                return false;
            }
            if (page.save(this.params)) continue;
            Dialogs.showError(this.shell, String.format("Error saving parameters from the %s page.", this.getCaption(page)), null);
            return false;
        }
        return true;
    }

    private boolean checkCanClose(boolean isOK) {
        for (IDialogPage page : this.pages) {
            if (page == null) {
                return false;
            }
            if (page.canClose(isOK)) continue;
            this.pageContainer.setSelection(this.findTab(page));
            return false;
        }
        return true;
    }

    protected void addSpeaker(Control control) {
        this.addSpeaker(control, 13);
    }

    protected void addSpeaker(Control control, int eventType) {
        if (control == null) {
            return;
        }
        control.addListener(eventType, this);
    }

    protected void addSpeaker(Class<? extends Composite> pageClass, String controlName) {
        this.addSpeaker(SWTUtil.findControl(this.findPage(pageClass), controlName));
    }

    protected void addSpeaker(Class<? extends Composite> pageClass, String controlName, int eventType) {
        this.addSpeaker(SWTUtil.findControl(this.findPage(pageClass), controlName), eventType);
    }

    protected Control findControl(Class<? extends Composite> pageClass, String controlName) {
        return SWTUtil.findControl(this.findPage(pageClass), controlName);
    }

    protected Control findControl(Composite page, String controlName) {
        return SWTUtil.findControl(page, controlName);
    }

    protected <T extends Composite> Composite addPage(String caption, Class<T> pageClass) {
        if (!Composite.class.isAssignableFrom(pageClass)) {
            return null;
        }
        try {
            Constructor<T> cc = pageClass.getConstructor(Composite.class, Integer.TYPE);
            if (cc == null) {
                return null;
            }
            Composite page = (Composite)cc.newInstance(this.pageContainer, 0);
            return this.addPage(caption, page);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.result = false;
            this.logger.debug("Page instantiation failed: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected Composite addPage(String caption, Composite page) {
        TabItem tabItem = new TabItem(this.pageContainer, 0);
        tabItem.setText(caption);
        tabItem.setControl(page);
        if (page instanceof IDialogPage) {
            IDialogPage ppg = (IDialogPage)((Object)page);
            if (this.pages != null) {
                this.pages.add(ppg);
            }
        }
        return page;
    }

    protected TabFolder getPageContainer() {
        return this.pageContainer;
    }

    protected Composite findPage(Class<? extends Composite> pageClass) {
        for (IDialogPage page : this.pages) {
            if (page == null || page.getClass() != pageClass || !(page instanceof Composite)) continue;
            return (Composite)((Object)page);
        }
        return null;
    }

    protected Composite findPageInTabs(Class<? extends Composite> pageClass) {
        for (TabItem tabItem : this.pageContainer.getItems()) {
            Composite page = (Composite)tabItem.getControl();
            if (page.getClass() != pageClass) continue;
            return page;
        }
        return null;
    }

    protected Composite findPageInTabs(String caption) {
        for (TabItem tabItem : this.pageContainer.getItems()) {
            if (!tabItem.getText().equalsIgnoreCase(caption)) continue;
            Composite page = (Composite)tabItem.getControl();
            return page;
        }
        return null;
    }

    protected TabItem findTab(IDialogPage page) {
        if (page instanceof Composite) {
            return this.findTab((Composite)((Object)page));
        }
        return null;
    }

    protected TabItem findTab(Composite page) {
        for (TabItem tabItem : this.pageContainer.getItems()) {
            Composite p = (Composite)tabItem.getControl();
            if (p != page) continue;
            return tabItem;
        }
        return null;
    }

    protected String getCaption(IDialogPage page) {
        if (!(page instanceof Composite)) {
            return "";
        }
        TabItem tab = this.findTab(page);
        if (tab == null) {
            return "";
        }
        return tab.getText();
    }

    public abstract IParameters createParameters();

    protected abstract String getCaption();

    protected abstract void createPages(TabFolder var1);

    protected abstract void interop(Widget var1);

    @Override
    public void handleEvent(Event event) {
        this.interop(event.widget);
    }

    protected void pageInterop(Class<? extends Composite> pageClass, Widget speaker) {
        Composite page = this.findPage(pageClass);
        if (page instanceof IDialogPage) {
            ((IDialogPage)((Object)page)).interop(speaker);
        }
    }

    public boolean exec(Object sender, String command, Object info) {
        if (command.equalsIgnoreCase("REGISTER_DIALOG_PAGE")) {
            if (info instanceof IDialogPage) {
                boolean res = this.pages.add((IDialogPage)info);
                if (res) {
                    ((IDialogPage)info).interop(null);
                    this.interop(null);
                }
                return res;
            }
        } else if (command.equalsIgnoreCase("UNREGISTER_DIALOG_PAGE") && info instanceof IDialogPage) {
            boolean res = this.pages.remove(info);
            if (res) {
                this.interop(null);
            }
            return res;
        }
        return false;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected IParameters getParams() {
        return this.params;
    }

    protected List<IDialogPage> getPages() {
        return this.pages;
    }

    protected boolean isReadOnly() {
        return this.readOnly;
    }

    protected String getWikiPage() {
        return null;
    }
}

