/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.abstracteditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableAdapter {
    public static final int DUPLICATE_ALLOW = 1;
    public static final int DUPLICATE_REJECT = 2;
    public static final int DUPLICATE_REPLACE = 3;
    Table table;
    double[] columnPoints = null;
    TableItem saveSelItem = null;
    private int colIndex = 0;
    private boolean ascending = true;
    private boolean treatAsInt = false;
    private Comparator<TableItem> strComparator = (t1, t2) -> {
        if (this.treatAsInt) {
            int v1 = Util.strToInt((String)t1.getText(this.colIndex), (int)0);
            int v2 = Util.strToInt((String)t2.getText(this.colIndex), (int)0);
            int result = Integer.compare(v1, v2);
            return this.ascending ? result : -result;
        }
        String v1 = t1.getText(this.colIndex);
        String v2 = t2.getText(this.colIndex);
        int result = v1.compareTo(v2);
        return this.ascending ? result : -result;
    };

    public TableAdapter(Table table) {
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateColumnWidths(boolean blockRedraw) {
        if (this.columnPoints == null) {
            return;
        }
        double pointsWidth = 0.0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            pointsWidth += this.columnPoints[i];
        }
        double coeff = (double)this.table.getClientArea().width / pointsWidth;
        if (blockRedraw) {
            this.table.setRedraw(false);
        }
        try {
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                this.table.getColumn(i).setWidth((int)(this.columnPoints[i] * coeff));
            }
        }
        finally {
            if (blockRedraw) {
                this.table.setRedraw(true);
            }
        }
    }

    public void setRelColumnWidths(double[] columnPoints) {
        this.columnPoints = columnPoints;
        this.table.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                TableAdapter.this.updateColumnWidths(false);
            }
        });
    }

    public void addRow(String[] rowData) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(rowData);
        this.table.select(this.table.indexOf(item));
    }

    public void addRow(String[] rowData, boolean selectRow) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(rowData);
        if (selectRow) {
            this.table.select(this.table.indexOf(item));
        }
    }

    public void addRow(int intValue, int columnNumber) {
        this.addRows(Util.intToStr((int)intValue), columnNumber);
    }

    public void modifyRow(TableItem item, String[] rowData) {
        if (item == null) {
            return;
        }
        item.setText(rowData);
        this.table.select(this.table.indexOf(item));
    }

    public void addModifyRow(String[] rowData, int keyColNumber, int dupMode) {
        this.addModifyRow(null, rowData, keyColNumber, dupMode);
    }

    public void addModifyRow(TableItem item, String[] rowData, int keyColNumber, int dupMode) {
        String st = (String)Util.get((Object[])rowData, (int)(keyColNumber - 1));
        TableItem item2 = this.findValue(st, keyColNumber);
        if (item2 != null) {
            switch (dupMode) {
                case 1: {
                    this.addRow(rowData);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.modifyRow(item2, rowData);
                }
            }
        } else {
            this.addRow(rowData);
        }
    }

    public void unselect() {
        this.storeSelection();
        this.table.setSelection(-1);
    }

    public void addRows(String values, int columnNumber) {
        List valList = ListUtil.stringAsList((String)values);
        for (String st : valList) {
            if (Util.isEmpty((String)st)) continue;
            this.addModifyRow(new String[]{st}, columnNumber, 2);
        }
    }

    public TableItem findValue(String value, int columnNumber) {
        if (Util.isEmpty((String)value)) {
            return null;
        }
        for (TableItem item : this.table.getItems()) {
            if (item == null || !value.equalsIgnoreCase(item.getText(columnNumber - 1))) continue;
            return item;
        }
        return null;
    }

    public List<String> getColumnValues(int columnNumber) {
        ArrayList<String> list = new ArrayList<String>();
        if (!SWTUtil.checkColumnIndex(this.table, columnNumber - 1)) {
            return list;
        }
        for (TableItem item : this.table.getItems()) {
            list.add(item.getText(columnNumber - 1));
        }
        return list;
    }

    public boolean valueExists(String value, int columnNumber) {
        return this.findValue(value, columnNumber) != null;
    }

    private String[] getData(TableItem t) {
        Table table = t.getParent();
        int colCount = table.getColumnCount();
        String[] s = new String[colCount];
        for (int i = 0; i < colCount; ++i) {
            s[i] = t.getText(i);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(int sortColNum, boolean ascending, boolean treatAsInt) {
        if (sortColNum == 0) {
            return;
        }
        TableItem[] items = this.table.getItems();
        this.colIndex = sortColNum - 1;
        this.ascending = ascending;
        this.treatAsInt = treatAsInt;
        this.storeSelection();
        this.table.setRedraw(false);
        try {
            Arrays.sort(items, this.strComparator);
            for (int i = 0; i < items.length; ++i) {
                TableItem item = new TableItem(this.table, 0, i);
                item.setText(this.getData(items[i]));
                if (this.saveSelItem != null && this.saveSelItem.equals(items[i])) {
                    this.saveSelItem = item;
                }
                items[i].dispose();
            }
        }
        finally {
            this.table.setRedraw(true);
            this.restoreSelection();
        }
    }

    public void sort(int sortColNum, boolean treatAsInt) {
        this.sort(sortColNum, true, treatAsInt);
    }

    public void sort(TableColumn sortColumn, boolean treatAsInt) {
        this.sort(SWTUtil.getColumnIndex(sortColumn) + 1, true, treatAsInt);
    }

    public boolean removeSelected() {
        int index = this.table.getSelectionIndex();
        if (index == -1) {
            return false;
        }
        this.table.remove(index);
        if (index > this.table.getItemCount() - 1) {
            index = this.table.getItemCount() - 1;
        }
        if (index > -1) {
            this.table.select(index);
        }
        return true;
    }

    public void storeSelection() {
        this.saveSelItem = this.table.getSelection().length > 0 ? this.table.getSelection()[0] : null;
    }

    public void restoreSelection() {
        if (this.saveSelItem == null) {
            this.table.select(-1);
        } else {
            this.table.setSelection(this.saveSelItem);
        }
    }

    public void setValue(TableItem item, int colNum, String value) {
        if (item == null) {
            return;
        }
        item.setText(colNum - 1, value);
    }

    public void setValue(int rowNum, int colNum, String value) {
        if (!SWTUtil.checkRowIndex(this.table, rowNum - 1)) {
            return;
        }
        TableItem item = this.table.getItem(rowNum - 1);
        if (item == null) {
            return;
        }
        item.setText(colNum - 1, value);
    }

    public int getNumRows() {
        return this.table.getItemCount();
    }

    public int getNumColumns() {
        return this.table.getColumnCount();
    }

    public String getValue(int rowNum, int colNum) {
        if (!SWTUtil.checkRowIndex(this.table, rowNum - 1)) {
            return "";
        }
        TableItem item = this.table.getItem(rowNum - 1);
        if (item == null) {
            return "";
        }
        return item.getText(colNum - 1);
    }

    public void clear() {
        this.table.removeAll();
    }

    public void setColumnAlignment(int colNum, int alignment) {
        TableColumn tc = this.table.getColumn(colNum - 1);
        tc.setAlignment(alignment);
    }
}

