/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openoffice.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.filters.openoffice.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private Button chkExtractNotes;
    private Button chkExtractReferences;
    private Button chkMetadata;
    private Parameters params;
    private IHelp help;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters options, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Parameters)options;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public Parameters createParameters() {
        return new Parameters();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("OpenDocument Filter Parameters");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        TabFolder tfTmp = new TabFolder(this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tfTmp.setLayoutData(gdTmp);
        Composite cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        this.chkExtractNotes = new Button(cmpTmp, 32);
        this.chkExtractNotes.setText("Extract notes (office:annotation)");
        this.chkExtractReferences = new Button(cmpTmp, 32);
        this.chkExtractReferences.setText("Extract references (text:bookmark-ref)");
        this.chkMetadata = new Button(cmpTmp, 32);
        this.chkMetadata.setText("Extract metadata (meta.xml)");
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Options");
        tiTmp.setControl(cmpTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("OpenOffice Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        pnlActions.setLayoutData(gdTmp);
        pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 300) {
            startSize.x = 300;
        }
        if (startSize.y < 200) {
            startSize.y = 200;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkExtractNotes.setSelection(this.params.getExtractNotes());
        this.chkExtractReferences.setSelection(this.params.getExtractReferences());
        this.chkMetadata.setSelection(this.params.getExtractMetadata());
    }

    private boolean saveData() {
        this.params.setExtractNotes(this.chkExtractNotes.getSelection());
        this.params.setExtractReferences(this.chkExtractReferences.getSelection());
        this.params.setExtractMetadata(this.chkMetadata.getSelection());
        return true;
    }
}

