/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.ui.common;

import java.util.Iterator;
import java.util.LinkedList;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.abstracteditor.AbstractParametersEditor;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.lib.extra.filters.CompoundFilterParameters;

public abstract class FilterParametersEditor
extends AbstractParametersEditor {
    @Override
    protected boolean loadParameters() {
        if (this.getParams() instanceof CompoundFilterParameters) {
            LinkedList list = ((CompoundFilterParameters)this.getParams()).getParameters();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IParameters parameters = (IParameters)iterator.next();
                for (IDialogPage page : this.getPages()) {
                    page.load(parameters);
                }
            }
        }
        for (IDialogPage iDialogPage : this.getPages()) {
            if (iDialogPage == null) {
                return false;
            }
            if (iDialogPage.load(this.getParams())) continue;
            Dialogs.showError(this.getShell(), String.format("Error loading parameters to the %s page.", this.getCaption(iDialogPage)), null);
            return false;
        }
        if (this.getParams() instanceof CompoundFilterParameters) {
            IParameters activeParams = ((CompoundFilterParameters)this.getParams()).getActiveParameters();
            for (IDialogPage page : this.getPages()) {
                if (page == null) {
                    return false;
                }
                if (page.load(activeParams)) continue;
                Dialogs.showError(this.getShell(), String.format("Error loading parameters to the %s page.", this.getCaption(page)), null);
                return false;
            }
        }
        for (IDialogPage iDialogPage : this.getPages()) {
            if (iDialogPage == null) {
                return false;
            }
            iDialogPage.interop(null);
        }
        this.interop(null);
        return true;
    }

    @Override
    protected boolean saveParameters() {
        if (this.isReadOnly()) {
            Dialogs.showWarning(this.getShell(), "Editor in read-only mode, parameters are not saved.", null);
            return false;
        }
        for (IDialogPage page : this.getPages()) {
            if (page == null) {
                return false;
            }
            page.interop(null);
        }
        this.interop(null);
        for (IDialogPage page : this.getPages()) {
            if (page == null) {
                return false;
            }
            if (page.save(this.getParams())) continue;
            Dialogs.showError(this.getShell(), String.format("Error saving parameters from the %s page.", this.getCaption(page)), null);
            return false;
        }
        if (this.getParams() instanceof CompoundFilterParameters) {
            IParameters activeParams = ((CompoundFilterParameters)this.getParams()).getActiveParameters();
            for (IDialogPage page : this.getPages()) {
                if (page == null) {
                    return false;
                }
                if (page.save(activeParams)) continue;
                Dialogs.showError(this.getShell(), String.format("Error saving parameters from the %s page.", this.getCaption(page)), null);
                return false;
            }
        }
        return true;
    }
}

