/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.regex.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.filters.regex.Rule;
import net.sf.okapi.filters.regex.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RuleDialog {
    private Shell shell;
    private Text edExpression;
    private Text edSample;
    private Text edResult;
    private Text edSource;
    private boolean useSource;
    private Text edTarget;
    private boolean useTarget;
    private Text edName;
    private boolean useName;
    private Text edNote;
    private boolean useNote;
    private Combo cbRuleType;
    private boolean result = false;
    private Pattern fullPattern;
    private Rule rule = null;
    private int regexOptions;
    private IHelp help;
    private Font largerFont;

    protected void finalize() {
        this.dispose();
    }

    public RuleDialog(Shell parent, IHelp helpParam, Rule rule, int regexOptions) {
        this.rule = rule;
        this.help = helpParam;
        this.regexOptions = regexOptions;
        this.shell = new Shell(parent, 65648);
        this.shell.setText(Res.getString("RuleDialog.caption"));
        this.shell.setImage(parent.getImage());
        this.shell.setLayout(new GridLayout());
        Group grpTmp = new Group(this.shell, 0);
        grpTmp.setText("Regular expression");
        grpTmp.setLayoutData(new GridData(1808));
        GridLayout layTmp = new GridLayout();
        grpTmp.setLayout(layTmp);
        this.edExpression = new Text(grpTmp, 2052);
        GridData gdTmp = new GridData(768);
        this.edExpression.setLayoutData(gdTmp);
        this.edExpression.addModifyListener(e -> this.updateResults());
        Font font = this.edExpression.getFont();
        FontData[] fontData = font.getFontData();
        fontData[0].setHeight(fontData[0].getHeight() + 3);
        this.largerFont = new Font(font.getDevice(), fontData[0]);
        this.edExpression.setFont(this.largerFont);
        Label label = new Label(grpTmp, 0);
        label.setText("Sample:");
        this.edSample = new Text(grpTmp, 2562);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 64;
        this.edSample.setLayoutData(gdTmp);
        this.edSample.addModifyListener(e -> this.updateResults());
        this.edResult = new Text(grpTmp, 2562);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 88;
        this.edResult.setLayoutData(gdTmp);
        this.edResult.setEditable(false);
        grpTmp = new Group(this.shell, 0);
        grpTmp.setText("Action and groups");
        grpTmp.setLayoutData(new GridData(768));
        layTmp = new GridLayout(4, false);
        grpTmp.setLayout(layTmp);
        Composite cmpTmp = new Composite(grpTmp, 0);
        layTmp = new GridLayout(2, false);
        layTmp.marginWidth = 0;
        cmpTmp.setLayout(layTmp);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        cmpTmp.setLayoutData(gdTmp);
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("Editor.action"));
        this.cbRuleType = new Combo(cmpTmp, 12);
        this.cbRuleType.addModifyListener(e -> this.updateGroups());
        this.cbRuleType.setLayoutData(new GridData(768));
        this.cbRuleType.add(Res.getString("Editor.extractStringsInside"));
        this.cbRuleType.add(Res.getString("Editor.extractContent"));
        this.cbRuleType.add(Res.getString("Editor.treatAsComment"));
        this.cbRuleType.add(Res.getString("Editor.doNotExtract"));
        this.cbRuleType.add(Res.getString("Editor.startGroup"));
        this.cbRuleType.add(Res.getString("Editor.endGroup"));
        label = new Label(grpTmp, 0);
        label.setText("&Source group number:");
        int fieldWidth = 50;
        this.edSource = new Text(grpTmp, 2052);
        gdTmp = new GridData();
        gdTmp.widthHint = fieldWidth;
        this.edSource.setLayoutData(gdTmp);
        this.edSource.addModifyListener(e -> this.updateResults());
        int indent = 10;
        label = new Label(grpTmp, 0);
        label.setText("&Target group number:");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        label.setLayoutData(gdTmp);
        this.edTarget = new Text(grpTmp, 2052);
        gdTmp = new GridData();
        gdTmp.widthHint = fieldWidth;
        this.edTarget.setLayoutData(gdTmp);
        this.edTarget.addModifyListener(e -> this.updateResults());
        label = new Label(grpTmp, 0);
        label.setText("&Identifier group number:");
        this.edName = new Text(grpTmp, 2052);
        gdTmp = new GridData();
        gdTmp.widthHint = fieldWidth;
        this.edName.setLayoutData(gdTmp);
        this.edName.addModifyListener(e -> this.updateResults());
        label = new Label(grpTmp, 0);
        label.setText("&Note group number:");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        label.setLayoutData(gdTmp);
        this.edNote = new Text(grpTmp, 2052);
        gdTmp = new GridData();
        gdTmp.widthHint = fieldWidth;
        this.edNote.setLayoutData(gdTmp);
        this.edNote.addModifyListener(e -> this.updateResults());
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                RuleDialog.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (RuleDialog.this.help != null) {
                        RuleDialog.this.help.showTopic((Object)this, "editRule");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !RuleDialog.this.saveData()) {
                    return;
                }
                RuleDialog.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        if (startSize.y < 550) {
            startSize.y = 550;
        }
        this.shell.setSize(startSize);
        this.setData();
        Dialogs.centerWindow(this.shell, parent);
    }

    public void dispose() {
        if (this.largerFont != null) {
            this.largerFont.dispose();
            this.largerFont = null;
        }
    }

    public boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        this.dispose();
        return this.result;
    }

    public void updateGroups() {
        int type = this.cbRuleType.getSelectionIndex();
        switch (type) {
            case 0: {
                this.useSource = true;
                this.useTarget = false;
                this.useName = true;
                this.useNote = true;
                break;
            }
            case 1: {
                this.useSource = true;
                this.useTarget = true;
                this.useName = true;
                this.useNote = true;
                break;
            }
            case 2: {
                this.useSource = true;
                this.useTarget = false;
                this.useName = false;
                this.useNote = false;
                break;
            }
            case 3: 
            case 5: {
                this.useSource = false;
                this.useTarget = false;
                this.useName = false;
                this.useNote = false;
                break;
            }
            case 4: {
                this.useSource = false;
                this.useTarget = false;
                this.useName = true;
                this.useNote = true;
            }
        }
        this.edSource.setEnabled(this.useSource);
        this.edTarget.setEnabled(this.useTarget);
        this.edName.setEnabled(this.useName);
        this.edNote.setEnabled(this.useNote);
        this.updateResults();
    }

    private boolean updateResults() {
        boolean result = true;
        try {
            this.fullPattern = Pattern.compile(this.edExpression.getText(), this.regexOptions);
            int source = Integer.valueOf(this.edSource.getText());
            int target = Integer.valueOf(this.edTarget.getText());
            int name = Integer.valueOf(this.edName.getText());
            int note = Integer.valueOf(this.edNote.getText());
            Matcher m1 = this.fullPattern.matcher(this.getSampleText());
            StringBuilder tmp = new StringBuilder();
            int startSearch = 0;
            while (m1.find(startSearch) && m1.start() != m1.end()) {
                boolean hasGroup = false;
                if (tmp.length() > 0) {
                    tmp.append("-----\n");
                }
                if (this.useSource && source != -1) {
                    tmp.append("Source=[" + m1.group(source) + "]\n");
                    hasGroup = true;
                }
                if (this.useTarget && target != -1) {
                    tmp.append("Target=[" + m1.group(target) + "]\n");
                    hasGroup = true;
                }
                if (this.useName && name != -1) {
                    tmp.append("Identifier=[" + m1.group(name) + "]\n");
                    hasGroup = true;
                }
                if (this.useNote && note != -1) {
                    tmp.append("Note=[" + m1.group(note) + "]\n");
                    hasGroup = true;
                }
                if (!hasGroup) {
                    tmp.append("Expression=[" + m1.group() + "]\n");
                }
                startSearch = m1.end();
            }
            if (tmp.length() == 0) {
                tmp.append(Res.getString("RuleDialog.noMatch"));
            }
            this.edResult.setText(tmp.toString());
        }
        catch (Throwable e) {
            this.edResult.setText(Res.getString("RuleDialog.error") + e.getMessage());
            result = false;
        }
        return result;
    }

    private String getSampleText() {
        String tmp = this.edSample.getText();
        tmp = tmp.replaceAll("\r\r\n", "\n");
        tmp = tmp.replace("\r\n", "\n");
        return tmp.replace("\r", "\n");
    }

    private boolean saveData() {
        try {
            if (this.edExpression.getText().length() == 0) {
                this.edExpression.selectAll();
                this.edExpression.setFocus();
                return false;
            }
            Integer.valueOf(this.edSource.getText());
            Integer.valueOf(this.edTarget.getText());
            Integer.valueOf(this.edName.getText());
            Integer.valueOf(this.edNote.getText());
            if (!this.updateResults()) {
                throw new OkapiException("Error in expression or in group numbers.");
            }
            this.rule.setExpression(this.edExpression.getText());
            this.rule.setSourceGroup(Integer.valueOf(this.edSource.getText()).intValue());
            this.rule.setTargetGroup(Integer.valueOf(this.edTarget.getText()).intValue());
            this.rule.setNameGroup(Integer.valueOf(this.edName.getText()).intValue());
            this.rule.setNoteGroup(Integer.valueOf(this.edNote.getText()).intValue());
            this.rule.setSample(this.getSampleText());
            this.rule.setRuleType(this.cbRuleType.getSelectionIndex());
            this.result = true;
            return this.result;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            return false;
        }
    }

    public void setData() {
        this.edSource.setText(String.valueOf(this.rule.getSourceGroup()));
        this.edTarget.setText(String.valueOf(this.rule.getTargetGroup()));
        this.edName.setText(String.valueOf(this.rule.getNameGroup()));
        this.edNote.setText(String.valueOf(this.rule.getNoteGroup()));
        this.cbRuleType.select(this.rule.getRuleType());
        this.edExpression.setText(this.rule.getExpression());
        this.edSample.setText(this.rule.getSample());
    }

    public Rule getRule() {
        return this.rule;
    }
}

