/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.mmt;

import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.mmt.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class MMTConnector
extends BaseConnector {
    private static final String TRANSLATE_METHOD = "/translate";
    private static final String QPARAM = "?q=";
    private static final String CONTEXTPARAM = "&context=";
    private Parameters params = new Parameters();
    private JSONParser parser;
    private QueryUtil util = new QueryUtil();

    public MMTConnector() {
        this.parser = new JSONParser();
    }

    @Override
    public String getName() {
        return "ModernMT API Connector";
    }

    @Override
    public String getSettingsDisplay() {
        return "ModernMT URL: " + this.params.getUrl() + (this.params.getContext().isEmpty() ? "" : " - Context: " + this.params.getContext());
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment fragment) {
        this.current = -1;
        try {
            if (!fragment.hasText(false)) {
                return 0;
            }
            if (Util.isEmpty(this.params.getUrl())) {
                throw new OkapiException("You must have a URL configured for your ModernMT Engine.");
            }
            String qtext = this.util.toCodedHTML(fragment);
            String contextPart = !this.params.getContext().isEmpty() ? CONTEXTPARAM + URLEncoder.encode(this.params.getContext(), "UTF-8") : "";
            StringBuilder sb = new StringBuilder(this.params.getUrl()).append(TRANSLATE_METHOD).append(QPARAM).append(URLEncoder.encode(qtext, "UTF-8")).append("&source=").append(this.srcLoc.getLanguage()).append("&target=").append(this.trgLoc.getLanguage()).append(contextPart);
            URL url = new URL(sb.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int code = conn.getResponseCode();
            if (code != 200) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(String.format("Response Code: \"%d\", Body: \"%s\"", code, conn.getResponseMessage()));
                JSONObject resp = (JSONObject)this.parser.parse(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));
                if (resp.containsKey("error")) {
                    JSONObject error = (JSONObject)resp.get("error");
                    String type = (String)error.get("type");
                    String message = (String)error.get("message");
                    errorMessage.append(String.format(", Error Type: \"%s\", Message: \"%s\"", type, message));
                }
                throw new OkapiException(errorMessage.toString());
            }
            JSONObject object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            if (object.containsKey("data")) {
                JSONObject data = (JSONObject)object.get("data");
                String translation = (String)data.get("translation");
                this.result = new QueryResult();
                this.result.weight = this.getWeight();
                this.result.source = fragment;
                this.result.target = fragment.hasCode() ? new TextFragment(this.util.fromCodedHTML(translation, fragment, true), fragment.getClonedCodes()) : new TextFragment(this.util.fromCodedHTML(translation, fragment, true));
                this.result.setFuzzyScore(95);
                this.result.origin = this.getName();
                this.result.matchType = MatchType.MT;
                this.current = 0;
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the server.\n" + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

