/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.mymemory;

import com.ibm.icu.util.ULocale;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.mymemory.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class MyMemoryTMConnector
extends BaseConnector
implements ITMQuery {
    private static final String BASE_URL = "https://mymemory.translated.net/api/get";
    private static final String BASE_QUERY = "?q=%s&langpair=%s|%s";
    private List<QueryResult> results;
    private int current = -1;
    private int maxHits = 25;
    private int threshold = 75;
    private Parameters params = new Parameters();
    private QueryUtil qutil = new QueryUtil();
    private JSONParser parser = new JSONParser();
    private String ipAddress;

    public MyMemoryTMConnector() {
        this.results = new ArrayList<QueryResult>();
    }

    @Override
    public String getName() {
        return "MyMemory.net";
    }

    @Override
    public String getSettingsDisplay() {
        return String.format("Server: %s\nAllow MT: %s", BASE_URL, this.params.getUseMT() == 1 ? "Yes" : "No");
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
        if (this.params.getSendIP()) {
            try {
                InetAddress thisIp = InetAddress.getLocalHost();
                this.ipAddress = thisIp.getHostAddress();
            }
            catch (UnknownHostException e) {
                this.ipAddress = null;
            }
        }
    }

    @Override
    public int query(TextFragment frag) {
        this.results.clear();
        this.current = -1;
        if (!frag.hasText(false)) {
            return 0;
        }
        try {
            JSONObject object;
            String text = this.qutil.separateCodesFromText(frag);
            String urlString = BASE_URL + String.format(BASE_QUERY, URLEncoder.encode(text, "UTF-8"), this.srcCode, this.trgCode);
            if (this.ipAddress != null) {
                urlString = urlString + "&ip=" + this.ipAddress;
            }
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            JSONObject map = object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            JSONArray matches = (JSONArray)map.get("matches");
            int count = 0;
            for (int i = 0; i < matches.size() && ++count <= this.maxHits; ++i) {
                int score;
                Double match;
                Object m;
                Map details = (Map)matches.get(i);
                QueryResult res = new QueryResult();
                String from = (String)details.get("last-updated-by");
                if (from == null && (from = (String)details.get("created-by")) == null) {
                    from = "";
                }
                if (from.equals("MT!")) {
                    if (this.params.getUseMT() != 1) {
                        --count;
                        continue;
                    }
                    res.matchType = MatchType.MT;
                }
                if ((m = details.get("match")) instanceof Long) {
                    long tmpl = (Long)m;
                    match = tmpl * 100L;
                } else {
                    match = (Double)m * 100.0;
                }
                int n = score = match.intValue() > 100 ? 100 : match.intValue();
                if (this.qutil.hasCode()) {
                    --score;
                }
                if (score < this.getThreshold()) break;
                res.weight = this.getWeight();
                res.origin = this.getName();
                res.setFuzzyScore(score);
                if (this.qutil.hasCode()) {
                    res.source = this.qutil.createNewFragmentWithCodes((String)details.get("segment"));
                    res.target = this.qutil.createNewFragmentWithCodes((String)details.get("translation"));
                } else {
                    res.source = new TextFragment((String)details.get("segment"));
                    res.target = new TextFragment((String)details.get("translation"));
                }
                this.results.add(res);
            }
            this.current = 0;
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the server.\n" + e.getMessage(), e);
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String lang = locale.getLanguage();
        String reg = locale.getRegion();
        if (reg == null || reg.isEmpty()) {
            ULocale fullLocale = ULocale.addLikelySubtags(locale.toIcuLocale());
            reg = fullLocale.getCountry().toLowerCase(Locale.US);
        }
        return lang + "-" + reg;
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max < 1 ? 1 : max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }
}

