/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.abstractmarkup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.CharacterEntityReference;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.LoggerProvider;
import net.htmlparser.jericho.NumericCharacterReference;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedSource;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.QuoteMode;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupEventBuilder;
import net.sf.okapi.filters.abstractmarkup.ExtractionRuleState;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarkupFilter
extends AbstractFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String CDATA_START_REGEX = "<\\!\\[CDATA\\[";
    private static final String CDATA_END_REGEX = "\\]\\]>";
    private static final Pattern CDATA_START_PATTERN = Pattern.compile("<\\!\\[CDATA\\[");
    private static final Pattern CDATA_END_PATTERN = Pattern.compile("\\]\\]>");
    private static final int PREVIEW_BYTE_COUNT = 8192;
    private StringBuilder bufferedWhitespace;
    private StreamedSource document;
    private Iterator<Segment> nodeIterator;
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private boolean hasBOM;
    private AbstractMarkupEventBuilder eventBuilder;
    private RawDocument currentRawDocument;
    private ExtractionRuleState ruleState;
    private String currentId;
    private boolean documentEncoding;
    private String currentDocName;
    private IFilter cdataFilter;
    private IFilter pcdataFilter;
    private int cdataSectionIndex;
    private int pcdataSectionIndex;
    private int prevTagEnd;

    public AbstractMarkupFilter() {
        this.bufferedWhitespace = new StringBuilder();
        this.hasUtf8Bom = false;
        this.hasUtf8Encoding = false;
        this.hasBOM = false;
        this.currentId = null;
        this.documentEncoding = false;
    }

    public AbstractMarkupFilter(AbstractMarkupEventBuilder eventBuilder) {
        this.eventBuilder = eventBuilder;
        this.bufferedWhitespace = new StringBuilder();
        this.hasUtf8Bom = false;
        this.hasUtf8Encoding = false;
        this.hasBOM = false;
        this.currentId = null;
        this.documentEncoding = false;
    }

    protected abstract TaggedFilterConfiguration getConfig();

    @Override
    public void close() {
        super.close();
        this.hasUtf8Bom = false;
        this.hasUtf8Encoding = false;
        this.currentId = null;
        if (this.ruleState != null) {
            this.ruleState.reset(!this.getConfig().isGlobalPreserveWhitespace(), this.getConfig().isGlobalExcludeByDefault());
        }
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
        }
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not close " + this.getDocumentName(), e);
        }
        this.document = null;
        this.LOGGER.debug("{} has been closed", (Object)this.getDocumentName());
    }

    protected Source getParsedHeader(InputStream inputStream) {
        try {
            int nextByte;
            int i;
            int charSize = 1;
            if (this.getEncoding().toLowerCase().startsWith("utf-16")) {
                charSize = 2;
            } else if (this.getEncoding().toLowerCase().startsWith("utf-32")) {
                charSize = 4;
            }
            byte[] bytes = new byte[8192 * charSize];
            for (i = 0; i < bytes.length && (nextByte = inputStream.read()) != -1; ++i) {
                bytes[i] = (byte)nextByte;
            }
            Source source = new Source(new ByteArrayInputStream(bytes, 0, i));
            return source;
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not reset the input stream to it's start position", e);
        }
        finally {
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {}
        }
    }

    protected String detectEncoding(RawDocument input) {
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        if (input.getInputCharSequence() != null) {
            detector.detectBom();
        } else {
            detector.detectAndRemoveBom();
        }
        this.setEncoding(detector.getEncoding());
        this.hasUtf8Bom = detector.hasUtf8Bom();
        this.hasUtf8Encoding = detector.hasUtf8Encoding();
        this.hasBOM = detector.hasBom();
        this.setNewlineType(detector.getNewlineType().toString());
        Source parsedHeader = this.getParsedHeader(input.getStream());
        String detectedEncoding = parsedHeader.getDocumentSpecifiedEncoding();
        boolean bl = this.documentEncoding = detectedEncoding != null;
        if (detectedEncoding == null && this.getEncoding() != null) {
            detectedEncoding = this.getEncoding();
            this.LOGGER.debug("Cannot auto-detect encoding. Using the default encoding ({})", (Object)this.getEncoding());
        } else if (this.getEncoding() == null) {
            detectedEncoding = parsedHeader.getEncoding();
            this.LOGGER.debug("Default encoding and detected encoding not found. Using best guess encoding ({})", (Object)detectedEncoding);
        }
        return detectedEncoding;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
        this.LOGGER.debug("{} has opened an input document", (Object)this.getName());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        super.open(input, generateSkeleton);
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
        }
        this.currentRawDocument = input;
        if (this.getCurrentDocName() != null) {
            this.setDocumentName(this.getCurrentDocName());
        } else if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        try {
            String detectedEncoding = this.detectEncoding(input);
            input.setEncoding(detectedEncoding);
            this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
            if (this.document != null) {
                this.document.close();
            }
            this.document = new StreamedSource(input.getReader());
        }
        catch (IOException e) {
            throw new OkapiIOException("Filter could not open input stream", e);
        }
        this.currentDocName = null;
        this.startFilter();
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        while (this.nodeIterator.hasNext() && !this.isCanceled()) {
            Segment segment = this.nodeIterator.next();
            this.preProcess(segment);
            if (segment instanceof Tag) {
                Tag tag = (Tag)segment;
                if (tag.getBegin() < this.prevTagEnd) continue;
                this.prevTagEnd = tag.getEnd();
                if (tag.getTagType() == StartTagType.NORMAL || tag.getTagType() == StartTagType.UNREGISTERED) {
                    this.handleStartTag((StartTag)tag);
                } else if (tag.getTagType() == EndTagType.NORMAL || tag.getTagType() == EndTagType.UNREGISTERED) {
                    this.handleEndTag((EndTag)tag);
                } else if (tag.getTagType() == StartTagType.DOCTYPE_DECLARATION) {
                    this.handleDocTypeDeclaration(tag);
                } else if (tag.getTagType() == StartTagType.CDATA_SECTION) {
                    this.handleCdataSection(tag);
                } else if (tag.getTagType() == StartTagType.COMMENT) {
                    this.handleComment(tag);
                } else if (tag.getTagType() == StartTagType.XML_DECLARATION) {
                    this.handleXmlDeclaration(tag);
                } else if (tag.getTagType() == StartTagType.XML_PROCESSING_INSTRUCTION) {
                    this.handleProcessingInstruction(tag);
                } else if (tag.getTagType() != StartTagType.MARKUP_DECLARATION) {
                    if (tag.getTagType() == StartTagType.SERVER_COMMON) {
                        this.handleServerCommon(tag);
                    } else if (tag.getTagType() == StartTagType.SERVER_COMMON_ESCAPED) {
                        this.handleServerCommonEscaped(tag);
                    } else if (tag.getName().startsWith("%--")) {
                        this.handleDocumentPart(tag);
                    } else if (tag instanceof StartTag) {
                        this.handleStartTag((StartTag)tag);
                    } else if (tag instanceof EndTag) {
                        this.handleEndTag((EndTag)tag);
                    } else {
                        this.handleDocumentPart(tag);
                    }
                }
            } else if (segment instanceof CharacterEntityReference) {
                this.handleCharacterEntity((CharacterEntityReference)segment);
            } else if (segment instanceof NumericCharacterReference) {
                this.handleNumericEntity((NumericCharacterReference)segment);
            } else {
                this.handleText(segment.toString());
            }
            if (!this.eventBuilder.hasQueuedEvents()) continue;
            break;
        }
        if (!this.nodeIterator.hasNext()) {
            this.endFilter();
        }
        return this.eventBuilder.next();
    }

    protected AbstractMarkupEventBuilder createEventBuilder() {
        AbstractMarkupEventBuilder eb = new AbstractMarkupEventBuilder(this.getParentId(), this, this.getEncoderManager(), this.getEncoding(), this.getNewlineType());
        eb.setMimeType(this.getMimeType());
        return eb;
    }

    protected void startFilter() {
        if (this.eventBuilder == null) {
            this.eventBuilder = this.createEventBuilder();
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        boolean preserveWhitespace = true;
        boolean defaultExcludeRule = false;
        if (this.getConfig() != null) {
            preserveWhitespace = this.getConfig().isGlobalPreserveWhitespace();
            defaultExcludeRule = this.getConfig().isGlobalExcludeByDefault();
        }
        this.ruleState = new ExtractionRuleState(preserveWhitespace, defaultExcludeRule);
        this.setPreserveWhitespace(this.ruleState.isPreserveWhitespaceState());
        this.nodeIterator = this.document.iterator();
        this.cdataSectionIndex = 0;
        this.pcdataSectionIndex = 0;
        this.prevTagEnd = -1;
        TaggedFilterConfiguration config = this.getConfig();
        if (config != null && config.getGlobalCDATASubfilter() != null) {
            this.cdataFilter = this.getFilterConfigurationMapper().createFilter(this.getConfig().getGlobalCDATASubfilter(), this.cdataFilter);
        }
        if (config != null && config.getGlobalPCDATASubfilter() != null) {
            String subfilterName = this.getConfig().getGlobalPCDATASubfilter();
            this.pcdataFilter = this.getFilterConfigurationMapper().createFilter(subfilterName, this.pcdataFilter);
        }
        if (config != null && config.getSimplifierRules() != null) {
            this.eventBuilder.addFilterEvent(FilterUtil.createCodeSimplifierEvent(config.getSimplifierRules()));
        }
    }

    protected void endFilter() {
        this.eventBuilder.flushRemainingTempEvents();
        if (this.bufferedWhitespace.length() > 0) {
            this.eventBuilder.addDocumentPart(this.bufferedWhitespace.toString());
            this.bufferedWhitespace.setLength(0);
            this.bufferedWhitespace.trimToSize();
        }
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    protected void preProcess(Segment segment) {
        boolean isInsideTextRun = false;
        if (segment instanceof Tag) {
            Tag tag = (Tag)segment;
            TaggedFilterConfiguration.RULE_TYPE elementRuleTypeCandidate = this.getConfig().getElementRuleTypeCandidate(tag.getName());
            if (elementRuleTypeCandidate == TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT || elementRuleTypeCandidate == TaggedFilterConfiguration.RULE_TYPE.INLINE_EXCLUDED_ELEMENT || this.getEventBuilder().isInsideTextRun() && (tag.getTagType() == StartTagType.COMMENT || tag.getTagType() == StartTagType.XML_PROCESSING_INSTRUCTION)) {
                isInsideTextRun = true;
            }
        }
        if (this.bufferedWhitespace.length() > 0 && isInsideTextRun) {
            if (this.canStartNewTextUnit()) {
                this.startTextUnit(this.bufferedWhitespace.toString());
            } else {
                this.addToTextUnit(this.bufferedWhitespace.toString());
            }
        } else if (this.bufferedWhitespace.length() > 0) {
            this.addToDocumentPart(this.bufferedWhitespace.toString());
        }
        this.bufferedWhitespace.setLength(0);
        this.bufferedWhitespace.trimToSize();
    }

    protected void postProcessTextUnit(ITextUnit textUnit) {
    }

    protected void handleServerCommonEscaped(Tag tag) {
        this.handleDocumentPart(tag);
    }

    protected void handleServerCommon(Tag tag) {
        this.handleDocumentPart(tag);
    }

    protected void handleMarkupDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    protected void handleXmlDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    protected void handleDocTypeDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    protected void handleProcessingInstruction(Tag tag) {
        if (this.ruleState.isExludedState()) {
            this.addToDocumentPart(tag.toString());
            return;
        }
        if (this.isInsideTextRun()) {
            if (this.ruleState.isInlineExcludedState()) {
                this.eventBuilder.appendCodeData(tag.toString());
                return;
            }
            this.addCodeToCurrentTextUnit(tag);
        } else {
            this.handleDocumentPart(tag);
        }
    }

    protected void handleComment(Tag tag) {
        if (this.ruleState.isExludedState()) {
            this.addToDocumentPart(tag.toString());
            return;
        }
        if (this.isInsideTextRun()) {
            if (this.ruleState.isInlineExcludedState()) {
                this.eventBuilder.appendCodeData(tag.toString());
                return;
            }
            this.addCodeToCurrentTextUnit(tag);
        } else {
            this.handleDocumentPart(tag);
        }
    }

    protected void handleCdataSection(Tag tag) {
        if (!this.getConfig().isInlineCdata() && this.eventBuilder.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        }
        String cdataWithoutMarkers = CDATA_START_PATTERN.matcher(tag.toString()).replaceFirst("");
        cdataWithoutMarkers = CDATA_END_PATTERN.matcher(cdataWithoutMarkers).replaceFirst("");
        if (this.ruleState.isExludedState()) {
            this.addToDocumentPart(tag.toString());
        } else if (this.cdataFilter != null) {
            String parentName;
            String parentId = this.eventBuilder.findMostRecentParentId();
            if (parentId == null) {
                parentId = this.getDocumentId().getLastId();
            }
            if ((parentName = this.eventBuilder.findMostRecentParentName()) == null) {
                parentName = this.getDocumentId().getLastId();
            }
            try (SubFilter cdataSubfilter = new SubFilter(this.cdataFilter, null, ++this.cdataSectionIndex, parentId, parentName);){
                this.eventBuilder.addFilterEvents(cdataSubfilter.getEvents(new RawDocument(cdataWithoutMarkers, this.getSrcLoc())));
                this.addToDocumentPart("<![CDATA[");
                this.addToDocumentPart(cdataSubfilter.createRefCode().toString());
                this.addToDocumentPart("]]>");
            }
        } else if (this.getConfig().isInlineCdata()) {
            if (this.canStartNewTextUnit()) {
                this.startTextUnit();
            }
            this.addToTextUnit(new Code(TextFragment.TagType.OPENING, "cdata", "<![CDATA["));
            this.addToTextUnit(cdataWithoutMarkers);
            this.addToTextUnit(new Code(TextFragment.TagType.CLOSING, "cdata", "]]>"));
        } else {
            this.startTextUnit(new GenericSkeleton("<![CDATA["));
            this.addToTextUnit(cdataWithoutMarkers);
            this.setTextUnitType("cdata");
            this.setTextUnitMimeType("text/plain");
            this.endTextUnit(new GenericSkeleton("]]>"));
        }
    }

    protected void handleText(CharSequence text) {
        if (this.ruleState.isExludedState()) {
            this.addToDocumentPart(text.toString());
            return;
        }
        if (this.ruleState.isInlineExcludedState()) {
            this.eventBuilder.appendCodeData(text.toString());
            return;
        }
        if (this.isWhiteSpace(text) && !this.isInsideTextRun()) {
            if (this.bufferedWhitespace.length() <= 0) {
                this.bufferedWhitespace.append(text.toString());
            }
            return;
        }
        if (this.canStartNewTextUnit()) {
            this.startTextUnit(text.toString());
        } else {
            this.addToTextUnit(text.toString());
        }
    }

    protected boolean isWhiteSpace(CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Segment.isWhiteSpace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void handleNumericEntity(NumericCharacterReference entity) {
        if (this.ruleState.isExludedState() || this.ruleState.isInlineExcludedState()) {
            this.handleText(entity.toString());
        } else {
            this.handleText(CharacterReference.decode(entity.toString(), false));
        }
    }

    protected void handleCharacterEntity(CharacterEntityReference entity) {
        if (this.ruleState.isExludedState() || this.ruleState.isInlineExcludedState()) {
            this.handleText(entity.toString());
        } else {
            this.handleText(CharacterReference.decode(entity.toString(), false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleStartTag(StartTag startTag) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        startTag.getAttributes().populateMap(attributes, true);
        String idValue = null;
        TaggedFilterConfiguration.RULE_TYPE ruleType = this.getConfig().getConditionalElementRuleType(startTag.getName(), attributes);
        this.currentId = null;
        if (this.getConfig().isGlobalExcludeByDefault() && !startTag.isSyntacticalEmptyElementTag()) {
            switch (ruleType) {
                case TEXT_UNIT_ELEMENT: {
                    this.ruleState.pushIncludedRule(startTag.getName());
                    break;
                }
            }
        }
        try {
            if (this.ruleState.isExludedState()) {
                this.addToDocumentPart(startTag.toString());
                if (startTag.isSyntacticalEmptyElementTag()) return;
                this.updateStartTagRuleState(startTag.getName(), ruleType, idValue);
                return;
            }
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
            if (!startTag.isSyntacticalEmptyElementTag()) {
                this.updateStartTagRuleState(startTag.getName(), ruleType, idValue);
            }
            switch (ruleType) {
                case INLINE_EXCLUDED_ELEMENT: {
                    if (this.canStartNewTextUnit()) {
                        this.startTextUnit();
                    }
                    this.addCodeToCurrentTextUnit(startTag, false);
                    if (!startTag.isSyntacticalEmptyElementTag()) return;
                    this.eventBuilder.endCode();
                    return;
                }
                case INLINE_ELEMENT: {
                    if (this.ruleState.isInlineExcludedState()) {
                        this.eventBuilder.appendCodeData(startTag.toString());
                        return;
                    } else {
                        if (this.canStartNewTextUnit()) {
                            this.startTextUnit();
                        }
                        this.addCodeToCurrentTextUnit(startTag);
                        return;
                    }
                }
                case ATTRIBUTES_ONLY: {
                    this.handleAttributesThatAppearAnywhere(propertyTextUnitPlaceholders, startTag);
                    return;
                }
                case GROUP_ELEMENT: {
                    this.handleAttributesThatAppearAnywhere(propertyTextUnitPlaceholders, startTag);
                    return;
                }
                case EXCLUDED_ELEMENT: {
                    this.handleAttributesThatAppearAnywhere(propertyTextUnitPlaceholders, startTag);
                    return;
                }
                case INCLUDED_ELEMENT: {
                    this.handleAttributesThatAppearAnywhere(propertyTextUnitPlaceholders, startTag);
                    return;
                }
                case TEXT_UNIT_ELEMENT: {
                    this.handleAttributesThatAppearAnywhere(propertyTextUnitPlaceholders, startTag);
                    this.setTextUnitType(this.getConfig().getElementType(startTag));
                    return;
                }
                default: {
                    this.handleAttributesThatAppearAnywhere(propertyTextUnitPlaceholders, startTag);
                    return;
                }
            }
        }
        finally {
            if (this.eventBuilder.isCurrentTextUnit()) {
                ITextUnit tu = this.eventBuilder.peekMostRecentTextUnit();
                tu.setPreserveWhitespaces(this.ruleState.isPreserveWhitespaceState());
            }
        }
    }

    protected void updateStartTagRuleState(String tag, TaggedFilterConfiguration.RULE_TYPE ruleType, String idValue) {
        TaggedFilterConfiguration.RULE_TYPE r = this.getConfig().getElementRuleTypeCandidate(tag);
        switch (r) {
            case INLINE_EXCLUDED_ELEMENT: 
            case INLINE_ELEMENT: {
                this.ruleState.pushInlineRule(tag, ruleType);
                break;
            }
            case ATTRIBUTES_ONLY: {
                break;
            }
            case GROUP_ELEMENT: {
                this.ruleState.pushGroupRule(tag, ruleType);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.ruleState.pushExcludedRule(tag, ruleType);
                break;
            }
            case INCLUDED_ELEMENT: {
                this.ruleState.pushIncludedRule(tag, ruleType);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                this.ruleState.pushTextUnitRule(tag, ruleType, idValue);
                break;
            }
        }
        if (this.getConfig().isRuleType(tag, TaggedFilterConfiguration.RULE_TYPE.PRESERVE_WHITESPACE)) {
            this.ruleState.pushPreserverWhitespaceRule(tag, true);
            this.setPreserveWhitespace(this.ruleState.isPreserveWhitespaceState());
        }
    }

    protected TaggedFilterConfiguration.RULE_TYPE updateEndTagRuleState(EndTag endTag) {
        TaggedFilterConfiguration.RULE_TYPE ruleType = this.getConfig().getElementRuleTypeCandidate(endTag.getName());
        ExtractionRuleState.RuleType currentState = null;
        switch (ruleType) {
            case INLINE_EXCLUDED_ELEMENT: 
            case INLINE_ELEMENT: {
                currentState = this.ruleState.popInlineRule();
                ruleType = currentState.ruleType;
                break;
            }
            case ATTRIBUTES_ONLY: {
                break;
            }
            case GROUP_ELEMENT: {
                currentState = this.ruleState.popGroupRule();
                ruleType = currentState.ruleType;
                break;
            }
            case EXCLUDED_ELEMENT: {
                currentState = this.ruleState.popExcludedIncludedRule();
                ruleType = currentState.ruleType;
                break;
            }
            case INCLUDED_ELEMENT: {
                currentState = this.ruleState.popExcludedIncludedRule();
                ruleType = currentState.ruleType;
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                currentState = this.ruleState.popTextUnitRule();
                ruleType = currentState.ruleType;
                break;
            }
        }
        if (currentState != null && !currentState.ruleName.equalsIgnoreCase(endTag.getName())) {
            String character = Integer.toString(endTag.getBegin());
            throw new OkapiBadFilterInputException("End tag " + endTag.getName() + " and start tag " + currentState.ruleName + " do not match at character number " + character);
        }
        return ruleType;
    }

    private void handleAttributesThatAppearAnywhere(List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders, StartTag tag) {
        if (this.pcdataFilter != null && tag.getAttributes().length() != 0) {
            this.handleAttributeSubfiltering(tag);
            return;
        }
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        switch (this.getConfig().getConditionalElementRuleType(tag.getName(), tag.getAttributes().populateMap(attributeMap, true))) {
            case TEXT_UNIT_ELEMENT: {
                if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                    this.startTextUnit(new GenericSkeleton(tag.toString()), propertyTextUnitPlaceholders);
                    break;
                }
                if (!tag.isSyntacticalEmptyElementTag()) {
                    this.startTextUnit(new GenericSkeleton(tag.toString()));
                    break;
                }
                this.addToDocumentPart(tag.toString());
                break;
            }
            case GROUP_ELEMENT: {
                if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                    this.startGroup(new GenericSkeleton(tag.toString()), this.getConfig().getElementType(tag), this.getSrcLoc(), propertyTextUnitPlaceholders);
                    break;
                }
                if (!tag.isSyntacticalEmptyElementTag()) {
                    this.startGroup(new GenericSkeleton(tag.toString()), this.getConfig().getElementType(tag));
                    break;
                }
                this.addToDocumentPart(tag.toString());
                break;
            }
            default: {
                if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                    this.startDocumentPart(tag.toString(), tag.getName(), propertyTextUnitPlaceholders);
                    this.endDocumentPart();
                    break;
                }
                this.addToDocumentPart(tag.toString());
            }
        }
    }

    private void handleAttributeSubfiltering(StartTag startTag) {
        this.addToDocumentPart("<" + startTag.getNameSegment().toString() + " ");
        this.endDocumentPart();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (Attribute attr : startTag.parseAttributes()) {
            attributeMap.clear();
            TaggedFilterConfiguration.RULE_TYPE attrRuleType = this.getConfig().findMatchingAttributeRule(startTag.getName(), startTag.getAttributes().populateMap(attributeMap, true), attr.getName());
            if (attrRuleType == TaggedFilterConfiguration.RULE_TYPE.ATTRIBUTE_TRANS) {
                this.addToDocumentPart(attr.getName() + "=" + attr.getQuoteChar());
                this.endDocumentPart();
                SubFilter pcdataSubfilter = new SubFilter(this.pcdataFilter, new XMLEncoder(this.getEncoding(), this.getNewlineType(), true, true, false, QuoteMode.UNESCAPED), 0, "null", "null");
                Throwable throwable = null;
                try {
                    this.eventBuilder.addFilterEvents(pcdataSubfilter.getEvents(new RawDocument(attr.getValue(), this.getSrcLoc())));
                    this.addToDocumentPart(attr.getQuoteChar() + " ");
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pcdataSubfilter == null) continue;
                    if (throwable != null) {
                        try {
                            pcdataSubfilter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pcdataSubfilter.close();
                    continue;
                }
            }
            this.addToDocumentPart(attr.toString() + " ");
        }
        if (startTag.isSyntacticalEmptyElementTag()) {
            this.addToDocumentPart("/>");
        } else {
            this.addToDocumentPart(">");
        }
        this.endDocumentPart();
    }

    /*
     * Unable to fully structure code
     */
    protected void handleEndTag(EndTag endTag) {
        if (this.ruleState.isExludedState()) {
            this.addToDocumentPart(endTag.toString());
            this.updateEndTagRuleState(endTag);
            this.clarifyPreserveWhitespaceState(endTag);
            return;
        }
        ruleType = this.updateEndTagRuleState(endTag);
        if (this.getConfig().isGlobalExcludeByDefault()) {
            switch (1.$SwitchMap$net$sf$okapi$filters$abstractmarkup$config$TaggedFilterConfiguration$RULE_TYPE[ruleType.ordinal()]) {
                case 1: {
                    this.ruleState.popExcludedIncludedRule();
                    break;
                }
            }
        }
        switch (1.$SwitchMap$net$sf$okapi$filters$abstractmarkup$config$TaggedFilterConfiguration$RULE_TYPE[ruleType.ordinal()]) {
            case 2: {
                this.eventBuilder.endCode(endTag.toString());
                break;
            }
            case 3: {
                if (this.ruleState.isInlineExcludedState()) {
                    this.eventBuilder.appendCodeData(endTag.toString());
                    break;
                }
                if (this.canStartNewTextUnit()) {
                    this.startTextUnit();
                }
                this.addCodeToCurrentTextUnit(endTag);
                break;
            }
            case 5: {
                this.endGroup(new GenericSkeleton(endTag.toString()));
                break;
            }
            case 6: {
                this.addToDocumentPart(endTag.toString());
                break;
            }
            case 7: {
                this.addToDocumentPart(endTag.toString());
                break;
            }
            case 1: {
                if (!this.isInsideTextRun()) {
                    this.endTextUnit(new GenericSkeleton(endTag.toString()));
                    break;
                }
                if (this.pcdataFilter == null) ** GOTO lbl82
                pcdata = this.peekTempEvent().getTextUnit();
                parentId = this.eventBuilder.findMostRecentParentId();
                if (parentId == null) {
                    parentId = pcdata.getId();
                }
                if (parentId == null) {
                    parentId = this.getDocumentId().getLastId();
                }
                if ((parentName = this.eventBuilder.findMostRecentParentName()) == null) {
                    parentName = pcdata.getType();
                }
                if (parentName == null) {
                    parentName = this.getDocumentId().getLastId();
                }
                pcdataSubfilter = new SubFilter(this.pcdataFilter, new XMLEncoder(this.getEncoding(), this.getNewlineType(), true, true, false, QuoteMode.UNESCAPED), ++this.pcdataSectionIndex, parentId, parentName);
                var7_8 = null;
                this.eventBuilder.convertTempTextUnitToDocumentPart();
                this.eventBuilder.addFilterEvents(pcdataSubfilter.getEvents(new RawDocument(pcdata.getSource().toString(), this.getSrcLoc())));
                this.addToDocumentPart(pcdataSubfilter.createRefCode().toString());
                this.addToDocumentPart(endTag.toString());
                if (pcdataSubfilter == null) break;
                if (var7_8 == null) ** GOTO lbl65
                try {
                    pcdataSubfilter.close();
                }
                catch (Throwable var8_9) {
                    var7_8.addSuppressed(var8_9);
                }
                break;
lbl65:
                // 1 sources

                pcdataSubfilter.close();
                break;
                catch (Throwable var8_10) {
                    try {
                        var7_8 = var8_10;
                        throw var8_10;
                    }
                    catch (Throwable var9_11) {
                        if (pcdataSubfilter != null) {
                            if (var7_8 != null) {
                                try {
                                    pcdataSubfilter.close();
                                }
                                catch (Throwable var10_12) {
                                    var7_8.addSuppressed(var10_12);
                                }
                            } else {
                                pcdataSubfilter.close();
                            }
                        }
                        throw var9_11;
                    }
                }
lbl82:
                // 1 sources

                tempTu = this.peekTempEvent().getTextUnit();
                if (!tempTu.getSource().hasText(true)) {
                    this.eventBuilder.convertTempTextUnitToDocumentPart();
                    this.addToDocumentPart(endTag.toString());
                    break;
                }
                this.endTextUnit(new GenericSkeleton(endTag.toString()));
                break;
            }
            default: {
                this.addToDocumentPart(endTag.toString());
            }
        }
        this.clarifyPreserveWhitespaceState(endTag);
    }

    private void clarifyPreserveWhitespaceState(EndTag endTag) {
        if (this.ruleState.isPreserveWhitespaceState() && this.ruleState.peekPreserverWhitespaceRule().ruleName.equalsIgnoreCase(endTag.getName())) {
            this.ruleState.popPreserverWhitespaceRule();
            this.setPreserveWhitespace(this.ruleState.isPreserveWhitespaceState());
        }
    }

    protected void handleDocumentPart(Tag tag) {
        this.addToDocumentPart(tag.toString());
    }

    protected abstract String normalizeAttributeName(String var1, String var2, Tag var3);

    protected void addCodeToCurrentTextUnit(Tag tag) {
        this.addCodeToCurrentTextUnit(tag, true);
    }

    protected TextFragment.TagType determineTagType(Tag tag) {
        StartTag startTag;
        TextFragment.TagType codeType = tag.getTagType() == StartTagType.NORMAL || tag.getTagType() == StartTagType.UNREGISTERED ? ((startTag = (StartTag)tag).isSyntacticalEmptyElementTag() ? TextFragment.TagType.PLACEHOLDER : (this.ruleState.isInlineExcludedState() ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.OPENING)) : (tag.getTagType() == EndTagType.NORMAL || tag.getTagType() == EndTagType.UNREGISTERED ? TextFragment.TagType.CLOSING : TextFragment.TagType.PLACEHOLDER);
        return codeType;
    }

    protected void addCodeToCurrentTextUnit(Tag tag, boolean endCodeNow) {
        String literalTag = tag.toString();
        TextFragment.TagType codeType = this.determineTagType(tag);
        Code codeToAdd = new Code(codeType, this.getConfig().getElementType(tag), literalTag);
        if (tag.getTagType() == StartTagType.NORMAL || tag.getTagType() == StartTagType.UNREGISTERED) {
            StartTag startTag = (StartTag)tag;
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
            if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty() && !this.ruleState.isInlineExcludedState()) {
                this.addToTextUnit(codeToAdd, endCodeNow, propertyTextUnitPlaceholders);
            } else {
                this.addToTextUnit(codeToAdd, endCodeNow);
            }
        } else {
            this.addToTextUnit(codeToAdd);
        }
    }

    protected List<PropertyTextUnitPlaceholder> createPropertyTextUnitPlaceholders(StartTag startTag) {
        LinkedList<PropertyTextUnitPlaceholder> propertyOrTextUnitPlaceholders = new LinkedList<PropertyTextUnitPlaceholder>();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (Attribute attribute : startTag.parseAttributes()) {
            attributeMap.clear();
            if (Util.isEmpty(attribute.getValue()) || Util.isEmpty(attribute.getValueSegment().toString())) continue;
            switch (this.getConfig().findMatchingAttributeRule(startTag.getName(), startTag.getAttributes().populateMap(attributeMap, true), attribute.getName())) {
                case ATTRIBUTE_TRANS: {
                    propertyOrTextUnitPlaceholders.add(this.createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType.TRANSLATABLE, attribute.getName(), attribute.getValue(), startTag, attribute));
                    break;
                }
                case ATTRIBUTE_WRITABLE: {
                    propertyOrTextUnitPlaceholders.add(this.createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType.WRITABLE_PROPERTY, attribute.getName(), attribute.getValueSegment().toString(), startTag, attribute));
                    break;
                }
                case ATTRIBUTE_READONLY: {
                    propertyOrTextUnitPlaceholders.add(this.createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType.READ_ONLY_PROPERTY, attribute.getName(), attribute.getValue(), startTag, attribute));
                    break;
                }
                case ATTRIBUTE_ID: {
                    propertyOrTextUnitPlaceholders.add(this.createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType.NAME, attribute.getName(), attribute.getValue(), startTag, attribute));
                    this.currentId = attribute.getValue() + "-" + attribute.getName();
                    break;
                }
                case ATTRIBUTE_PRESERVE_WHITESPACE: {
                    boolean preserveWS = this.getConfig().isPreserveWhitespaceCondition(attribute.getName(), attributeMap);
                    boolean defaultWS = this.getConfig().isDefaultWhitespaceCondition(attribute.getName(), attributeMap);
                    if (!preserveWS && !defaultWS) break;
                    this.ruleState.pushPreserverWhitespaceRule(startTag.getName(), preserveWS);
                    this.setPreserveWhitespace(this.ruleState.isPreserveWhitespaceState());
                    propertyOrTextUnitPlaceholders.add(this.createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType.WRITABLE_PROPERTY, attribute.getName(), attribute.getValue(), startTag, attribute));
                    break;
                }
            }
        }
        return propertyOrTextUnitPlaceholders;
    }

    protected PropertyTextUnitPlaceholder createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType type, String name, String value, Tag tag, Attribute attribute) {
        int mainStartPos = attribute.getBegin() - tag.getBegin();
        int mainEndPos = attribute.getEnd() - tag.getBegin();
        int valueStartPos = attribute.getValueSegment().getBegin() - tag.getBegin();
        int valueEndPos = attribute.getValueSegment().getEnd() - tag.getBegin();
        return new PropertyTextUnitPlaceholder(type, this.normalizeAttributeName(name, value, tag), value, mainStartPos, mainEndPos, valueStartPos, valueEndPos);
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    protected boolean isBOM() {
        return this.hasBOM;
    }

    protected boolean isDocumentEncoding() {
        return this.documentEncoding;
    }

    protected boolean isPreserveWhitespace() {
        return this.ruleState.isPreserveWhitespaceState();
    }

    protected void setPreserveWhitespace(boolean preserveWhitespace) {
        this.eventBuilder.setPreserveWhitespace(preserveWhitespace);
    }

    protected void setTextUnitPreserveWhitespace(boolean preserveWhitespace) {
        this.eventBuilder.setTextUnitPreserveWhitespace(preserveWhitespace);
    }

    protected void addToDocumentPart(String part) {
        this.eventBuilder.addToDocumentPart(part);
    }

    protected void addToTextUnit(String text) {
        this.eventBuilder.addToTextUnit(text);
    }

    protected void startTextUnit(String text) {
        this.eventBuilder.startTextUnit(text);
        this.setTextUnitName(this.currentId);
    }

    protected void setTextUnitName(String name) {
        String n = name;
        if (name == null) {
            n = this.eventBuilder.findMostRecentTextUnitName();
        }
        this.eventBuilder.setTextUnitName(n);
        this.currentId = null;
    }

    protected void setTextUnitType(String type) {
        this.eventBuilder.setTextUnitType(type);
    }

    protected void setTextUnitTranslatable(boolean translatable) {
        this.eventBuilder.setTextUnitTranslatable(translatable);
    }

    protected void setCurrentDocName(String currentDocName) {
        this.currentDocName = currentDocName;
    }

    protected String getCurrentDocName() {
        return this.currentDocName;
    }

    protected boolean canStartNewTextUnit() {
        return this.eventBuilder.canStartNewTextUnit();
    }

    protected boolean isInsideTextRun() {
        return this.eventBuilder.isInsideTextRun();
    }

    protected void addToTextUnit(Code code, boolean endCodeNow) {
        this.eventBuilder.addToTextUnit(code, endCodeNow);
    }

    protected void addToTextUnit(Code code) {
        this.eventBuilder.addToTextUnit(code);
    }

    protected void addToTextUnit(Code code, boolean endCodeNow, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.eventBuilder.addToTextUnit(code, endCodeNow, propertyTextUnitPlaceholders);
    }

    protected void addToTextUnit(Code code, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.eventBuilder.addToTextUnit(code, true, propertyTextUnitPlaceholders);
    }

    protected void endDocumentPart() {
        this.eventBuilder.endDocumentPart();
    }

    protected void startDocumentPart(String part, String name, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.eventBuilder.startDocumentPart(part, name, propertyTextUnitPlaceholders);
    }

    protected void startGroup(GenericSkeleton startMarker, String commonTagType) {
        this.eventBuilder.startGroup(startMarker, commonTagType);
    }

    protected void startGroup(GenericSkeleton startMarker, String commonTagType, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.eventBuilder.startGroup(startMarker, commonTagType, locale, propertyTextUnitPlaceholders);
    }

    protected void startTextUnit(GenericSkeleton startMarker) {
        this.eventBuilder.startTextUnit(startMarker);
        this.setTextUnitName(this.currentId);
    }

    protected void startTextUnit(GenericSkeleton startMarker, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.eventBuilder.startTextUnit(startMarker, propertyTextUnitPlaceholders);
        this.setTextUnitName(this.currentId);
    }

    protected void endTextUnit(GenericSkeleton endMarker) {
        this.eventBuilder.endTextUnit(endMarker);
    }

    protected void endGroup(GenericSkeleton endMarker) {
        this.eventBuilder.endGroup(endMarker);
    }

    protected void startTextUnit() {
        this.eventBuilder.startTextUnit();
        this.setTextUnitName(this.currentId);
    }

    protected long getTextUnitId() {
        return this.eventBuilder.getTextUnitId();
    }

    protected void setTextUnitId(long id) {
        this.eventBuilder.setTextUnitId(id);
    }

    protected long getGroupIdSequence() {
        return this.eventBuilder.getGroupIdSequence();
    }

    protected void setGroupIdSequence(long id) {
        this.eventBuilder.setGroupIdSequence(id);
    }

    protected void setTextUnitMimeType(String mimeType) {
        this.eventBuilder.setTextUnitMimeType(mimeType);
    }

    protected long getDocumentPartId() {
        return this.eventBuilder.getDocumentPartId();
    }

    protected void setDocumentPartId(long id) {
        this.eventBuilder.setDocumentPartId(id);
    }

    protected void appendToFirstSkeletonPart(String text) {
        this.eventBuilder.appendToFirstSkeletonPart(text);
    }

    protected void addFilterEvent(Event event) {
        this.eventBuilder.addFilterEvent(event);
    }

    protected Event popTempEvent() {
        return this.eventBuilder.popTempEvent();
    }

    protected Event peekTempEvent() {
        return this.eventBuilder.peekTempEvent();
    }

    protected ExtractionRuleState getRuleState() {
        return this.ruleState;
    }

    public AbstractMarkupEventBuilder getEventBuilder() {
        return this.eventBuilder;
    }

    @Override
    public void setMimeType(String mimeType) {
        super.setMimeType(mimeType);
    }

    public StringBuilder getBufferedWhiteSpace() {
        return this.bufferedWhitespace;
    }

    static {
        Config.ConvertNonBreakingSpaces = false;
        Config.IsHTMLEmptyElementTagRecognised = true;
        Config.NewLine = BOMNewlineEncodingDetector.NewlineType.LF.toString();
        Config.LoggerProvider = LoggerProvider.SLF4J;
        Config.CurrentCharacterReferenceEncodingBehaviour = Config.LEGACY_CHARACTER_REFERENCE_ENCODING_BEHAVIOUR;
        Attributes.setDefaultMaxErrorCount(15);
    }
}

