/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.markdown.MarkdownEventBuilder;
import net.sf.okapi.filters.markdown.MarkdownFilterWriter;
import net.sf.okapi.filters.markdown.MarkdownLinePrefixAnnotation;
import net.sf.okapi.filters.markdown.MarkdownSkeletonWriter;
import net.sf.okapi.filters.markdown.Parameters;
import net.sf.okapi.filters.markdown.parser.MarkdownParser;
import net.sf.okapi.filters.markdown.parser.MarkdownToken;
import net.sf.okapi.filters.markdown.parser.MarkdownTokenType;
import net.sf.okapi.filters.yaml.YamlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class MarkdownFilter
extends AbstractFilter {
    private static final String DEFAULT_HTML_SUBFILTER_CONFIG_SPEC = "okf_html@for_markdown.fprm";
    private static final Pattern HTML_CDATA_PAT = Pattern.compile("\\<!\\[CDATA\\[(.*)\\]\\]\\>");
    private static final Pattern TAIL_SPACES_PAT = Pattern.compile(" *$");
    private static final Code CDATA_START_CODE = new Code(TextFragment.TagType.OPENING, "cdata", "<![CDATA[");
    private static final Code CDATA_END_CODE = new Code(TextFragment.TagType.CLOSING, "cdata", "]]>");
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private MarkdownParser parser;
    private Parameters params = new Parameters();
    private RawDocument currentRawDocument;
    private BOMNewlineEncodingDetector detector;
    private HtmlFilter htmlFilter;
    private int htmlSectionIndex;
    private MarkdownEventBuilder eventBuilder;
    private YamlFilter yamlFilter;
    private static final String DEFAULT_YAML_SUBFILTER_CONFIG_SPEC = "okf_yaml@for_markdown.fprm";
    private int yamlSectionIndex;
    private MarkdownLinePrefixAnnotation lpa = new MarkdownLinePrefixAnnotation("");
    private MarkdownLinePrefixAnnotation lpabl = new MarkdownLinePrefixAnnotation("");

    public MarkdownFilter() {
        this.parser = new MarkdownParser(this.params);
        this.setMimeType("text/x-markdown");
        this.setMultilingual(false);
        this.setName("okf_markdown");
        this.setDisplayName("Markdown Filter");
        this.setFilterWriter(this.createFilterWriter());
        this.addConfiguration(new FilterConfiguration(this.getName(), "text/x-markdown", this.getClass().getName(), "Markdown", "Markdown files", null, ".md;.markdown"));
        this.htmlFilter = new HtmlFilter();
        InputStream configStream = this.getClass().getResourceAsStream(DEFAULT_HTML_SUBFILTER_CONFIG_SPEC);
        this.htmlFilter.getParameters().load(configStream, false);
        this.yamlFilter = new YamlFilter();
        InputStream configStream2 = this.getClass().getResourceAsStream(DEFAULT_YAML_SUBFILTER_CONFIG_SPEC);
        this.yamlFilter.getParameters().load(configStream2, false);
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
            this.detector = null;
            this.eventBuilder = null;
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new MarkdownSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        IFilterWriter filterWriter = this.getFilterWriter();
        if (filterWriter != null) {
            return filterWriter;
        }
        return new MarkdownFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasQueuedEvents();
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.detector != null && this.detector.hasUtf8Bom();
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.detector != null && this.detector.hasUtf8Encoding();
    }

    @Override
    public Event next() {
        if (this.hasNext()) {
            Event e = this.eventBuilder.next();
            if (this.LOGGER.isDebugEnabled()) {
                FilterUtil.logDebugEvent(e, "", this.LOGGER);
            }
            return e;
        }
        throw new IllegalStateException("No events available");
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        super.open(input, generateSkeleton);
        this.htmlSectionIndex = 0;
        this.yamlSectionIndex = 0;
        this.currentRawDocument = input;
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setNewlineType(this.detector.getNewlineType().toString());
        String detectedEncoding = this.getDetectedEncoding();
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        this.parser = new MarkdownParser(this.params);
        this.generateTokens();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(this.parser.toString());
        }
        if (!Util.isEmpty(this.params.getHtmlSubfilter())) {
            this.htmlFilter = (HtmlFilter)this.getFilterConfigurationMapper().createFilter(this.params.getHtmlSubfilter(), this.htmlFilter);
            if (this.htmlFilter == null) {
                throw new OkapiBadFilterInputException("Unknown subfilter: " + this.params.getHtmlSubfilter());
            }
        }
        if (!Util.isEmpty(this.params.getYamlSubfilter())) {
            this.yamlFilter = (YamlFilter)this.getFilterConfigurationMapper().createFilter(this.params.getYamlSubfilter(), this.yamlFilter);
            if (this.yamlFilter == null) {
                throw new OkapiBadFilterInputException("Unknown subfilter: " + this.params.getYamlSubfilter());
            }
        }
        this.yamlFilter.setFilterConfigurationMapper(this.getFilterConfigurationMapper());
        if (this.eventBuilder == null) {
            this.eventBuilder = new MarkdownEventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setPreserveWhitespace(true);
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
            this.eventBuilder.setCodeFinder(this.params.getCodeFinder());
        }
        this.generateEvents();
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
        this.createSkeletonWriter();
        this.getEncoderManager();
    }

    private String getDetectedEncoding() {
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Overridding user set encoding (if any). Setting auto-detected encoding {}.", (Object)detectedEncoding);
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Default encoding and detected encoding not found. Using best guess encoding {}", (Object)detectedEncoding);
        }
        return detectedEncoding;
    }

    private void generateTokens() {
        this.parser.setNewline(this.getNewlineType());
        try (Scanner scanner = new Scanner(this.currentRawDocument.getReader());){
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                this.parser.parse(scanner.next());
            }
        }
    }

    private void generateEvents() {
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Generating Events from the following tokens...\n{}", (Object)this.parser.dumpTokens());
        }
        String content = "";
        while (this.parser.hasNextToken()) {
            MarkdownToken token = this.parser.getNextToken();
            if (token.getType().equals((Object)MarkdownTokenType.END_TEXT_UNIT)) {
                this.endTUIfCurrent();
                continue;
            }
            if (token.getType().equals((Object)MarkdownTokenType.LINE_PREFIX)) {
                this.lpa = new MarkdownLinePrefixAnnotation(token.getContent());
                this.lpabl = new MarkdownLinePrefixAnnotation(TAIL_SPACES_PAT.matcher(token.getContent()).replaceFirst(""));
                this.endTUIfCurrent();
                continue;
            }
            if (token.getType().equals((Object)MarkdownTokenType.YAML_METADATA_HEADER)) {
                this.endTUIfCurrent();
                this.eventBuilder.addFilterEvents(this.processByYamlFilter(token.getContent()));
                continue;
            }
            if (this.isMaybeTranslatableHtmlBlock(token)) {
                this.endTUIfCurrent();
                EventsAndRefCode er = this.processByHtmlFilter(token.getContent());
                this.eventBuilder.addFilterEvents(er.events);
                this.eventBuilder.addToDocumentPart(er.refCode.toString());
                continue;
            }
            if (token.getType().equals((Object)MarkdownTokenType.HTML_INLINE)) {
                String tag = token.getContent();
                Matcher m = HTML_CDATA_PAT.matcher(tag);
                if (m.matches()) {
                    String cdataText = m.group(1);
                    this.startTUIfNotCurrent();
                    this.eventBuilder.addToTextUnit(CDATA_START_CODE.clone());
                    this.eventBuilder.addToTextUnit(cdataText);
                    this.eventBuilder.addToTextUnit(CDATA_END_CODE.clone());
                    continue;
                }
                EventsAndRefCode er = this.processByHtmlFilter(tag);
                for (Event e : er.events) {
                    if (e.isTextUnit()) {
                        ITextUnit tu = e.getTextUnit();
                        if (tu.isReferent()) {
                            this.eventBuilder.addFilterEvent(e);
                            continue;
                        }
                        this.verifyOurTUAssumptions(tu, tag);
                        if (tu.getSkeleton() != null) {
                            this.endTUIfCurrent();
                            this.eventBuilder.addFilterEvent(e);
                            continue;
                        }
                        this.startTUIfNotCurrent();
                        for (TextPart tp : tu.getSource().getParts()) {
                            TextFragment tf = tp.text;
                            if (!TextFragment.MARKERS_REGEX.matcher(tf.getCodedText()).replaceAll("").isEmpty()) {
                                this.LOGGER.warn("TextFragment of a TextUnit generated for the HTML Inline tag \"{}\" has non-code text \"{}\". This is unexpected and non-code part will be discarded.", (Object)tag, (Object)tf.getText());
                            }
                            for (Code c : tf.getCodes()) {
                                c = c.clone();
                                c.setTagType(TextFragment.TagType.PLACEHOLDER);
                                this.eventBuilder.addToTextUnit(c);
                            }
                        }
                        continue;
                    }
                    if (e.isDocumentPart()) {
                        this.endTUIfCurrent();
                        e.getDocumentPart().setAnnotation(this.lpa);
                        this.eventBuilder.addFilterEvent(e);
                        continue;
                    }
                    if (e.isStartSubfilter() || e.isEndSubfilter()) {
                        this.LOGGER.debug("{} event from HTML subfilter for \"{}\" being ignored.", (Object)e.getEventType().name(), (Object)tag);
                        continue;
                    }
                    this.LOGGER.warn("Unexpected {} event from HTML subfilter for \"{}\". Ignored.", (Object)e.getEventType().name(), (Object)tag);
                }
                continue;
            }
            if (this.isDocumentPart(token)) {
                this.endTUIfCurrent();
                if (token.getType().equals((Object)MarkdownTokenType.BLANK_LINE)) {
                    this.eventBuilder.addDocumentPart(token.getContent()).setAnnotation(this.lpabl);
                    continue;
                }
                this.eventBuilder.addDocumentPart(token.getContent()).setAnnotation(this.lpa);
                continue;
            }
            if (this.isInlineMarkup(token)) {
                this.startTUIfNotCurrent();
                this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, token.getType().name(), Util.normalizeNewlines(token.getContent())));
                continue;
            }
            if (this.isCode(token)) {
                this.insertCodeOrDocPart(token.getType().name(), token.getContent());
                continue;
            }
            if (token.isTranslatable()) {
                this.startTUIfNotCurrent();
                this.eventBuilder.addToTextUnit(Util.normalizeNewlines(token.getContent()));
                continue;
            }
            this.eventBuilder.addDocumentPart(token.getContent()).setAnnotation(this.lpa);
        }
        this.endTUIfCurrent();
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    private void startTUIfNotCurrent() {
        if (!this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.startTextUnit();
            ITextUnit tu = this.eventBuilder.peekMostRecentTextUnit();
            tu.setAnnotation(this.lpa);
        }
    }

    private void endTUIfCurrent() {
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit();
        }
    }

    private void verifyOurTUAssumptions(ITextUnit tu, String tag) {
        if (tu.getAnnotations() != null && tu.getAnnotations().iterator().hasNext()) {
            this.LOGGER.error("TU has annotation(s): {}", (Object)tu.getAnnotations().toString());
        }
        if (tu.getSkeleton() != null && !tu.getSource().isEmpty()) {
            this.LOGGER.error("TU has a skeleton \"{}\" and a non-empty source \"{}\" at the same time.", (Object)tu.getSkeleton().toString(), (Object)tu.getSource().getFirstContent().toText());
        }
        if (tu.getSkeleton() != null && !tu.getSkeleton().toString().replaceAll(Pattern.quote("[#$") + ".*" + Pattern.quote("]"), "").equals(tag)) {
            this.LOGGER.error("TU skeleton \"{}\" doesn't match with the original tag \"{}\"", (Object)tu.getSkeleton().toString(), (Object)tag);
        }
    }

    private EventsAndRefCode processByHtmlFilter(String content) {
        String parentName;
        String parentId = this.eventBuilder.findMostRecentParentId();
        if (parentId == null) {
            parentId = this.getDocumentId().getLastId();
        }
        if ((parentName = this.eventBuilder.findMostRecentParentName()) == null) {
            parentName = this.getDocumentId().getLastId();
        }
        try (SubFilter htmlsf = new SubFilter(this.htmlFilter, this.getEncoderManager(), ++this.htmlSectionIndex, parentId, parentName);){
            List<Event> subEvents = htmlsf.getEvents(new RawDocument(content, this.getSrcLoc()));
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("---- Events from HTML subfilter ----\nInput: \"{}\"", (Object)content);
                FilterUtil.logDebugEvents(subEvents, this.LOGGER);
                this.LOGGER.debug("---- End of HTML subfilter events ----");
            }
            EventsAndRefCode ret = new EventsAndRefCode();
            ret.events = subEvents;
            ret.refCode = htmlsf.createRefCode();
            EventsAndRefCode eventsAndRefCode = ret;
            return eventsAndRefCode;
        }
    }

    private List<Event> processByYamlFilter(String content) {
        String parentName;
        String parentId = this.eventBuilder.findMostRecentParentId();
        if (parentId == null) {
            parentId = this.getDocumentId().getLastId();
        }
        if ((parentName = this.eventBuilder.findMostRecentParentName()) == null) {
            parentName = this.getDocumentId().getLastId();
        }
        try (SubFilter yamlsf = new SubFilter(this.yamlFilter, this.getEncoderManager(), ++this.yamlSectionIndex, parentId, parentName);){
            List<Event> subEvents = yamlsf.getEvents(new RawDocument(content, this.getSrcLoc()));
            subEvents.stream().filter(event -> event.getEventType() == EventType.TEXT_UNIT).forEach(event -> event.getTextUnit().setPreserveWhitespaces(this.eventBuilder.isPreserveWhitespace()));
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("---- Events from YAML subfilter for \"{}\". ----", (Object)content);
                FilterUtil.logDebugEvents(subEvents, this.LOGGER);
                this.LOGGER.debug("---- End of YAML subfilter events ----");
            }
            List<Event> list = subEvents;
            return list;
        }
    }

    private void insertCodeOrDocPart(String type, String data) {
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, type, Util.normalizeNewlines(data)));
        } else {
            this.eventBuilder.addDocumentPart(data).setAnnotation(this.lpa);
        }
    }

    private boolean isCode(MarkdownToken token) {
        return token != null && !this.isNewline(token) && !token.isTranslatable() && !this.isMaybeTranslatableHtmlBlock(token) && !token.getType().equals((Object)MarkdownTokenType.TEXT);
    }

    private boolean isMaybeTranslatableHtmlBlock(MarkdownToken token) {
        if (token == null) {
            return false;
        }
        MarkdownTokenType ttype = token.getType();
        return ttype.equals((Object)MarkdownTokenType.HTML_BLOCK) || ttype.equals((Object)MarkdownTokenType.HTML_INNER_BLOCK);
    }

    private boolean isNewline(MarkdownToken token) {
        return token != null && (token.getType().equals((Object)MarkdownTokenType.SOFT_LINE_BREAK) || token.getType().equals((Object)MarkdownTokenType.BLANK_LINE));
    }

    private boolean isDocumentPart(MarkdownToken token) {
        if (token == null) {
            return false;
        }
        MarkdownTokenType ttype = token.getType();
        return token != null && !token.isTranslatable() && (this.isNewline(token) || ttype.equals((Object)MarkdownTokenType.BULLET_LIST_ITEM) || ttype.equals((Object)MarkdownTokenType.ORDERED_LIST_ITEM) || ttype.equals((Object)MarkdownTokenType.FENCED_CODE_BLOCK) || ttype.equals((Object)MarkdownTokenType.FENCED_CODE_BLOCK_INFO) || ttype.equals((Object)MarkdownTokenType.HEADING_PREFIX) || ttype.equals((Object)MarkdownTokenType.HEADING_UNDERLINE) || ttype.equals((Object)MarkdownTokenType.THEMATIC_BREAK) || ttype.equals((Object)MarkdownTokenType.REFERENCE) || ttype.equals((Object)MarkdownTokenType.WHITE_SPACE) || ttype.equals((Object)MarkdownTokenType.TABLE_PIPE) || ttype.equals((Object)MarkdownTokenType.TABLE_SEPARATOR) || ttype.equals((Object)MarkdownTokenType.HTML_INNER_BLOCK_COMMENT) || ttype.equals((Object)MarkdownTokenType.HTML_COMMENT_BLOCK) || ttype.equals((Object)MarkdownTokenType.YAML_METADATA_HEADER));
    }

    private boolean isInlineMarkup(MarkdownToken token) {
        if (token == null) {
            return false;
        }
        return token.getType().isInline();
    }

    private static class EventsAndRefCode {
        List<Event> events;
        Code refCode;

        private EventsAndRefCode() {
        }
    }
}

