/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown.parser;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.AllNodesVisitor;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.filters.markdown.Parameters;
import net.sf.okapi.filters.markdown.parser.MarkdownToken;
import net.sf.okapi.filters.markdown.parser.MarkdownTokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownParser {
    private static final MutableDataHolder OPTIONS = ((MutableDataSet)((MutableDataSet)new MutableDataSet().set(Parser.EXTENSIONS, Arrays.asList(StrikethroughSubscriptExtension.create(), TablesExtension.create(), YamlFrontMatterExtension.create()))).set(Parser.HEADING_NO_ATX_SPACE, (Object)true)).set(Parser.BLANK_LINES_IN_AST, (Object)true);
    private static final Parser PARSER = Parser.builder(OPTIONS).build();
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String newline = System.lineSeparator();
    private Node root = null;
    private Deque<MarkdownToken> tokenQueue = new LinkedList<MarkdownToken>();
    private boolean lastAddedTranslatableContent = false;
    private Parameters params;
    private Pattern urlPatternToTranslate;
    private boolean isBlockQuoteNonTranslatable = false;
    private String linePrefix = "";
    private Map<String, Boolean> refVisible = new HashMap<String, Boolean>();
    private Set<String> usedRefTextSet = new HashSet<String>();
    private AllNodesVisitor preVisitor = new AllNodesVisitor(){

        @Override
        protected void process(Node node) {
            RefNode refNode;
            LinkRef linkRefNode;
            BasedSequence refTextBS;
            if (node instanceof LinkRef && MarkdownParser.this.isDefined(refTextBS = (linkRefNode = (LinkRef)node).getReference())) {
                String refText = refTextBS.toString();
                if (MarkdownParser.this.refVisible.containsKey(refText)) {
                    if (((Boolean)MarkdownParser.this.refVisible.get(refText)).booleanValue()) {
                        return;
                    }
                } else {
                    MarkdownParser.this.refVisible.put(refText, false);
                }
                if (!MarkdownParser.this.isDefined(linkRefNode.getText())) {
                    MarkdownParser.this.refVisible.put(refText, true);
                }
            }
            if (node instanceof RefNode && MarkdownParser.this.isDefined(refTextBS = (refNode = (RefNode)node).getReference())) {
                MarkdownParser.this.usedRefTextSet.add(refTextBS.toString().toLowerCase(Locale.US));
            }
        }
    };
    private NodeVisitor visitor = new NodeVisitor((VisitHandler<?>[])new VisitHandler[]{new VisitHandler<AutoLink>(AutoLink.class, node -> this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.AUTO_LINK, node)), new VisitHandler<BlankLine>(BlankLine.class, node -> this.addToQueue(this.newline, false, MarkdownTokenType.BLANK_LINE, node)), new VisitHandler<BlockQuote>(BlockQuote.class, new Visitor<BlockQuote>(){

        @Override
        public void visit(BlockQuote node) {
            boolean revertNonTranslatableFlag = false;
            if (!MarkdownParser.this.params.getNonTranslateBlocks().isEmpty()) {
                String[] nonTranslatableBlocks;
                for (String block : nonTranslatableBlocks = MarkdownParser.this.params.getNonTranslateBlocks().split(",")) {
                    if (!node.getChars().toString().contains(block)) continue;
                    MarkdownParser.this.isBlockQuoteNonTranslatable = true;
                    revertNonTranslatableFlag = true;
                    break;
                }
            }
            String prevLinePrefix = MarkdownParser.this.linePrefix;
            MarkdownParser.this.linePrefix = prevLinePrefix + node.getOpeningMarker().toString() + " ";
            MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX, node);
            MarkdownParser.this.visitor.visitChildren(node);
            if (!MarkdownParser.this.hasDescendentParagraph(node) && !MarkdownParser.this.hasDescendentBlankLine(node) && node.getChars().endsWith(MarkdownParser.this.newline)) {
                MarkdownParser.this.addNewline(node);
            }
            if (revertNonTranslatableFlag) {
                MarkdownParser.this.isBlockQuoteNonTranslatable = false;
            }
            MarkdownParser.this.linePrefix = prevLinePrefix;
            MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX, node);
        }
    }), new VisitHandler<BulletList>(BulletList.class, node -> this.visitListBlock((ListBlock)node, MarkdownTokenType.BULLET_LIST)), new VisitHandler<BulletListItem>(BulletListItem.class, node -> this.visitListItem((ListItem)node, MarkdownTokenType.BULLET_LIST_ITEM)), new VisitHandler<Code>(Code.class, new Visitor<Code>(){

        @Override
        public void visit(Code node) {
            if (MarkdownParser.this.params.getTranslateInlineCodeBlocks()) {
                MarkdownParser.this.addToQueue(node.getOpeningMarker().toString(), false, MarkdownTokenType.CODE, node);
                MarkdownParser.this.addToQueue(node.getText().toString(), true, MarkdownTokenType.TEXT, node);
                MarkdownParser.this.addToQueue(node.getClosingMarker().toString(), false, MarkdownTokenType.CODE, node);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(node.getOpeningMarker().toString()).append(node.getText().toString()).append(node.getClosingMarker().toString());
                MarkdownParser.this.addToQueue(sb.toString(), false, MarkdownTokenType.CODE, node);
                if (node.getText().toString().contains("\n")) {
                    MarkdownParser.this.LOGGER.debug("Code.getText() includes one or more newlines:{}", (Object)node.getText());
                }
            }
        }
    }), new VisitHandler<Block>(Block.class, new Visitor<Block>(){

        @Override
        public void visit(Block node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<Node>(Node.class, new Visitor<Node>(){

        @Override
        public void visit(Node node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<Document>(Document.class, new Visitor<Document>(){

        @Override
        public void visit(Document node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<Emphasis>(Emphasis.class, node -> this.visitDelimitedNode((DelimitedNode)((Object)node), MarkdownTokenType.EMPHASIS)), new VisitHandler<FencedCodeBlock>(FencedCodeBlock.class, new Visitor<FencedCodeBlock>(){

        @Override
        public void visit(FencedCodeBlock node) {
            MarkdownParser.this.addToQueue(node.getOpeningFence().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK, node);
            if (MarkdownParser.this.isDefined(node.getInfo())) {
                MarkdownParser.this.addToQueue(node.getInfo().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK_INFO, node);
            }
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
            for (BasedSequence seq : node.getContentLines()) {
                MarkdownParser.this.addToQueue(seq.toString(), MarkdownParser.this.params.getTranslateCodeBlocks(), MarkdownTokenType.TEXT, node);
            }
            MarkdownParser.this.addToQueue(node.getClosingFence().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK, node);
            MarkdownParser.this.addNewline(node);
        }
    }), new VisitHandler<YamlFrontMatterBlock>(YamlFrontMatterBlock.class, new Visitor<YamlFrontMatterBlock>(){

        @Override
        public void visit(YamlFrontMatterBlock node) {
            if (MarkdownParser.this.params.getTranslateHeaderMetadata()) {
                MarkdownParser.this.addToQueue("---", false, MarkdownTokenType.THEMATIC_BREAK, node);
                MarkdownParser.this.addNewline(node);
                StringBuilder yaml = new StringBuilder();
                for (BasedSequence sequence : node.getContentLines()) {
                    if (sequence.matchChars("---")) continue;
                    yaml.append(sequence.normalizeEndWithEOL());
                }
                MarkdownParser.this.addToQueue(yaml.toString(), true, MarkdownTokenType.YAML_METADATA_HEADER, node);
                MarkdownParser.this.addNewline(node);
                MarkdownParser.this.addToQueue("---", false, MarkdownTokenType.THEMATIC_BREAK, node);
                MarkdownParser.this.addNewline(node);
            } else {
                MarkdownParser.this.addToQueue(node.getContentChars().toString(), false, MarkdownTokenType.THEMATIC_BREAK, node);
                if (!node.getContentChars().endsWith(MarkdownParser.this.newline)) {
                    MarkdownParser.this.addNewline(node);
                }
            }
        }
    }), new VisitHandler<HardLineBreak>(HardLineBreak.class, new Visitor<HardLineBreak>(){

        @Override
        public void visit(HardLineBreak node) {
            String x = node.getChars().toString();
            if (x.endsWith(MarkdownParser.this.newline)) {
                MarkdownParser.this.addToQueue(x.substring(0, x.length() - MarkdownParser.this.newline.length()), false, MarkdownTokenType.HARD_LINE_BREAK, node);
                MarkdownParser.this.addToQueue(MarkdownParser.this.newline, true, MarkdownTokenType.SOFT_LINE_BREAK, node);
            } else {
                MarkdownParser.this.LOGGER.warn("HardLineBreak nodes is not ending with a newline.");
                MarkdownParser.this.addToQueue(x, false, MarkdownTokenType.HARD_LINE_BREAK, node);
            }
        }
    }), new VisitHandler<Heading>(Heading.class, new Visitor<Heading>(){

        @Override
        public void visit(Heading node) {
            if (node.getOpeningMarker() != BasedSequence.NULL) {
                MarkdownParser.this.addToQueue(node.getOpeningMarker().toString() + " ", false, MarkdownTokenType.HEADING_PREFIX, node);
            }
            MarkdownParser.this.visitor.visitChildren(node);
            if (node.getClosingMarker() != BasedSequence.NULL) {
                MarkdownParser.this.addNewline(node);
                MarkdownParser.this.addToQueue(node.getClosingMarker().toString(), false, MarkdownTokenType.HEADING_UNDERLINE, node);
            }
            MarkdownParser.this.addNewline(node);
        }
    }), new VisitHandler<HtmlBlock>(HtmlBlock.class, node -> {
        this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_BLOCK);
        if (node.getChars().endsWith(this.newline)) {
            this.addNewline(node);
        }
    }), new VisitHandler<HtmlCommentBlock>(HtmlCommentBlock.class, node -> {
        this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_COMMENT_BLOCK);
        if (node.getChars().endsWith(this.newline)) {
            this.addNewline(node);
        }
    }), new VisitHandler<HtmlEntity>(HtmlEntity.class, node -> this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT, node)), new VisitHandler<HtmlInline>(HtmlInline.class, new Visitor<HtmlInline>(){

        @Override
        public void visit(HtmlInline node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_INLINE, node);
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<HtmlInlineComment>(HtmlInlineComment.class, new Visitor<HtmlInlineComment>(){

        @Override
        public void visit(HtmlInlineComment node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_INLINE_COMMENT, node);
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<HtmlInnerBlock>(HtmlInnerBlock.class, node -> this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_INNER_BLOCK)), new VisitHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, node -> this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_INNER_BLOCK_COMMENT)), new VisitHandler<Image>(Image.class, node -> this.visitInlineLink((InlineLinkNode)node, MarkdownTokenType.IMAGE)), new VisitHandler<ImageRef>(ImageRef.class, node -> this.visitRefLink((RefNode)node, MarkdownTokenType.IMAGE_REF)), new VisitHandler<IndentedCodeBlock>(IndentedCodeBlock.class, node -> {
        String prevLinePrefix = this.linePrefix;
        this.linePrefix = prevLinePrefix + "    ";
        this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX, node);
        for (BasedSequence seq : node.getContentLines()) {
            this.addToQueue(seq.toString(), true, MarkdownTokenType.TEXT, node);
        }
        this.addToQueue("", false, MarkdownTokenType.END_TEXT_UNIT, node);
        this.linePrefix = prevLinePrefix;
        this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX, node);
    }), new VisitHandler<Link>(Link.class, node -> this.visitInlineLink((InlineLinkNode)node, MarkdownTokenType.LINK)), new VisitHandler<LinkRef>(LinkRef.class, node -> this.visitRefLink((RefNode)node, MarkdownTokenType.LINK_REF)), new VisitHandler<MailLink>(MailLink.class, node -> this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.MAIL_LINK, node)), new VisitHandler<Paragraph>(Paragraph.class, new Visitor<Paragraph>(){

        @Override
        public void visit(Paragraph node) {
            MarkdownParser.this.visitor.visitChildren(node);
            if (node.getChars().endsWith(MarkdownParser.this.newline)) {
                MarkdownParser.this.addNewline(node);
            }
        }
    }), new VisitHandler<OrderedList>(OrderedList.class, node -> this.visitListBlock((ListBlock)node, MarkdownTokenType.ORDERED_LIST)), new VisitHandler<OrderedListItem>(OrderedListItem.class, node -> this.visitListItem((ListItem)node, MarkdownTokenType.ORDERED_LIST_ITEM)), new VisitHandler<Reference>(Reference.class, node -> this.visitReferenceDefinition((Reference)node, MarkdownTokenType.REFERENCE)), new VisitHandler<SoftLineBreak>(SoftLineBreak.class, node -> this.addToQueue(this.newline, true, MarkdownTokenType.SOFT_LINE_BREAK, node)), new VisitHandler<StrongEmphasis>(StrongEmphasis.class, node -> this.visitDelimitedNode((DelimitedNode)((Object)node), MarkdownTokenType.STRONG_EMPHASIS)), new VisitHandler<Subscript>(Subscript.class, node -> this.visitDelimitedNode((DelimitedNode)((Object)node), MarkdownTokenType.SUBSCRIPT)), new VisitHandler<Strikethrough>(Strikethrough.class, node -> this.visitDelimitedNode((DelimitedNode)((Object)node), MarkdownTokenType.STRIKETHROUGH)), new VisitHandler<Text>(Text.class, node -> {
        if (node.getChars().toString().isEmpty()) {
            return;
        }
        if (!node.getChars().toString().trim().isEmpty()) {
            this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT, node);
        } else {
            MarkdownToken lastToken = this.tokenQueue.peekLast();
            if (this.lastAddedTranslatableContent || lastToken != null && lastToken.getType().isInline()) {
                this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT, node);
            } else {
                this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.TEXT, node);
            }
        }
    }), new VisitHandler<TextBase>(TextBase.class, new Visitor<TextBase>(){

        @Override
        public void visit(TextBase node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<ThematicBreak>(ThematicBreak.class, node -> {
        this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.THEMATIC_BREAK, node);
        this.addNewline(node);
    }), new VisitHandler<WhiteSpace>(WhiteSpace.class, new Visitor<WhiteSpace>(){

        @Override
        public void visit(WhiteSpace node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableBlock>(TableBlock.class, new Visitor<TableBlock>(){

        @Override
        public void visit(TableBlock node) {
            MarkdownParser.this.visitor.visitChildren(node);
            if (!node.getChars().endsWith(MarkdownParser.this.newline)) {
                MarkdownParser.this.tokenQueue.removeLast();
            }
        }
    }), new VisitHandler<TableBody>(TableBody.class, new Visitor<TableBody>(){

        @Override
        public void visit(TableBody node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableCaption>(TableCaption.class, new Visitor<TableCaption>(){

        @Override
        public void visit(TableCaption node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableCell>(TableCell.class, new Visitor<TableCell>(){

        @Override
        public void visit(TableCell node) {
            MarkdownParser.this.addToQueue("| ", false, MarkdownTokenType.TABLE_PIPE, node);
            Node cn = node.getFirstChild();
            if (cn == node.getLastChild() && cn instanceof Text && cn.getChars().toString().equals(" ")) {
                int ns = node.getTextLength() - 2;
                if (!node.getOpeningMarker().isEmpty()) {
                    --ns;
                }
                MarkdownParser.this.addToQueue(StringUtil.repeatChar(' ', ns), false, MarkdownTokenType.WHITE_SPACE, node);
            } else {
                MarkdownParser.this.visitor.visitChildren(node);
                MarkdownParser.this.addToQueue(" ", false, MarkdownTokenType.WHITE_SPACE, node);
            }
        }
    }), new VisitHandler<TableHead>(TableHead.class, new Visitor<TableHead>(){

        @Override
        public void visit(TableHead node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler<TableRow>(TableRow.class, new Visitor<TableRow>(){

        @Override
        public void visit(TableRow node) {
            MarkdownParser.this.visitor.visitChildren(node);
            MarkdownParser.this.addToQueue("|", false, MarkdownTokenType.TABLE_PIPE, node);
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
        }
    }), new VisitHandler<TableSeparator>(TableSeparator.class, node -> {
        String nodeText = node.getChars().toString();
        if (nodeText.endsWith("\r")) {
            nodeText = nodeText.substring(0, nodeText.length() - 1);
        }
        this.addToQueue(nodeText, false, MarkdownTokenType.TABLE_SEPARATOR, node);
        this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
    })});

    public MarkdownParser(Parameters params) {
        this.params = params;
        this.urlPatternToTranslate = Pattern.compile(params.getUrlToTranslatePattern());
    }

    public MarkdownParser(Parameters params, String newline) {
        this(params);
        this.newline = newline;
    }

    public void parse(String markdownContent) {
        this.root = PARSER.parse(markdownContent);
        this.tokenQueue.clear();
        this.lastAddedTranslatableContent = false;
        this.preVisitor.visit(this.root);
        this.visitor.visit(this.root);
    }

    public boolean hasNextToken() {
        return !this.tokenQueue.isEmpty();
    }

    public MarkdownToken getNextToken() {
        if (!this.hasNextToken()) {
            throw new IllegalStateException("No more tokens remaining");
        }
        return this.tokenQueue.removeFirst();
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public String dumpTokens() {
        StringBuilder builder = new StringBuilder();
        for (MarkdownToken tok : this.tokenQueue) {
            builder.append(tok).append(this.newline);
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.generateAstString(this.root, 0, builder);
        return builder.toString();
    }

    private void generateAstString(Node node, int depth, StringBuilder builder) {
        if (node == null) {
            builder.append("The root node is null!\n");
            return;
        }
        for (int i = 0; i < depth; ++i) {
            builder.append(' ');
        }
        builder.append(node.toAstString(true)).append(this.newline);
        for (Node child : node.getChildren()) {
            this.generateAstString(child, depth + 1, builder);
        }
    }

    private String trimSpacesOnly(String str) {
        str = str.replaceAll("^ +", "");
        str = str.replaceAll(" +$", "");
        return str;
    }

    private String trimNewlinesOnly(String str) {
        str = str.replaceAll("[" + this.newline + "]+$", "");
        str = str.replaceAll("^[" + this.newline + "]+", "");
        return str;
    }

    private void addToQueue(String content, boolean isTranslatable, MarkdownTokenType type, Node node) {
        if (content.equals(this.newline) && !isTranslatable) {
            this.lastAddedTranslatableContent = isTranslatable;
            this.tokenQueue.addLast(new MarkdownToken(content, isTranslatable, type));
            return;
        }
        if (this.lastAddedTranslatableContent && isTranslatable) {
            MarkdownToken lastToken = this.tokenQueue.peekLast();
            lastToken.setContent(lastToken.getContent() + content);
            if (lastToken.getType().equals((Object)MarkdownTokenType.SOFT_LINE_BREAK)) {
                lastToken.setType(type);
            }
            return;
        }
        if (this.isBlockQuoteNonTranslatable) {
            isTranslatable = false;
        }
        this.lastAddedTranslatableContent = isTranslatable;
        this.tokenQueue.addLast(new MarkdownToken(content, isTranslatable, type));
    }

    private void addListPaddingCharacters(String content, Node node) {
        if (content.equals(this.newline)) {
            return;
        }
        MarkdownToken lastToken = this.tokenQueue.peekLast();
        if (lastToken == null || !lastToken.getContent().equals(this.newline)) {
            return;
        }
        int depth = 1;
        if (node instanceof BulletListItem || node instanceof OrderedListItem) {
            depth = 0;
        }
        Node ancestor = node.getAncestorOfType(BulletList.class, OrderedList.class);
        while (ancestor != null) {
            ancestor = ancestor.getAncestorOfType(BulletList.class, OrderedList.class);
            ++depth;
        }
        StringBuilder padding = new StringBuilder();
        for (int i = 1; i < depth; ++i) {
            padding.append("   ");
        }
        if (padding.length() > 0) {
            this.tokenQueue.addLast(new MarkdownToken(padding.toString(), false, MarkdownTokenType.WHITE_SPACE));
        }
    }

    private boolean isVisibleRef(String refText) {
        return this.refVisible.getOrDefault(refText, false);
    }

    private boolean isRefTextUsed(String refText) {
        return this.usedRefTextSet.contains(refText.toLowerCase(Locale.US));
    }

    private void addNewline(Node node) {
        this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK, node);
    }

    private void visitDelimitedNode(DelimitedNode node, MarkdownTokenType type) {
        assert (node instanceof Node);
        this.addToQueue(node.getOpeningMarker().toString(), false, type, (Node)((Object)node));
        this.visitor.visitChildren((Node)((Object)node));
        this.addToQueue(node.getClosingMarker().toString(), false, type, (Node)((Object)node));
    }

    private void visitHtmlBlockBase(HtmlBlockBase node, MarkdownTokenType type) {
        boolean shouldTranslate = !type.equals((Object)MarkdownTokenType.HTML_COMMENT_BLOCK) && !type.equals((Object)MarkdownTokenType.HTML_INNER_BLOCK_COMMENT);
        this.addToQueue(node.getChars().toString().trim(), shouldTranslate, type, node);
        for (Node child : node.getChildren()) {
            this.visitor.visit(child);
        }
    }

    private void visitInlineLink(InlineLinkNode node, MarkdownTokenType type) {
        StringBuilder sb = new StringBuilder();
        if (node instanceof Image) {
            if (this.params.getTranslateImageAltText()) {
                this.addToQueue(node.getTextOpeningMarker().toString(), false, type, node);
                this.visitor.visitChildren(node);
                sb.append(node.getTextClosingMarker());
            } else {
                sb.append(node.getTextOpeningMarker().toString()).append(node.getText().toString()).append(node.getTextClosingMarker());
            }
        } else {
            assert (node instanceof Link);
            this.addToQueue(node.getTextOpeningMarker().toString(), false, type, node);
            this.visitor.visitChildren(node);
            sb.append(node.getTextClosingMarker());
        }
        sb.append(node.getLinkOpeningMarker());
        sb.append(node.getUrlOpeningMarker());
        if (this.shouldTranslateUrl(node)) {
            this.addToQueue(sb.toString(), false, type, node);
            sb.setLength(0);
            this.addToQueue(node.getUrl().toString(), true, MarkdownTokenType.TEXT, node);
        } else {
            sb.append(node.getUrl());
        }
        sb.append(node.getUrlClosingMarker());
        if (this.isDefined(node.getTitle())) {
            sb.append(" ").append(node.getTitleOpeningMarker());
            this.addToQueue(sb.toString(), false, type, node);
            this.addToQueue(node.getTitle().toString(), true, MarkdownTokenType.TEXT, node);
            sb = new StringBuilder(node.getTitleClosingMarker());
        }
        sb.append(node.getLinkClosingMarker());
        this.addToQueue(sb.toString(), false, type, node);
    }

    private void visitRefLink(RefNode node, MarkdownTokenType type) {
        if (this.isDefined(node.getText())) {
            if (node instanceof ImageRef) {
                this.addToQueue(node.getTextOpeningMarker().toString(), false, type, node);
                this.addToQueue(node.getText().toString(), true, MarkdownTokenType.TEXT, node);
                this.addToQueue(node.getTextClosingMarker().toString(), false, type, node);
            } else {
                this.addToQueue(node.getTextOpeningMarker().toString(), false, type, node);
                this.visitor.visitChildren(node);
                this.addToQueue(node.getTextClosingMarker().toString(), false, type, node);
            }
        } else if (node instanceof ImageRef) {
            this.addToQueue(node.getTextOpeningMarker().toString() + node.getTextClosingMarker().toString(), false, type, node);
        }
        if (this.isDefined(node.getReferenceOpeningMarker())) {
            this.addToQueue(node.getReferenceOpeningMarker().toString(), false, type, node);
            if (this.isDefined(node.getReference())) {
                String refText = node.getReference().toString();
                if (this.isVisibleRef(refText)) {
                    this.visitor.visitChildren(node);
                } else {
                    this.addToQueue(refText, false, type, node);
                }
            } else if ("[ ]".equals(node.getChars().toString())) {
                this.addToQueue(" ", false, MarkdownTokenType.WHITE_SPACE, node);
            } else {
                this.LOGGER.warn("{} node [{}] reports a reference opening marker but the reference is empty.", (Object)node.getClass().getName(), (Object)node.toAstString(false));
            }
            if (this.isDefined(node.getReferenceClosingMarker())) {
                this.addToQueue(node.getReferenceClosingMarker().toString(), false, type, node);
            } else {
                this.LOGGER.warn("{} node [{}] reports a reference opening marker but lacks a closing marker.", (Object)node.getClass().getName(), (Object)node.toAstString(false));
            }
        }
    }

    private void visitReferenceDefinition(Reference node, MarkdownTokenType type) {
        assert (type.equals((Object)MarkdownTokenType.REFERENCE));
        this.addToQueue(node.getOpeningMarker().toString(), false, type, node);
        String refText = node.getReference().toString();
        this.addToQueue(refText, this.isVisibleRef(refText), type, node);
        this.addToQueue(node.getClosingMarker().toString() + " ", false, type, node);
        if (this.isDefined(node.getUrlOpeningMarker())) {
            this.addToQueue(node.getUrlOpeningMarker().toString(), false, type, node);
        }
        if (this.shouldTranslateUrl(node)) {
            this.addToQueue(node.getUrl().toString(), this.isRefTextUsed(refText), type, node);
        } else {
            this.addToQueue(node.getUrl().toString(), false, type, node);
        }
        if (this.isDefined(node.getUrlClosingMarker())) {
            this.addToQueue(node.getUrlClosingMarker().toString(), false, type, node);
        }
        if (this.isDefined(node.getTitle())) {
            this.addToQueue(" " + node.getTitleOpeningMarker().toString(), false, type, node);
            this.addToQueue(node.getTitle().toString(), this.isRefTextUsed(refText), type, node);
            this.addToQueue(node.getTitleClosingMarker().toString(), false, type, node);
        }
        this.addToQueue(this.newline, false, type, node);
    }

    private void visitListBlock(ListBlock listBlock, MarkdownTokenType type) {
        this.visitor.visitChildren(listBlock);
    }

    private void visitListItem(ListItem listItem, MarkdownTokenType type) {
        this.addToQueue(listItem.getOpeningMarker().toString() + " ", false, type, listItem);
        if (!listItem.hasChildren()) {
            this.addNewline(listItem);
        } else {
            String prevLinePrefix = this.linePrefix;
            this.linePrefix = prevLinePrefix + "   ";
            this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX, listItem);
            if (!(listItem.getFirstChild() instanceof Paragraph)) {
                this.addNewline(listItem);
            }
            this.visitor.visitChildren(listItem);
            this.linePrefix = prevLinePrefix;
            this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX, listItem);
        }
    }

    private boolean isDefined(BasedSequence sequence) {
        return sequence != BasedSequence.NULL && !sequence.isEmpty();
    }

    private boolean shouldTranslateUrl(LinkNodeBase node) {
        return this.params.getTranslateUrls() && this.isDefined(node.getUrl()) && this.urlPatternToTranslate.matcher(node.getUrl().toString()).matches();
    }

    private boolean hasDescendentParagraph(Node node) {
        return this.hasDecendentOf(Paragraph.class, node);
    }

    private boolean hasDescendentBlankLine(Node node) {
        return this.hasDecendentOf(BlankLine.class, node);
    }

    private boolean hasDecendentOf(Class<?> nodeClass, Node node) {
        while (node.getLastChild() != null) {
            if (!nodeClass.isInstance(node = node.getLastChild())) continue;
            return true;
        }
        return false;
    }
}

