/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.BlockPropertyFactory;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.SchemaDefinition;
import net.sf.okapi.filters.openxml.SchemaDefinitions;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventsReader;

class BlockProperties
extends MarkupComponent
implements Nameable {
    private static final String PARAGRAPH_STYLE = "pStyle";
    private static final String LOCAL_LEVEL = "lvl";
    private final ConditionalParameters conditionalParameters;
    private final XMLEventFactory eventFactory;
    private final StartElement startElement;
    private final EndElement endElement;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<BlockProperty> properties = new ArrayList<BlockProperty>();
    private final SchemaDefinition.Component schemaDefinition;
    private final StrippableAttributes.General generalAttributes;

    BlockProperties(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, List<BlockProperty> properties) {
        this.conditionalParameters = conditionalParameters;
        this.eventFactory = eventFactory;
        this.startElement = startElement;
        this.endElement = endElement;
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            this.attributes.add(iterator.next());
        }
        this.properties.addAll(properties);
        this.schemaDefinition = SchemaDefinitions.of(startElement);
        this.generalAttributes = new StrippableAttributes.General(conditionalParameters);
    }

    @Override
    public QName getName() {
        return this.startElement.getName();
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
        for (BlockProperty property : this.properties) {
            events.addAll(property.getEvents());
        }
        events.add(this.endElement);
        return events;
    }

    List<Attribute> getAttributes() {
        return this.attributes;
    }

    List<BlockProperty> getProperties() {
        return this.properties;
    }

    boolean isEmpty() {
        return this.attributes.isEmpty() && this.properties.isEmpty();
    }

    String paragraphStyle() {
        Attribute paragraphLevelAttribute = this.paragraphLevelAttribute();
        if (null != paragraphLevelAttribute) {
            return paragraphLevelAttribute.getValue();
        }
        BlockProperty paragraphStyleProperty = this.paragraphStyleProperty();
        if (null != paragraphStyleProperty) {
            return XMLEventHelpers.getAttributeValue(paragraphStyleProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }
        return null;
    }

    private BlockProperty paragraphStyleProperty() {
        return this.blockProperty(PARAGRAPH_STYLE);
    }

    private BlockProperty blockProperty(String localPart) {
        QName name = new QName(this.startElement.getName().getNamespaceURI(), localPart);
        for (BlockProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    String highlightColor() {
        BlockProperty highlightColorProperty = this.highlightColorProperty();
        if (null != highlightColorProperty) {
            return XMLEventHelpers.getAttributeValue(highlightColorProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }
        return null;
    }

    private BlockProperty highlightColorProperty() {
        return this.blockProperty("highlight");
    }

    String textColor() {
        BlockProperty colorProperty = this.textColorProperty();
        if (null != colorProperty) {
            return XMLEventHelpers.getAttributeValue(colorProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }
        return null;
    }

    private BlockProperty textColorProperty() {
        return this.blockProperty("color");
    }

    private Attribute paragraphLevelAttribute() {
        for (Attribute attribute : this.attributes) {
            if (!LOCAL_LEVEL.equals(attribute.getName().getLocalPart())) continue;
            return attribute;
        }
        return null;
    }

    void refine(QName innerBlockPropertyName, List<RunProperty> commonRunProperties) throws XMLStreamException {
        ListIterator<BlockProperty> propertiesIterator = this.properties.listIterator();
        while (propertiesIterator.hasNext()) {
            BlockProperty blockProperty = propertiesIterator.next();
            if (!blockProperty.getName().equals(innerBlockPropertyName)) continue;
            this.updateProperty(propertiesIterator, blockProperty, commonRunProperties);
            return;
        }
        this.addProperty(propertiesIterator, innerBlockPropertyName, commonRunProperties);
    }

    private void updateProperty(ListIterator<BlockProperty> propertiesIterator, BlockProperty blockProperty, List<RunProperty> commonRunProperties) throws XMLStreamException {
        BlockProperties blockProperties = this.asBlockProperties(blockProperty);
        blockProperties.refineAll(commonRunProperties);
        propertiesIterator.set(BlockPropertyFactory.createBlockProperty(blockProperties.getEvents()));
    }

    private BlockProperties asBlockProperties(BlockProperty blockProperty) throws XMLStreamException {
        XMLEventsReader eventReader = new XMLEventsReader(blockProperty.getEvents());
        StartElement startElement = eventReader.nextEvent().asStartElement();
        StartElementContext initialStartElementContext = StartElementContextFactory.createStartElementContext(startElement, this.startElement, eventReader, this.eventFactory, this.conditionalParameters, null);
        StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(this.generalAttributes.strip(initialStartElementContext), initialStartElementContext);
        return MarkupComponentParser.parseBlockProperties(startElementContext, new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE, SkippableElement.RevisionProperty.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, SkippableElement.RevisionProperty.RUN_PROPERTY_DELETED_PARAGRAPH_MARK, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_TO, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_FROM, SkippableElement.RevisionProperty.PARAGRAPH_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.RUN_PROPERTIES_CHANGE), startElementContext.getConditionalParameters()), startElementContext.getConditionalParameters()));
    }

    private void addProperty(ListIterator<BlockProperty> propertiesIterator, QName innerBlockPropertyName, List<RunProperty> commonRunProperties) {
        List<Attribute> attributes = this.asAttributes(commonRunProperties);
        List<RunProperty> properties = this.asProperties(commonRunProperties);
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.eventFactory.createStartElement(innerBlockPropertyName, attributes.iterator(), this.startElement.getNamespaces()));
        events.addAll(BlockProperties.asXMLEvents(properties));
        events.add(this.eventFactory.createEndElement(innerBlockPropertyName, this.endElement.getNamespaces()));
        this.rewindToSchemaDefinedPlace(propertiesIterator, innerBlockPropertyName).add(BlockPropertyFactory.createBlockProperty(events));
    }

    private List<Attribute> asAttributes(List<RunProperty> commonRunProperties) {
        return commonRunProperties.stream().filter(runProperty -> runProperty instanceof RunProperty.AttributeRunProperty).map(runProperty -> this.eventFactory.createAttribute(runProperty.getName(), runProperty.getValue())).collect(Collectors.toList());
    }

    private List<RunProperty> asProperties(List<RunProperty> commonRunProperties) {
        return commonRunProperties.stream().filter(runProperty -> !(runProperty instanceof RunProperty.AttributeRunProperty)).collect(Collectors.toList());
    }

    private static List<XMLEvent> asXMLEvents(List<RunProperty> commonRunProperties) {
        return commonRunProperties.stream().map(RunProperty::getEvents).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private ListIterator<BlockProperty> rewindToSchemaDefinedPlace(ListIterator<BlockProperty> propertiesIterator, QName innerBlockPropertyName) {
        if (!propertiesIterator.hasPrevious()) {
            return propertiesIterator;
        }
        ListIterator<SchemaDefinition.Component> iterator = this.schemaDefinition.listIteratorAfter(innerBlockPropertyName);
        if (!iterator.hasNext()) {
            return propertiesIterator;
        }
        while (iterator.hasNext()) {
            SchemaDefinition.Component component = (SchemaDefinition.Component)iterator.next();
            while (propertiesIterator.hasPrevious()) {
                BlockProperty blockProperty = propertiesIterator.previous();
                if (!blockProperty.getName().equals(component.name())) continue;
                return propertiesIterator;
            }
            this.rewindToEndOfProperties(propertiesIterator);
        }
        return propertiesIterator;
    }

    private void rewindToEndOfProperties(ListIterator<BlockProperty> propertiesIterator) {
        while (propertiesIterator.hasNext()) {
            propertiesIterator.next();
        }
    }

    private void refineAll(List<RunProperty> commonRunProperties) {
        for (RunProperty runProperty : commonRunProperties) {
            if (runProperty instanceof RunProperty.AttributeRunProperty) {
                this.updateOrAddAttribute((RunProperty.AttributeRunProperty)runProperty);
                continue;
            }
            this.updateOrAddProperty(runProperty);
        }
        this.alignWithSchemaDefinition();
    }

    private void alignWithSchemaDefinition() {
        if (this.properties.isEmpty()) {
            return;
        }
        ArrayList<BlockProperty> copiedProperties = new ArrayList<BlockProperty>(this.properties);
        this.properties.clear();
        ListIterator<SchemaDefinition.Component> iterator = this.schemaDefinition.listIterator();
        while (iterator.hasNext() || !copiedProperties.isEmpty()) {
            SchemaDefinition.Component component = iterator.next();
            switch (component.composition()) {
                case CHOICE: 
                case SEQUENCE: 
                case ALL: {
                    this.findAndAppendMany(copiedProperties, component);
                    break;
                }
                case NONE: {
                    this.findAndAppendOne(copiedProperties, component);
                }
            }
        }
    }

    private void findAndAppendMany(List<BlockProperty> copiedProperties, SchemaDefinition.Component component) {
        ListIterator<SchemaDefinition.Component> componentsIterator = component.listIterator();
        while (componentsIterator.hasNext()) {
            SchemaDefinition.Component innerComponent = (SchemaDefinition.Component)componentsIterator.next();
            this.findAndAppendOne(copiedProperties, innerComponent);
        }
    }

    private void findAndAppendOne(List<BlockProperty> copiedProperties, SchemaDefinition.Component component) {
        Iterator<BlockProperty> copiedPropertiesIterator = copiedProperties.iterator();
        while (copiedPropertiesIterator.hasNext()) {
            BlockProperty blockProperty = copiedPropertiesIterator.next();
            if (!blockProperty.getName().equals(component.name())) continue;
            this.properties.add(blockProperty);
            copiedPropertiesIterator.remove();
            return;
        }
    }

    private void updateOrAddAttribute(RunProperty.AttributeRunProperty runProperty) {
        ListIterator<Attribute> attributesIterator = this.attributes.listIterator();
        while (attributesIterator.hasNext()) {
            Attribute attribute = attributesIterator.next();
            if (!attribute.getName().equals(runProperty.getName())) continue;
            attributesIterator.set(this.eventFactory.createAttribute(attribute.getName(), runProperty.getValue()));
            return;
        }
        attributesIterator.add(this.eventFactory.createAttribute(runProperty.getName(), runProperty.getValue()));
    }

    private void updateOrAddProperty(RunProperty runProperty) {
        ListIterator<BlockProperty> propertiesIterator = this.properties.listIterator();
        while (propertiesIterator.hasNext()) {
            BlockProperty blockProperty = propertiesIterator.next();
            if (!blockProperty.getName().equals(runProperty.getName())) continue;
            propertiesIterator.set(BlockPropertyFactory.createBlockProperty(runProperty.getEvents()));
            return;
        }
        propertiesIterator.add(BlockPropertyFactory.createBlockProperty(runProperty.getEvents()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockProperties that = (BlockProperties)o;
        return Objects.equals(this.startElement.getName().getNamespaceURI(), that.startElement.getName().getNamespaceURI()) && Objects.equals(this.startElement.getName().getLocalPart(), that.startElement.getName().getLocalPart()) && Objects.equals(this.startElement.getName().getPrefix(), that.startElement.getName().getPrefix()) && Objects.equals(this.endElement, that.endElement) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.startElement.getName().getNamespaceURI(), this.startElement.getName().getLocalPart(), this.startElement.getName().getPrefix(), this.endElement, this.attributes, this.properties);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        String prefix = this.startElement.getName().getPrefix();
        if (!prefix.isEmpty()) {
            builder.append(prefix).append(":");
        }
        builder.append(this.startElement.getName().getLocalPart()).append(" ").append("(").append(this.attributes.size()).append(")").append(this.toString(this.attributes)).append(" ").append("(").append(this.properties.size()).append(")").append(this.properties);
        return builder.toString();
    }

    private String toString(List<Attribute> attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Attribute attribute : attributes) {
            String prefix = attribute.getName().getPrefix();
            if (!prefix.isEmpty()) {
                builder.append(prefix).append(":");
            }
            builder.append(attribute.getName().getLocalPart()).append("=\"");
            builder.append(attribute.getValue()).append("\"");
        }
        builder.append("]");
        return builder.toString();
    }
}

