/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.Relationships;

abstract class DocumentType {
    protected static final String UNEXPECTED_NUMBER_OF_RELATIONSHIPS = "Unexpected number of relationships";
    private OpenXMLZipFile zipFile;
    private ConditionalParameters params;

    DocumentType(OpenXMLZipFile zipFile, ConditionalParameters params) {
        this.zipFile = zipFile;
        this.params = params;
    }

    static boolean isRelationshipsPart(String contentType) {
        return "application/vnd.openxmlformats-package.relationships+xml".equals(contentType);
    }

    static boolean isMasterPart(String type) {
        return "application/vnd.ms-visio.master+xml".equals(type);
    }

    static boolean isPagePart(String type) {
        return "application/vnd.ms-visio.page+xml".equals(type);
    }

    protected OpenXMLZipFile getZipFile() {
        return this.zipFile;
    }

    protected ConditionalParameters getParams() {
        return this.params;
    }

    String getRelationshipTarget(String relationshipType) throws IOException, XMLStreamException {
        String mainDocumentTarget = this.getZipFile().getMainDocumentTarget();
        Relationships relationships = this.getZipFile().getRelationshipsForTarget(mainDocumentTarget);
        List<Relationships.Rel> rels = relationships.getRelByType(relationshipType);
        if (null == rels) {
            return null;
        }
        return rels.get((int)0).target;
    }

    Map<String, String> initializeRelsByEntry(List<String> entryNames, String relType) throws IOException, XMLStreamException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entryName : entryNames) {
            List<Relationships.Rel> rels = this.zipFile.getRelationshipsForTarget(entryName).getRelByType(relType);
            if (rels == null || rels.isEmpty()) continue;
            for (Relationships.Rel rel : rels) {
                result.put(rel.target, entryName);
            }
        }
        return result;
    }

    abstract OpenXMLPartHandler getHandlerForFile(ZipEntry var1, String var2) throws IOException, XMLStreamException;

    abstract void initialize() throws IOException, XMLStreamException;

    abstract boolean isClarifiablePart(String var1);

    abstract boolean isStyledTextPart(String var1, String var2);

    abstract Enumeration<? extends ZipEntry> getZipFileEntries() throws IOException, XMLStreamException;
}

