/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentTypes;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.ExcelDocument;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.PowerpointDocument;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.VisioDocument;
import net.sf.okapi.filters.openxml.WordDocument;

class OpenXMLZipFile {
    private static final String UNSUPPORTED_MAIN_DOCUMENT_TARGET = "Unsupported main document target";
    static final String CONTENT_TYPES_PART = "[Content_Types].xml";
    static final String ROOT_RELS_PART = "_rels/.rels";
    private static final String OFFICE_DOCUMENT = "/officeDocument";
    private static final String DOCUMENT = "/document";
    private static final int MAX_ATTRIBUTE_SIZE = 0x200000;
    private final ZipFile zipFile;
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private final String encoding;
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final Map<String, String> sharedStrings;
    private ContentTypes contentTypes;
    private String mainDocumentTarget;
    private Conformance conformance;
    private Namespace documentRelationshipsNamespace;

    OpenXMLZipFile(ZipFile zipFile, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String encoding, EncoderManager encoderManager, IFilter subfilter, Map<String, String> sharedStrings) {
        this.zipFile = zipFile;
        this.inputFactory = inputFactory;
        if (inputFactory.isPropertySupported("com.ctc.wstx.maxAttributeSize")) {
            inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", 0x200000);
        }
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
        this.encoding = encoding;
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.sharedStrings = sharedStrings;
    }

    DocumentType createDocument(ConditionalParameters params) throws XMLStreamException, IOException {
        DocumentType doc;
        this.initializeContentTypes();
        this.initializeMainDocumentTargetAndDocumentRelationshipsNamespace();
        switch (this.contentTypes.getContentType(this.mainDocumentTarget)) {
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": 
            case "application/vnd.ms-word.document.macroEnabled.main+xml": 
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml": 
            case "application/vnd.ms-word.template.macroEnabledTemplate.main+xml": {
                doc = new WordDocument(this, params);
                break;
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": 
            case "application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml": 
            case "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml": 
            case "application/vnd.ms-powerpoint.slideshow.macroEnabled.main+xml": 
            case "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml": 
            case "application/vnd.ms-powerpoint.template.macroEnabled.main+xml": {
                doc = new PowerpointDocument(this, params);
                break;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": 
            case "application/vnd.ms-excel.sheet.macroEnabled.main+xml": 
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml": 
            case "application/vnd.ms-excel.template.macroEnabled.main+xml": {
                doc = new ExcelDocument(this, params, this.encoderManager, this.subfilter, this.sharedStrings);
                break;
            }
            case "application/vnd.ms-visio.drawing.main+xml": 
            case "application/vnd.ms-visio.drawing.macroEnabled.main+xml": {
                doc = new VisioDocument(this, params);
                break;
            }
            default: {
                throw new OkapiBadFilterInputException(String.format("%s: %s", UNSUPPORTED_MAIN_DOCUMENT_TARGET, this.mainDocumentTarget));
            }
        }
        doc.initialize();
        return doc;
    }

    private void initializeContentTypes() throws XMLStreamException, IOException {
        if (this.contentTypes == null) {
            this.contentTypes = new ContentTypes(this.inputFactory);
            this.contentTypes.parseFromXML(this.getPartReader(CONTENT_TYPES_PART));
        }
    }

    private void initializeMainDocumentTargetAndDocumentRelationshipsNamespace() throws IOException, XMLStreamException {
        Relationships relationships = this.getRelationships(ROOT_RELS_PART);
        String officeDocumentSourceType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships".concat(OFFICE_DOCUMENT);
        String strictOfficeDocumentSourceType = "http://purl.oclc.org/ooxml/officeDocument/relationships".concat(OFFICE_DOCUMENT);
        String visioDocumentSourceType = "http://schemas.microsoft.com/visio/2010/relationships".concat(DOCUMENT);
        if (relationships.hasRelType(officeDocumentSourceType)) {
            this.mainDocumentTarget = relationships.getRelByType((String)officeDocumentSourceType).get((int)0).target;
            this.documentRelationshipsNamespace = new Namespace.Default("http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        } else if (relationships.hasRelType(strictOfficeDocumentSourceType)) {
            this.mainDocumentTarget = relationships.getRelByType((String)strictOfficeDocumentSourceType).get((int)0).target;
            this.documentRelationshipsNamespace = new Namespace.Default("http://purl.oclc.org/ooxml/officeDocument/relationships");
        } else if (relationships.hasRelType(visioDocumentSourceType)) {
            this.mainDocumentTarget = relationships.getRelByType((String)visioDocumentSourceType).get((int)0).target;
            this.documentRelationshipsNamespace = new Namespace.Default("http://schemas.microsoft.com/visio/2010/relationships");
        } else {
            throw new OkapiBadFilterInputException(UNSUPPORTED_MAIN_DOCUMENT_TARGET);
        }
    }

    ContentTypes getContentTypes() {
        return this.contentTypes;
    }

    XMLInputFactory getInputFactory() {
        return this.inputFactory;
    }

    XMLOutputFactory getOutputFactory() {
        return this.outputFactory;
    }

    XMLEventFactory getEventFactory() {
        return this.eventFactory;
    }

    String getMainDocumentTarget() {
        return this.mainDocumentTarget;
    }

    Namespace documentRelationshipsNamespace() {
        return this.documentRelationshipsNamespace;
    }

    Reader getPartReader(String partName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(partName);
        if (entry == null) {
            throw new OkapiBadFilterInputException("File is missing " + partName);
        }
        return Util.skipBOM(new InputStreamReader(this.zipFile.getInputStream(entry), this.encoding));
    }

    private boolean isDocumentPartAvailable(String partName) {
        return this.zipFile.getEntry(partName) != null;
    }

    Relationships getRelationships(String relsPartName) throws IOException, XMLStreamException {
        Relationships rels = new Relationships(this.inputFactory);
        if (this.isDocumentPartAvailable(relsPartName)) {
            rels.parseFromXML(relsPartName, this.getPartReader(relsPartName));
        }
        return rels;
    }

    Relationships getRelationshipsForTarget(String target) throws IOException, XMLStreamException {
        int lastSlash = target.lastIndexOf("/");
        if (lastSlash == -1) {
            return this.getRelationships("_rels/" + target + ".rels");
        }
        String relPart = target.substring(0, lastSlash) + "/_rels" + target.substring(lastSlash) + ".rels";
        return this.getRelationships(relPart);
    }

    InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.zipFile.getInputStream(entry);
    }

    ZipFile getZip() {
        return this.zipFile;
    }

    void close() throws IOException {
        this.zipFile.close();
    }

    Enumeration<? extends ZipEntry> entries() {
        return this.zipFile.entries();
    }

    static enum Conformance {
        STRICT("strict"),
        TRANSITIONAL("transitional");

        private String conformance;

        private Conformance(String conformance) {
            this.conformance = conformance;
        }
    }
}

