/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunFonts {
    static final String NAME = "rFonts";
    private static final int MAX_NUMBER_OF_EVENTS = 2;
    private static final int MAX_NUMBER_OF_CONTENT_CATEGORIES = 4;
    private static final EnumSet<ContentCategory> FONT_CONTENT_CATEGORIES = EnumSet.of(ContentCategory.ASCII, ContentCategory.HIGH_ANSI, ContentCategory.COMPLEX_SCRIPT, ContentCategory.EAST_ASIAN, ContentCategory.HINT);
    private static final EnumMap<ContentCategory, ContentCategory> fontThemeContentCategories = new EnumMap(ContentCategory.class);
    private XMLEventFactory eventFactory;
    private StartElement startElement;
    private EnumMap<ContentCategory, String> fonts;
    private Set<ContentCategory> detectedContentCategories = EnumSet.noneOf(ContentCategory.class);

    private RunFonts(XMLEventFactory eventFactory, StartElement startElement, EnumMap<ContentCategory, String> fonts) {
        this.eventFactory = eventFactory;
        this.startElement = startElement;
        this.fonts = fonts;
    }

    static RunFonts createRunFonts(StartElementContext startElementContext) throws XMLStreamException {
        EnumMap<ContentCategory, String> fonts = new EnumMap<ContentCategory, String>(ContentCategory.class);
        for (ContentCategory contentCategory : ContentCategory.values()) {
            fonts.put(contentCategory, XMLEventHelpers.getAttributeValue(startElementContext.getStartElement(), new QName(startElementContext.getStartElement().getName().getNamespaceURI(), contentCategory.toString(), startElementContext.getStartElement().getName().getPrefix())));
        }
        new SkippableElements.Default(new SkippableElement[0]).skip(startElementContext);
        return new RunFonts(startElementContext.getEventFactory(), startElementContext.getStartElement(), fonts);
    }

    private EnumMap<ContentCategory, String> getFonts() {
        return this.fonts;
    }

    private boolean isDetectedContentCategory(ContentCategory category) {
        return this.detectedContentCategories.contains((Object)category);
    }

    void setDetectedContentCategories(List<ContentCategory> categories) {
        this.detectedContentCategories.clear();
        this.detectedContentCategories.addAll(categories);
    }

    ContentCategory getContentCategory(ContentCategory contentCategory, ContentCategory defaultContentCategory) {
        return this.fonts.get((Object)contentCategory) == null ? defaultContentCategory : contentCategory;
    }

    boolean canBeMerged(RunFonts runFonts) {
        for (ContentCategory fontContentCategory : FONT_CONTENT_CATEGORIES) {
            if (this.canContentCategoriesBeMerged(fontContentCategory, runFonts)) continue;
            return false;
        }
        return true;
    }

    private boolean canContentCategoriesBeMerged(ContentCategory fontCategory, RunFonts runFonts) {
        if (ContentCategory.HINT == fontCategory) {
            return null == this.fonts.get((Object)fontCategory) && null != runFonts.getFonts().get((Object)fontCategory) || null != this.fonts.get((Object)fontCategory) && null == runFonts.getFonts().get((Object)fontCategory) || Objects.equals(this.fonts.get((Object)fontCategory), runFonts.getFonts().get((Object)fontCategory));
        }
        ContentCategory fontThemeCategory = fontThemeContentCategories.get((Object)fontCategory);
        if (this.isDetectedContentCategory(fontThemeCategory) && runFonts.isDetectedContentCategory(fontCategory)) {
            return Objects.equals(this.fonts.get((Object)fontThemeCategory), runFonts.fonts.get((Object)fontCategory));
        }
        if (this.isDetectedContentCategory(fontCategory) && runFonts.isDetectedContentCategory(fontThemeCategory)) {
            return Objects.equals(this.fonts.get((Object)fontCategory), runFonts.fonts.get((Object)fontThemeCategory));
        }
        if (this.isDetectedContentCategory(fontCategory) && runFonts.isDetectedContentCategory(fontCategory)) {
            return Objects.equals(this.fonts.get((Object)fontCategory), runFonts.fonts.get((Object)fontCategory));
        }
        if (this.isDetectedContentCategory(fontThemeCategory) && runFonts.isDetectedContentCategory(fontThemeCategory)) {
            return Objects.equals(this.fonts.get((Object)fontThemeCategory), runFonts.fonts.get((Object)fontThemeCategory));
        }
        return true;
    }

    RunFonts merge(RunFonts runFonts) {
        EnumMap<ContentCategory, String> newFonts = new EnumMap<ContentCategory, String>(ContentCategory.class);
        for (ContentCategory category : ContentCategory.values()) {
            newFonts.put(category, this.mergeContentCategories(category, runFonts));
        }
        this.fonts = newFonts;
        return this;
    }

    private String mergeContentCategories(ContentCategory contentCategory, RunFonts runFonts) {
        if (ContentCategory.HINT == contentCategory) {
            return null == this.fonts.get((Object)ContentCategory.HINT) ? runFonts.getFonts().get((Object)ContentCategory.HINT) : this.fonts.get((Object)ContentCategory.HINT);
        }
        if (this.isDetectedContentCategory(contentCategory)) {
            return this.fonts.get((Object)contentCategory);
        }
        if (runFonts.isDetectedContentCategory(contentCategory)) {
            return runFonts.fonts.get((Object)contentCategory);
        }
        if (Objects.equals(this.fonts.get((Object)contentCategory), runFonts.getFonts().get((Object)contentCategory))) {
            return this.fonts.get((Object)contentCategory);
        }
        return null;
    }

    List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
        events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes(this.startElement), this.startElement.getNamespaces()));
        events.add(this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces()));
        return events;
    }

    private Iterator<Attribute> getAttributes(StartElement startElement) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(4);
        for (ContentCategory category : ContentCategory.values()) {
            String value = this.fonts.get((Object)category);
            if (value == null) continue;
            attributes.add(this.eventFactory.createAttribute(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), category.toString(), value));
        }
        return attributes.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunFonts runFonts = (RunFonts)o;
        return Objects.equals(this.fonts, runFonts.fonts);
    }

    public int hashCode() {
        return Objects.hash(this.fonts);
    }

    static {
        fontThemeContentCategories.put(ContentCategory.ASCII, ContentCategory.ASCII_THEME);
        fontThemeContentCategories.put(ContentCategory.HIGH_ANSI, ContentCategory.HIGH_ANSI_THEME);
        fontThemeContentCategories.put(ContentCategory.COMPLEX_SCRIPT, ContentCategory.COMPLEX_SCRIPT_THEME);
        fontThemeContentCategories.put(ContentCategory.EAST_ASIAN, ContentCategory.EAST_ASIAN_THEME);
    }

    static enum ContentCategory {
        ASCII("ascii"),
        ASCII_THEME("asciiTheme"),
        HIGH_ANSI("hAnsi"),
        HIGH_ANSI_THEME("hAnsiTheme"),
        COMPLEX_SCRIPT("cs"),
        COMPLEX_SCRIPT_THEME("cstheme"),
        EAST_ASIAN("eastAsia"),
        EAST_ASIAN_THEME("eastAsiaTheme"),
        HINT("hint");

        private final String value;

        private ContentCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

