/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunPropertiesParser
implements Parser<RunProperties> {
    private final StartElementContext startElementContext;
    private final RunSkippableElements runSkippableElements;
    private final List<RunProperty> runProperties;
    private EndElement runPropsEndElement;

    RunPropertiesParser(StartElementContext startElementContext, RunSkippableElements runSkippableElements) {
        this.startElementContext = StartElementContextFactory.createStartElementContext(new StrippableAttributes.General(startElementContext.getConditionalParameters()).strip(StartElementContextFactory.createStartElementContext(new StrippableAttributes.RunRevisions().strip(startElementContext), startElementContext)), startElementContext);
        this.runSkippableElements = runSkippableElements;
        this.runProperties = new ArrayList<RunProperty>();
    }

    @Override
    public RunProperties parse() throws XMLStreamException {
        if ("a".equals(this.startElementContext.getStartElement().getName().getPrefix())) {
            Iterator<Attribute> attrs = this.startElementContext.getStartElement().getAttributes();
            while (attrs.hasNext()) {
                this.runProperties.add(RunPropertyFactory.createRunProperty(attrs.next()));
            }
        }
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isEndElement(e, this.startElementContext.getStartElement())) {
                this.endRunProperties(e.asEndElement());
                return this.buildRunProperties();
            }
            if (e.isStartElement()) {
                if (this.runSkippableElements.skipProperties(e, this.startElementContext)) continue;
                this.addRunProperty(e.asStartElement());
                continue;
            }
            if (!e.isCharacters() || XMLEventHelpers.isWhitespace(e)) continue;
            throw new IllegalStateException("Discarding non-whitespace rPr characters " + e.asCharacters().getData());
        }
        throw new IllegalStateException("Invalid content? Unterminated run properties");
    }

    private void addRunProperty(StartElement startElement) throws XMLStreamException {
        StartElementContext runPropertiesElementContext = StartElementContextFactory.createStartElementContext(startElement, this.startElementContext);
        this.runProperties.add(RunPropertyFactory.createRunProperty(runPropertiesElementContext));
    }

    private void endRunProperties(EndElement e) {
        this.runPropsEndElement = e;
    }

    private RunProperties buildRunProperties() {
        return this.runProperties.isEmpty() ? RunProperties.emptyRunProperties() : new RunProperties.DefaultRunProperties(this.startElementContext.getEventFactory(), this.startElementContext.getStartElement(), this.runPropsEndElement, this.runProperties);
    }
}

