/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.ReplaceableRunProperty;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

public abstract class RunProperty
implements Property,
ReplaceableRunProperty {
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof RunProperty)) {
            return false;
        }
        return this.equalsProperty((RunProperty)o);
    }

    protected abstract boolean equalsProperty(RunProperty var1);

    public abstract int hashCode();

    @Override
    public abstract List<XMLEvent> getEvents();

    @Override
    public boolean canBeReplaced(ReplaceableRunProperty runProperty) {
        return this.equalsProperty((RunProperty)runProperty);
    }

    @Override
    public ReplaceableRunProperty replace(ReplaceableRunProperty runProperty) {
        return runProperty;
    }

    @Override
    public abstract QName getName();

    abstract String getValue();

    static class FontsRunProperty
    extends RunProperty
    implements MergeableRunProperty {
        private RunFonts runFonts;

        public FontsRunProperty(RunFonts runFonts) {
            this.runFonts = runFonts;
        }

        RunFonts getRunFonts() {
            return this.runFonts;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.runFonts.getEvents();
        }

        @Override
        public QName getName() {
            return this.getEvents().get(0).asStartElement().getName();
        }

        @Override
        String getValue() {
            return null;
        }

        @Override
        public boolean canBeMerged(MergeableRunProperty runProperty) {
            if (!(runProperty instanceof FontsRunProperty)) {
                return false;
            }
            return this.runFonts.canBeMerged(((FontsRunProperty)runProperty).runFonts);
        }

        @Override
        public MergeableRunProperty merge(MergeableRunProperty runProperty) {
            this.runFonts = this.runFonts.merge(((FontsRunProperty)runProperty).runFonts);
            return this;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof FontsRunProperty)) {
                return false;
            }
            return this.runFonts.equals(((FontsRunProperty)runProperty).runFonts);
        }

        @Override
        public int hashCode() {
            return this.runFonts.hashCode();
        }

        public String toString() {
            return FontsRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class HyperlinkRunProperty
    extends GenericRunProperty {
        private static final QName ID = Namespaces.DocumentRelationships.getQName("id");

        HyperlinkRunProperty(List<XMLEvent> events) {
            super(events);
        }

        @Override
        String getValue() {
            StartElement startElement = this.getEvents().get(0).asStartElement();
            if (startElement.getAttributeByName(XMLEventHelpers.DML_HYPERLINK_ACTION) != null) {
                return startElement.getAttributeByName(XMLEventHelpers.DML_HYPERLINK_ACTION).getValue();
            }
            if (startElement.getAttributeByName(ID) != null) {
                return startElement.getAttributeByName(ID).getValue();
            }
            return null;
        }
    }

    static class AttributeRunProperty
    extends RunProperty {
        private QName name;
        private String value;

        AttributeRunProperty(QName name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof AttributeRunProperty)) {
                return false;
            }
            AttributeRunProperty other = (AttributeRunProperty)rp;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getValue(), other.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        String getValue() {
            return this.value;
        }

        public String toString() {
            return "AttributeRunProperty(" + this.name + "=" + this.value + ")";
        }
    }

    static class SmlRunProperty
    extends GenericRunProperty {
        private String value = super.getValue();

        SmlRunProperty(List<XMLEvent> events) {
            super(events);
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof SmlRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.getEvents().get(0), runProperty.getEvents().get(0)) && Objects.equals(this.value, ((SmlRunProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public String toString() {
            return SmlRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }

        public String getDefaultValue() {
            return RunPropertyFactory.SmlPropertyName.fromValue(this.getEvents().get(0).asStartElement().getName()).getDefaultValue();
        }
    }

    static class WpmlToggleRunProperty
    extends GenericRunProperty {
        private boolean value;

        WpmlToggleRunProperty(List<XMLEvent> events) {
            super(events);
            this.value = XMLEventHelpers.getBooleanAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE);
        }

        public boolean getToggleValue() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof WpmlToggleRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.getEvents().get(0), runProperty.getEvents().get(0)) && Objects.equals(this.value, ((WpmlToggleRunProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public String toString() {
            return WpmlToggleRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class RunColorProperty
    extends GenericRunProperty {
        static final String NAME = "color";
        private String value;

        RunColorProperty(List<XMLEvent> events) {
            super(events);
            this.value = XMLEventHelpers.getAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof RunColorProperty)) {
                return false;
            }
            return Objects.equals(this.value, ((RunColorProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return RunColorProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class RunHighlightProperty
    extends GenericRunProperty {
        static final String NAME = "highlight";
        private String value;

        RunHighlightProperty(List<XMLEvent> events) {
            super(events);
            this.value = XMLEventHelpers.getAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof RunHighlightProperty)) {
                return false;
            }
            return Objects.equals(this.value, ((RunHighlightProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return RunHighlightProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class RunStyleProperty
    extends GenericRunProperty {
        static final String NAME = "rStyle";
        private String value;

        RunStyleProperty(List<XMLEvent> events) {
            super(events);
            this.value = XMLEventHelpers.getAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof RunStyleProperty)) {
                return false;
            }
            return Objects.equals(this.value, ((RunStyleProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return RunStyleProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class ShadeRunProperty
    extends GenericRunProperty {
        static final String NAME = "shd";
        private static final QName FILL = Namespaces.WordProcessingML.getQName("fill");
        private static final String DEFAULT_FILL_VALUE = "auto";

        ShadeRunProperty(List<XMLEvent> events) {
            super(events);
        }

        String fillValue() {
            String value = XMLEventHelpers.getAttributeValue(this.getEvents().get(0).asStartElement(), FILL);
            return null == value ? DEFAULT_FILL_VALUE : value;
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof ShadeRunProperty)) {
                return false;
            }
            return super.equalsProperty(rp);
        }

        @Override
        public String toString() {
            return ShadeRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class GenericRunProperty
    extends RunProperty {
        private List<XMLEvent> events = new ArrayList<XMLEvent>();

        GenericRunProperty(List<XMLEvent> events) {
            this.events.addAll(events);
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof GenericRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.events, ((GenericRunProperty)rp).events);
        }

        @Override
        public int hashCode() {
            return this.events.hashCode();
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.events;
        }

        @Override
        public QName getName() {
            return this.events.get(0).asStartElement().getName();
        }

        @Override
        String getValue() {
            StartElement startElement = this.events.get(0).asStartElement();
            QName valQname = new QName(startElement.getName().getNamespaceURI(), "val");
            return XMLEventHelpers.getAttributeValue(startElement, valQname);
        }

        public String toString() {
            return "GenericRunProperty(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }
}

