/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.StartElementContext;

interface StrippableAttributes {
    default public StartElement strip(StartElementContext startElementContext, Set<String> strippableAttributeNames) {
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        Iterator<Attribute> currentAttributesIterator = startElementContext.getStartElement().getAttributes();
        while (currentAttributesIterator.hasNext()) {
            Attribute attribute = currentAttributesIterator.next();
            if (strippableAttributeNames.contains(attribute.getName().getLocalPart())) continue;
            newAttributes.add(attribute);
        }
        return startElementContext.getEventFactory().createStartElement(startElementContext.getStartElement().getName(), newAttributes.iterator(), startElementContext.getStartElement().getNamespaces());
    }

    public static interface Name {
        public String value();

        public static enum Revision implements Name
        {
            RPR("rsidRPr"),
            DEL("rsidDel"),
            R("rsidR"),
            SECT("rsidSect"),
            P("rsidP"),
            R_DEFAULT("rsidRDefault"),
            TR("rsidTr");

            private final String value;

            private Revision(String value) {
                this.value = value;
            }

            @Override
            public String value() {
                return this.value;
            }
        }

        public static enum General implements Name
        {
            SPELLING_ERROR("err"),
            NO_PROOFING("noProof"),
            DIRTY("dirty"),
            SMART_TAG_CLEAN("smtClean"),
            LANG("lang"),
            SPACING("spc");

            private final String value;

            private General(String value) {
                this.value = value;
            }

            @Override
            public String value() {
                return this.value;
            }
        }
    }

    public static final class SectionPropertiesRevisions
    implements StrippableAttributes {
        private static final Set<String> SECTION_PROPERTIES_REVISION_ATTRIBUTES = Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.SECT.value()).collect(Collectors.toSet());

        StartElement strip(StartElementContext startElementContext) {
            return this.strip(startElementContext, SECTION_PROPERTIES_REVISION_ATTRIBUTES);
        }
    }

    public static final class TableRowRevisions
    implements StrippableAttributes {
        private static final Set<String> TABLE_ROW_REVISION_ATTRIBUTES = Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.TR.value()).collect(Collectors.toSet());

        StartElement strip(StartElementContext startElementContext) {
            return this.strip(startElementContext, TABLE_ROW_REVISION_ATTRIBUTES);
        }
    }

    public static final class RunRevisions
    implements StrippableAttributes {
        private static final Set<String> RUN_REVISION_ATTRIBUTES = Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value()).collect(Collectors.toSet());

        StartElement strip(StartElementContext startElementContext) {
            return this.strip(startElementContext, RUN_REVISION_ATTRIBUTES);
        }
    }

    public static final class ParagraphRevisions
    implements StrippableAttributes {
        private static final Set<String> PARAGRAPH_REVISION_ATTRIBUTES = Stream.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.P.value(), Name.Revision.R_DEFAULT.value()).collect(Collectors.toSet());

        StartElement strip(StartElementContext startElementContext) {
            return this.strip(startElementContext, PARAGRAPH_REVISION_ATTRIBUTES);
        }
    }

    public static final class General
    implements StrippableAttributes {
        private final Set<String> names;

        General(ConditionalParameters conditionalParameters) {
            Stream<String> unconditional = Stream.of(Name.General.SPELLING_ERROR.value(), Name.General.NO_PROOFING.value(), Name.General.DIRTY.value(), Name.General.SMART_TAG_CLEAN.value(), Name.General.LANG.value());
            Stream<String> merged = conditionalParameters.getCleanupAggressively() ? Stream.concat(unconditional, Stream.of(Name.General.SPACING.value())) : unconditional;
            this.names = merged.collect(Collectors.toSet());
        }

        StartElement strip(StartElementContext startElementContext) {
            return this.strip(startElementContext, this.names);
        }
    }
}

