/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.BlockTextUnitMapper;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ConsumableXMLEventsReader;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.PrioritisedXMLEventReader;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventsReader;

class StyledTextPartHandler
extends GenericPartHandler {
    protected final StyleDefinitions styleDefinitions;
    protected final StyleOptimisation styleOptimisation;
    protected final IdGenerator nestedBlockId;
    protected final IdGenerator textUnitId;
    private StrippableAttributes.TableRowRevisions tableRowRevisions;
    private StrippableAttributes.SectionPropertiesRevisions sectionPropertiesRevisions;
    private SkippableElements tablePropertiesChangeSkippableElements;
    private SkippableElements emptySkippableElements;
    private SkippableElements revisionPropertyChangeSkippableElements;
    private SkippableElements bookmarkSkippableElements;
    private SkippableElements moveToRangeSkippableElements;
    private SkippableElements moveFromRangeSkippableElements;
    private SkippableElements moveToRangeEndSkippableElements;
    private Collection<XMLEvent> prioritisedEvents;
    private XMLEventReader defaultEventReader;
    protected XMLEventReader eventReader;
    protected Iterator<Event> filterEventIterator;
    protected String documentId;
    protected String subDocumentId;
    protected LocaleId sourceLocale;
    protected Markup markup;

    StyledTextPartHandler(ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation) {
        super(cparams, zipFile, entry);
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.nestedBlockId = new IdGenerator(null);
        this.textUnitId = new IdGenerator(entry.getName(), "tu");
        this.markup = new Block.BlockMarkup();
    }

    @Override
    public Event open(String documentId, String subDocumentId, LocaleId sourceLocale) throws IOException, XMLStreamException {
        this.documentId = documentId;
        this.subDocumentId = subDocumentId;
        this.sourceLocale = sourceLocale;
        XMLEventReader defaultEventReader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        return this.open(documentId, subDocumentId, defaultEventReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event open(String documentId, String subDocumentId, XMLEventReader defaultEventReader) throws XMLStreamException {
        this.prioritisedEvents = new LinkedList<XMLEvent>();
        this.defaultEventReader = defaultEventReader;
        this.eventReader = new PrioritisedXMLEventReader(new ConsumableXMLEventsReader(new XMLEventsReader(this.prioritisedEvents)), this.defaultEventReader);
        this.tableRowRevisions = new StrippableAttributes.TableRowRevisions();
        this.sectionPropertiesRevisions = new StrippableAttributes.SectionPropertiesRevisions();
        this.tablePropertiesChangeSkippableElements = new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RevisionProperty.TABLE_PROPERTIES_CHANGE), this.params);
        this.emptySkippableElements = new SkippableElements.Empty();
        this.revisionPropertyChangeSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RevisionProperty.SECTION_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.TABLE_GRID_CHANGE, SkippableElement.RevisionProperty.TABLE_PROPERTIES_EXCEPTIONS_CHANGE, SkippableElement.RevisionProperty.TABLE_ROW_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.TABLE_CELL_PROPERTIES_CHANGE), this.params), this.params);
        this.bookmarkSkippableElements = new SkippableElements.BookmarkCrossStructure(new SkippableElements.CrossStructure(new SkippableElements.Default(SkippableElement.GeneralCrossStructure.BOOKMARK_START, SkippableElement.GeneralCrossStructure.BOOKMARK_END)), "_GoBack");
        this.moveToRangeSkippableElements = new SkippableElements.RevisionCrossStructure(new SkippableElements.CrossStructure(new SkippableElements.Default(SkippableElement.RevisionCrossStructure.MOVE_TO_RANGE_START, SkippableElement.RevisionCrossStructure.MOVE_TO_RANGE_END)));
        this.moveFromRangeSkippableElements = new SkippableElements.MoveFromRevisionCrossStructure(new SkippableElements.RevisionCrossStructure(new SkippableElements.CrossStructure(new SkippableElements.Default(SkippableElement.RevisionCrossStructure.MOVE_FROM_RANGE_START, SkippableElement.RevisionCrossStructure.MOVE_FROM_RANGE_END))), "");
        this.moveToRangeEndSkippableElements = new SkippableElements.Default(SkippableElement.RevisionCrossStructure.MOVE_TO_RANGE_END);
        try {
            this.process();
        }
        finally {
            if (this.eventReader != null) {
                this.eventReader.close();
            }
        }
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    protected boolean isStyledBlockStartEvent(XMLEvent e) {
        return XMLEventHelpers.isParagraphStartEvent(e);
    }

    private void process() throws XMLStreamException {
        StartElement parentStartElement = null;
        while (this.eventReader.hasNext()) {
            StartElementContext startElementContext;
            XMLEvent e = this.eventReader.nextEvent();
            this.preHandleNextEvent(e);
            if (this.isStyledBlockStartEvent(e)) {
                this.flushDocumentPart();
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.eventReader, this.zipFile.getEventFactory(), this.params, this.sourceLocale);
                Block block = new BlockParser(startElementContext, this.nestedBlockId, this.styleDefinitions, this.styleOptimisation).parse();
                if (block.isSkipped()) continue;
                this.prioritiseXMLEvents(block.deferredEvents());
                if (block.isHidden()) {
                    this.documentPartEvents.addAll(block.getEvents());
                    continue;
                }
                List<ITextUnit> textUnits = new BlockTextUnitMapper(block, this.textUnitId).map();
                if (textUnits.isEmpty() || !this.isCurrentBlockTranslatable()) {
                    this.addBlockChunksToDocumentPart(block.getChunks());
                } else {
                    for (ITextUnit tu : textUnits) {
                        this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
                    }
                }
            } else if (XMLEventHelpers.isBlockMarkupStartEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createStartMarkupComponent(this.zipFile.getEventFactory(), e.asStartElement()));
            } else if (XMLEventHelpers.isTablePropertiesStartEvent(e)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.eventReader, this.zipFile.getEventFactory(), this.params);
                this.addMarkupComponentToDocumentPart(MarkupComponentParser.parseBlockProperties(startElementContext, this.tablePropertiesChangeSkippableElements));
            } else if (XMLEventHelpers.isTextBodyPropertiesStartEvent(e)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.eventReader, this.zipFile.getEventFactory(), this.params);
                this.addMarkupComponentToDocumentPart(MarkupComponentParser.parseBlockProperties(startElementContext, this.emptySkippableElements));
            } else if (XMLEventHelpers.isBlockMarkupEndEvent(e)) {
                this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
            } else if (e.isStartElement() && this.revisionPropertyChangeSkippableElements.canBeSkipped(e.asStartElement(), parentStartElement)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), parentStartElement, this.eventReader, this.zipFile.getEventFactory(), this.params);
                this.revisionPropertyChangeSkippableElements.skip(startElementContext);
            } else if (e.isStartElement() && this.bookmarkSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventReader, this.zipFile.getEventFactory(), this.params);
                this.bookmarkSkippableElements.skip(startElementContext);
            } else if (e.isStartElement() && this.moveToRangeSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventReader, this.zipFile.getEventFactory(), this.params);
                this.moveToRangeSkippableElements.skip(startElementContext);
            } else if (e.isStartElement() && this.moveFromRangeSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventReader, this.zipFile.getEventFactory(), this.params);
                this.moveFromRangeSkippableElements.skip(startElementContext);
            } else if (e.isStartElement() && this.moveToRangeEndSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventReader, this.zipFile.getEventFactory(), this.params);
                this.moveToRangeEndSkippableElements.skip(startElementContext);
            } else {
                if (XMLEventHelpers.isSectionPropertiesStartEvent(e)) {
                    e = this.sectionPropertiesRevisions.strip(StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.zipFile.getEventFactory(), this.params));
                } else if (XMLEventHelpers.isTableRowStartEvent(e)) {
                    e = this.tableRowRevisions.strip(StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.zipFile.getEventFactory(), this.params));
                }
                this.addEventToDocumentPart(e);
            }
            if (XMLEventHelpers.isTableGridStartEvent(e)) {
                parentStartElement = e.asStartElement();
                continue;
            }
            if (!XMLEventHelpers.isTableGridEndEvent(e)) continue;
            parentStartElement = null;
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    protected void flushDocumentPart() {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        if (!this.markup.getComponents().isEmpty()) {
            DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
            documentPart.setSkeleton(new MarkupSkeleton(this.markup));
            this.markup = new Block.BlockMarkup();
            this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        }
    }

    private void prioritiseXMLEvents(Collection<XMLEvent> deferredEvents) {
        this.prioritisedEvents.addAll(deferredEvents);
        this.eventReader = new PrioritisedXMLEventReader(new ConsumableXMLEventsReader(new XMLEventsReader(this.prioritisedEvents)), this.defaultEventReader);
    }

    protected void preHandleNextEvent(XMLEvent e) {
    }

    protected boolean isCurrentBlockTranslatable() {
        return true;
    }

    protected void addMarkupComponentToDocumentPart(MarkupComponent markupComponent) {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        this.markup.addComponent(markupComponent);
    }

    protected void addBlockChunksToDocumentPart(List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            if (chunk instanceof Markup) {
                for (MarkupComponent markupComponent : ((Markup)chunk).getComponents()) {
                    this.addMarkupComponentToDocumentPart(markupComponent);
                }
                continue;
            }
            this.documentPartEvents.addAll(chunk.getEvents());
        }
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

