/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.wiki;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.doxygen.DelimiterTokenizer;
import net.sf.okapi.filters.doxygen.PrefixSuffixTokenizer;
import net.sf.okapi.filters.doxygen.RegexTokenizer;
import net.sf.okapi.filters.doxygen.WhitespaceAdjustingEventBuilder;
import net.sf.okapi.filters.wiki.Parameters;
import net.sf.okapi.filters.wiki.WikiPatterns;
import net.sf.okapi.filters.wiki.WikiWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class WikiFilter
extends AbstractFilter {
    public static final String WIKI_MIME_TYPE = "text/x-wiki-txt";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String linebreak = "\n";
    private WhitespaceAdjustingEventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private RawDocument currentRawDocument;
    private BOMNewlineEncodingDetector detector;
    private Parameters params;
    private PrefixSuffixTokenizer commentTokenizer;
    private LinkedList<String> extracted;

    public WikiFilter() {
        this.setMimeType(WIKI_MIME_TYPE);
        this.setMultilingual(false);
        this.setFilterWriter(new WikiWriter());
        this.setName("okf_wiki");
        this.setDisplayName("Wiki Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), WIKI_MIME_TYPE, this.getClass().getName(), "Wiki Markup", "Text with wiki-style markup", "wikiConfiguration.yml", ".txt;"));
        this.setParameters(new Parameters());
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return super.createFilterWriter();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.currentRawDocument = input;
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setEncoding(input.getEncoding());
        this.hasUtf8Bom = this.detector.hasUtf8Bom();
        this.hasUtf8Encoding = this.detector.hasUtf8Encoding();
        this.linebreak = this.detector.getNewlineType().toString();
        this.setNewlineType(this.linebreak);
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Overridding user set encoding (if any). Setting auto-detected encoding ({}).", (Object)detectedEncoding);
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Default encoding and detected encoding not found. Using best guess encoding ({})", (Object)detectedEncoding);
        }
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        BufferedReader reader = new BufferedReader(input.getReader());
        StringBuilder builder = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                builder.append(line + this.linebreak);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error reading wiki markup file", e);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            this.LOGGER.warn("Error closing the wiki text buffered reader.", e);
        }
        DelimiterTokenizer tokenizer = new DelimiterTokenizer(WikiPatterns.TEMP_EXTRACT_PATTERN, builder.toString());
        builder = new StringBuilder();
        this.extracted = new LinkedList();
        for (DelimiterTokenizer.Token token : tokenizer) {
            if (token.delimiter() != null) {
                this.extracted.add(token.delimiter());
                builder.append("\ufffc");
            }
            builder.append(token.toString());
        }
        this.commentTokenizer = new PrefixSuffixTokenizer(WikiPatterns.blockDelimiters, builder.toString());
        if (this.eventBuilder == null) {
            this.eventBuilder = new WhitespaceAdjustingEventBuilder();
        } else {
            this.eventBuilder.reset(null, this);
        }
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        this.eventBuilder.setPreserveWhitespace(this.params.isPreserveWhitespace());
        if (!Util.isEmpty(this.params.getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(((Parameters)this.getParameters()).getSimplifierRules());
            this.eventBuilder.addFilterEvent(cs);
        }
        for (Map.Entry entry : this.params.getCustomCodePatterns().entrySet()) {
            WikiPatterns.inlineDelimiters.put((Pattern)entry.getKey(), entry.getValue() == null ? Pattern.compile("(?=.)|\\z") : (Pattern)entry.getValue());
            if (entry.getValue() == null) continue;
            WikiPatterns.startCodes.put((Pattern)entry.getKey(), null);
            WikiPatterns.endCodes.put((Pattern)entry.getValue(), null);
        }
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(WIKI_MIME_TYPE, "net.sf.okapi.common.encoder.DefaultEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        this.parse();
        return this.eventBuilder.next();
    }

    private void parse() {
        while (this.commentTokenizer.iterator().hasNext()) {
            if (this.isCanceled()) {
                return;
            }
            this.parseBlocks(this.commentTokenizer);
            if (!this.eventBuilder.hasQueuedEvents()) continue;
            return;
        }
        assert (this.extracted.isEmpty());
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit();
        }
        if (this.eventBuilder.isCurrentGroup()) {
            this.eventBuilder.endGroup(null);
        }
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    private void parseBlocks(PrefixSuffixTokenizer tokenizer) {
        for (RegexTokenizer.Token t : tokenizer) {
            if (t.prefixPattern() == null) {
                this.parseTextUnits(new DelimiterTokenizer(WikiPatterns.WHITESPACE_PATTERN, t.toString()));
                continue;
            }
            if (t.prefixPattern() == WikiPatterns.TABLE_START_PATTERN) {
                this.parseSkeleton(t.prefix());
                this.parseTextUnits(new DelimiterTokenizer(WikiPatterns.TABLE_CELL_PATTERN, t.toString()));
                continue;
            }
            if (this.isTranslatable(t)) {
                this.parseSkeleton(t.prefix());
                this.parseBlocks(new PrefixSuffixTokenizer(WikiPatterns.blockDelimiters, t.toString()));
                continue;
            }
            this.parseSkeleton(t.prefix() + t.toString());
        }
    }

    private void parseTextUnits(DelimiterTokenizer tokenizer) {
        for (DelimiterTokenizer.Token t : tokenizer) {
            String text;
            if (t.delimiter() != null) {
                this.parseSkeleton(t.delimiter());
            }
            if ((text = t.toString()).length() == 0) continue;
            if (text.trim().length() == 0) {
                this.parseSkeleton(text);
                continue;
            }
            this.eventBuilder.startTextUnit();
            this.parseInlineCodes(new PrefixSuffixTokenizer(WikiPatterns.inlineDelimiters, this.replaceExtracted(t.toString())), true);
            this.eventBuilder.endTextUnit();
        }
    }

    private void parseInlineCodes(PrefixSuffixTokenizer tokenizer, boolean enabled) {
        for (RegexTokenizer.Token t : tokenizer) {
            if (t.prefix() == null) {
                this.eventBuilder.addToTextUnit(t.toString());
                continue;
            }
            if (enabled || this.shouldReenable(t)) {
                if (t.prefix().length() > 0) {
                    this.parseCode(t);
                }
                enabled = this.shouldEnable(t);
            } else {
                this.eventBuilder.addToTextUnit(t.prefix());
            }
            this.parseInlineCodes(new PrefixSuffixTokenizer(WikiPatterns.inlineDelimiters, t.toString()), enabled);
        }
    }

    private void parseCode(RegexTokenizer.Token token) {
        Matcher m;
        Code code = new Code(this.getTagType(token), null, token.prefix());
        Pattern propPattern = WikiPatterns.properties.get(token.prefixPattern());
        if (propPattern != null && (m = propPattern.matcher(token.prefix())).find()) {
            PropertyTextUnitPlaceholder p = new PropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType.TRANSLATABLE, "", m.group(), m.start(), m.end());
            ArrayList<PropertyTextUnitPlaceholder> ps = new ArrayList<PropertyTextUnitPlaceholder>();
            ps.add(p);
            this.eventBuilder.addToTextUnit(code, true, ps);
            return;
        }
        this.eventBuilder.addToTextUnit(code);
    }

    private void parseSkeleton(String string) {
        this.eventBuilder.addDocumentPart(this.replaceExtracted(string));
    }

    private String replaceExtracted(String string) {
        while (string.contains("\ufffc")) {
            string = string.replaceFirst("\ufffc", Matcher.quoteReplacement(this.extracted.pop()));
        }
        return string;
    }

    private boolean isTranslatable(RegexTokenizer.Token t) {
        return !WikiPatterns.untranslatable.containsKey(t.prefixPattern());
    }

    private boolean shouldReenable(RegexTokenizer.Token t) {
        return WikiPatterns.noWiki.containsValue(t.prefixPattern());
    }

    private boolean shouldEnable(RegexTokenizer.Token t) {
        return !WikiPatterns.noWiki.containsKey(t.prefixPattern());
    }

    private TextFragment.TagType getTagType(RegexTokenizer.Token t) {
        if (WikiPatterns.startCodes.containsKey(t.prefixPattern())) {
            return TextFragment.TagType.OPENING;
        }
        if (WikiPatterns.endCodes.containsKey(t.prefixPattern())) {
            return TextFragment.TagType.CLOSING;
        }
        return TextFragment.TagType.PLACEHOLDER;
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }
}

