/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.ITSProvenanceAnnotations;
import net.sf.okapi.common.annotation.XLIFFNote;
import net.sf.okapi.common.annotation.XLIFFNoteAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.layerprovider.ILayerProvider;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.StorageList;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.filters.xliff.XLIFFITSFilterExtension;
import net.sf.okapi.filters.xliff.its.ITSStandoffManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFFSkeletonWriter
extends GenericSkeletonWriter {
    public static final String SEGSOURCEMARKER = "[@#$SEGSRC$#@]";
    public static final String ALTTRANSMARKER = "[@#$ALTTRANS$#@]";
    public static final String ITSNSDECL = "[@#ITSNSDECL#@]";
    public static final String NOTEMARKER = "[@#$NOTE$#@]";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params;
    private XLIFFContent fmt;
    private ITSContent itsCont;
    private ITSStandoffManager itsStandoffManager;
    private Map<String, GenericAnnotations> lqiStandoff = new HashMap<String, GenericAnnotations>();
    private Map<String, GenericAnnotations> provStandoff = new HashMap<String, GenericAnnotations>();
    private CharsetEncoder chsEnc;

    public XLIFFSkeletonWriter() {
        this.params = new Parameters();
        this.fmt = new XLIFFContent();
    }

    public XLIFFSkeletonWriter(Parameters params) {
        this.params = params;
        this.fmt = new XLIFFContent();
    }

    public XLIFFSkeletonWriter(Parameters params, XLIFFContent fmt, ITSContent itsCont, ITSStandoffManager itsStandoffManager, Map<String, GenericAnnotations> lqiStandoff, Map<String, GenericAnnotations> provStandoff, CharsetEncoder chsEnc) {
        this.params = params;
        this.fmt = fmt;
        this.itsCont = itsCont;
        this.setITSStandoffManager(itsStandoffManager);
        this.lqiStandoff = lqiStandoff;
        this.provStandoff = provStandoff;
        this.chsEnc = chsEnc;
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        String res = super.processStartDocument(outputLocale, outputEncoding, layer, encoderManager, resource);
        this.chsEnc = encoderManager.getCharsetEncoder();
        this.fmt.setCharsetEncoder(this.chsEnc);
        return res;
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        this.addLQIAnnotations(resource);
        this.addProvAnnotations(resource);
        this.addLQIAnnotations(resource.getSource());
        this.addProvAnnotations(resource.getSource());
        Set<LocaleId> targetLocales = resource.getTargetLocales();
        if (targetLocales.size() > 1) {
            this.logger.debug("More than one target locale {}", (Object)targetLocales);
        } else if (targetLocales.size() == 1) {
            for (LocaleId tgt : targetLocales) {
                this.addLQIAnnotations(resource.getTarget(tgt));
                this.addProvAnnotations(resource.getTarget(tgt));
            }
        }
        return super.processTextUnit(resource);
    }

    @Override
    public String processStartSubDocument(StartSubDocument resource) {
        this.addProvAnnotations(resource);
        return super.processStartSubDocument(resource);
    }

    @Override
    public String processStartGroup(StartGroup resource) {
        this.addProvAnnotations(resource);
        return super.processStartGroup(resource);
    }

    private void addProvAnnotations(INameable referent) {
        String itsProvRef;
        ITSProvenanceAnnotations anns = referent.getAnnotation(ITSProvenanceAnnotations.class);
        if (anns != null && !this.provStandoff.containsKey(itsProvRef = anns.getData())) {
            if (itsProvRef == null) {
                if (anns.size() == 1) {
                    ITSContent itsContent = new ITSContent(this.encoderManager.getCharsetEncoder(), false, true);
                    String provAttr = itsContent.writeAttributeProvenance(anns.getFirstAnnotation("its-prov"));
                    referent.setProperty(new Property("provenanceRecordsRef", provAttr));
                } else if (anns.size() > 1) {
                    this.logger.warn("Multiple provenance annotations found without standoff reference on {}", (Object)referent.getName());
                }
            } else {
                if (anns.size() == 0) {
                    this.logger.warn("its:provenanceRecordsRef set on {} but no annotations found", (Object)referent.getName());
                }
                if (XLIFFITSFilterExtension.getResourcePart(itsProvRef).equals("")) {
                    GenericAnnotations newSet = new GenericAnnotations();
                    newSet.setData(XLIFFITSFilterExtension.getFragmentIdPart(itsProvRef));
                    newSet.addAll(anns.getAnnotations("its-prov"));
                    this.provStandoff.put(itsProvRef, newSet);
                }
            }
        }
    }

    private void addLQIAnnotations(INameable referent) {
        String itsLQIRef;
        ITSLQIAnnotations anns = referent.getAnnotation(ITSLQIAnnotations.class);
        if (anns != null && !this.lqiStandoff.containsKey(itsLQIRef = anns.getData())) {
            if (itsLQIRef == null) {
                if (anns.size() == 1) {
                    ITSContent itsContent = new ITSContent(this.encoderManager.getCharsetEncoder(), false, true);
                    String lqiAttr = itsContent.writeAttributesLQI(anns.getFirstAnnotation("its-lqi"));
                    referent.setProperty(new Property("locQualityIssuesRef", lqiAttr));
                } else if (anns.size() > 1) {
                    this.logger.warn("Multiple locQualityIssue annotations found without standoff reference on {}", (Object)referent.getName());
                }
            } else {
                if (anns.size() == 0) {
                    this.logger.warn("its:locQualityIssuesRef set on {} but no annotations found", (Object)referent.getName());
                }
                if (XLIFFITSFilterExtension.getResourcePart(itsLQIRef).equals("")) {
                    GenericAnnotations newSet = new GenericAnnotations();
                    newSet.setData(XLIFFITSFilterExtension.getFragmentIdPart(itsLQIRef));
                    newSet.addAll(anns.getAnnotations("its-lqi"));
                    this.lqiStandoff.put(itsLQIRef, newSet);
                }
            }
        }
    }

    @Override
    public String processEndDocument(Ending resource) {
        Collection c;
        StringBuilder endDoc = new StringBuilder();
        ITSContent itsContent = new ITSContent(this.encoderManager.getCharsetEncoder(), false, true);
        Comparator<String> nullKeyComparator = Util.createComparatorHandlingNullKeys(String.class);
        if (!this.lqiStandoff.isEmpty()) {
            TreeMap<String, GenericAnnotations> sortedlqiStandoff = new TreeMap<String, GenericAnnotations>(nullKeyComparator);
            sortedlqiStandoff.putAll(this.lqiStandoff);
            c = sortedlqiStandoff.values();
            endDoc.append(itsContent.writeStandoffLQI(new ArrayList<GenericAnnotations>(c)));
        }
        if (!this.provStandoff.isEmpty()) {
            TreeMap<String, GenericAnnotations> sortedProvStandoff = new TreeMap<String, GenericAnnotations>(nullKeyComparator);
            sortedProvStandoff.putAll(this.provStandoff);
            c = sortedProvStandoff.values();
            endDoc.append(itsContent.writeStandoffProvenance(new ArrayList<GenericAnnotations>(c)));
        }
        endDoc.append(super.processEndDocument(resource));
        return endDoc.toString();
    }

    public void addUnusedAnnotations(StringBuilder endDoc, ITSContent itsContent, Collection<String> storedAnns, HashMap<String, GenericAnnotations> standoff, Class<? extends GenericAnnotations> type) {
        ArrayList<GenericAnnotations> unusedAnns = new ArrayList<GenericAnnotations>();
        if (this.getITSStandoffManager() != null) {
            for (String stored : storedAnns) {
                if (standoff.containsKey(stored) || !XLIFFITSFilterExtension.getResourcePart(stored).equals("")) continue;
                this.logger.warn("{} ref \"{}\" not referred to/used", (Object)type, (Object)stored);
                GenericAnnotations ann = new GenericAnnotations();
                if (type.equals(ITSLQIAnnotations.class)) {
                    this.getITSStandoffManager().addLQIAnnotation(ann, stored);
                } else if (type.equals(ITSProvenanceAnnotations.class)) {
                    this.getITSStandoffManager().addProvAnnotation(ann, stored);
                }
                ann.setData(XLIFFITSFilterExtension.getFragmentIdPart(stored));
                unusedAnns.add(ann);
            }
            if (type.equals(ITSLQIAnnotations.class)) {
                endDoc.append(itsContent.writeStandoffLQI(unusedAnns));
            } else if (type.equals(ITSProvenanceAnnotations.class)) {
                endDoc.append(itsContent.writeStandoffProvenance(unusedAnns));
            }
        }
    }

    @Override
    protected String getString(GenericSkeletonPart part, EncoderContext context) {
        if (part.toString().startsWith(SEGSOURCEMARKER)) {
            return this.getSegSourceOutput((ITextUnit)part.getParent());
        }
        if (part.toString().startsWith(ALTTRANSMARKER)) {
            return this.getNewAltTransOutput((ITextUnit)part.getParent());
        }
        if (part.toString().startsWith(NOTEMARKER)) {
            return this.getNewNoteOutput((ITextUnit)part.getParent());
        }
        boolean needITSDecl = false;
        if (part.toString().startsWith(ITSNSDECL)) {
            needITSDecl = true;
            part.getData().delete(0, ITSNSDECL.length());
        }
        if (!part.toString().startsWith("[#$")) {
            if (this.getLayer() == null) {
                return part.toString();
            }
            return this.getLayer().encode(part.toString(), context);
        }
        Object[] marker = TextFragment.getRefMarker(part.getData());
        if (marker == null) {
            this.logger.error("Invalid ref marker for resource {}\nIn GenericSkeletonPart: {}", (Object)(part.getParent() == null ? "null" : part.getParent().toString()), (Object)part.getData());
            return "-ERR:INVALID-REF-MARKER-";
        }
        String propName = (String)marker[3];
        if (propName != null) {
            String value = this.getString((INameable)part.getParent(), propName, part.getLocale(), context);
            if (needITSDecl && !Util.isEmpty(value) && value.startsWith(" its:")) {
                value = " xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"" + value;
            }
            return value;
        }
        LocaleId locToUse = part.getLocale() == null ? this.outputLoc : part.getLocale();
        EncoderContext contextToUse = context;
        if (this.isMultilingual) {
            locToUse = part.getLocale();
            EncoderContext encoderContext = contextToUse = locToUse == null ? EncoderContext.TEXT : context;
        }
        if (part.getParent() != null) {
            if (part.getParent() instanceof ITextUnit) {
                return this.getContent((ITextUnit)part.getParent(), locToUse, contextToUse);
            }
            throw new OkapiException("The self-reference to this skeleton part must be a text-unit.");
        }
        IReferenceable ref = this.getReference((String)marker[0]);
        if (ref == null) {
            this.logger.warn("Reference '{}' not found.", (Object)((String)marker[0]));
            return "-ERR:REF-NOT-FOUND-";
        }
        if (ref instanceof ITextUnit) {
            return this.getString((ITextUnit)ref, locToUse, contextToUse);
        }
        if (ref instanceof GenericSkeletonPart) {
            return this.getString((GenericSkeletonPart)((Object)ref), contextToUse);
        }
        if (ref instanceof StorageList) {
            return this.getString((StorageList)ref, locToUse, contextToUse);
        }
        return this.getString((GenericSkeleton)((IResource)((Object)ref)).getSkeleton(), context);
    }

    @Override
    protected String getContent(ITextUnit tu, LocaleId locToUse, EncoderContext context) {
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(tu.getMimeType());
        }
        if (!tu.isTranslatable()) {
            context = EncoderContext.TEXT;
        }
        TextContainer srcCont = tu.getSource();
        if (locToUse == null) {
            return this.getUnsegmentedOutput(srcCont, locToUse, context);
        }
        boolean doSegments = this.doSegments(tu);
        TextContainer trgCont = tu.getTarget(locToUse);
        if (trgCont == null || trgCont.isEmpty()) {
            trgCont = this.params.getAllowEmptyTargets() ? tu.createTarget(locToUse, true, 4) : srcCont;
        }
        if (XLIFFFilter.isUnsegmentedTextUnit(tu, this.params)) {
            return this.getUnsegmentedOutput(trgCont, locToUse, context);
        }
        if (doSegments || this.getLayer() != null && tu.isTranslatable() && !trgCont.equals(srcCont)) {
            return this.getSegmentedOutput(srcCont, trgCont, locToUse, context);
        }
        return this.getUnsegmentedOutput(trgCont, locToUse, context);
    }

    private String getSegSourceOutput(ITextUnit tu) {
        if (!this.doSegments(tu)) {
            return "";
        }
        TextContainer srcCont = tu.getSource();
        StringBuilder tmp = new StringBuilder("<seg-source>");
        if (XLIFFFilter.isUnsegmentedTextUnit(tu, this.params)) {
            tmp.append(this.getContent(tu.getSource().getFirstSegment().text, null, EncoderContext.SKELETON));
        } else {
            for (TextPart part : srcCont) {
                if (part.isSegment()) {
                    Segment srcSeg = (Segment)part;
                    tmp.append(String.format("<mrk mid=\"%s\" mtype=\"seg\">", srcSeg.id));
                    tmp.append(this.getContent(srcSeg.text, null, EncoderContext.SKELETON));
                    tmp.append("</mrk>");
                    continue;
                }
                tmp.append(this.getContent(part.text, null, EncoderContext.SKELETON));
            }
        }
        tmp.append("</seg-source>");
        if (tu.getProperty("wassegmented") == null) {
            tmp.append(this.encoderManager.getLineBreak());
        }
        return tmp.toString();
    }

    private String getNewAltTransOutput(ITextUnit tu) {
        if (!this.params.getAddAltTrans()) {
            return "";
        }
        if (tu.getSource().isEmpty()) {
            return "";
        }
        if (!tu.hasTarget(this.outputLoc)) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        TextContainer tc = tu.getTarget(this.outputLoc);
        this.formatAltTranslations(tc.getAnnotation(AltTranslationsAnnotation.class), null, tmp);
        for (Segment seg : tc.getSegments()) {
            this.formatAltTranslations(seg.getAnnotation(AltTranslationsAnnotation.class), seg, tmp);
        }
        return tmp.toString();
    }

    private String getNewNoteOutput(ITextUnit tu) {
        XLIFFNoteAnnotation notes = tu.getAnnotation(XLIFFNoteAnnotation.class);
        if (notes == null) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        for (XLIFFNote n : notes) {
            tmp.append("<note");
            if (n.getAnnotates() != null) {
                tmp.append(" ").append("annotates").append("=\"");
                tmp.append(this.encoderManager.encode(n.getAnnotates().toString(), EncoderContext.INLINE));
                tmp.append("\"");
            }
            if (n.getFrom() != null) {
                tmp.append(" ").append("from").append("=\"");
                tmp.append(this.encoderManager.encode(n.getFrom(), EncoderContext.INLINE));
                tmp.append("\"");
            }
            if (n.getPriority() != null) {
                tmp.append(" ").append("priority").append("=\"");
                tmp.append(this.encoderManager.encode(n.getPriority().toString(), EncoderContext.INLINE));
                tmp.append("\"");
            }
            tmp.append(">");
            tmp.append(this.encoderManager.encode(n.getNoteText(), EncoderContext.TEXT));
            tmp.append("</note>");
        }
        return tmp.toString();
    }

    private void formatAltTranslations(AltTranslationsAnnotation ann, Segment segment, StringBuilder sb) {
        if (ann == null) {
            return;
        }
        for (AltTranslation alt : ann) {
            if (alt.getFromOriginal() && !this.params.getEditAltTrans()) continue;
            sb.append("<alt-trans");
            if (segment != null) {
                sb.append(String.format(" mid=\"%s\"", Util.escapeToXML(segment.getId(), 0, false, this.chsEnc)));
            }
            if (alt.getCombinedScore() > 0) {
                sb.append(String.format(" match-quality=\"%d\"", alt.getCombinedScore()));
            }
            if (alt.getTool() != null && alt.getTool().getId() != null) {
                sb.append(String.format(" tool-id=\"%s\"", Util.escapeToXML(alt.getTool().getId(), 0, false, this.chsEnc)));
            }
            if (!Util.isEmpty(alt.getOrigin()) && !alt.getOrigin().equals("SourceDoc")) {
                sb.append(String.format(" origin=\"%s\"", Util.escapeToXML(alt.getOrigin(), 0, false, this.chsEnc)));
            }
            if (this.params.getIncludeExtensions() && alt.getType() != MatchType.UKNOWN) {
                sb.append(" xmlns:okp=\"okapi-framework:xliff-extensions\"");
                sb.append(String.format(" okp:matchType=\"%s\"", alt.getType().toString()));
            }
            sb.append(">" + this.encoderManager.getLineBreak());
            TextContainer cont = alt.getSource();
            if (!cont.isEmpty()) {
                sb.append(String.format("<source xml:lang=\"%s\">", alt.getSourceLocale().toString()));
                sb.append(this.fmt.toSegmentedString(cont, 0, false, false, this.params.getAddAltTransGMode(), false, this.params.getIncludeIts(), this.outputLoc));
                sb.append("</source>" + this.encoderManager.getLineBreak());
            }
            sb.append(String.format("<target xml:lang=\"%s\"", alt.getTargetLocale().toString()));
            this.outputITSAttributes(alt.getTarget().getAnnotation(GenericAnnotations.class), this.params.getEscapeGT(), false, sb, this.outputLoc, true);
            sb.append(">");
            sb.append(this.fmt.toSegmentedString(alt.getTarget(), 0, false, false, this.params.getAddAltTransGMode(), false, this.params.getIncludeIts(), this.outputLoc));
            sb.append("</target>" + this.encoderManager.getLineBreak());
            sb.append("</alt-trans>" + this.encoderManager.getLineBreak());
        }
    }

    private String getUnsegmentedOutput(TextContainer cont, LocaleId locToUse, EncoderContext context) {
        TextFragment tf = null;
        tf = cont.contentIsOneSegment() ? cont.getFirstContent() : cont.getUnSegmentedContentCopy();
        if (this.getLayer() == null) {
            return this.getContent(tf, locToUse, context);
        }
        switch (context) {
            case SKELETON: {
                return this.getLayer().endCode() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.getLayer().startCode();
            }
            case INLINE: {
                return this.getLayer().endInline() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.getLayer().startInline();
            }
        }
        return this.getContent(tf, locToUse, context);
    }

    @Override
    protected String expandCodeContent(Code code, LocaleId locToUse, EncoderContext context) {
        if (code.hasOnlyAnnotation()) {
            if (code.getTagType() == TextFragment.TagType.OPENING) {
                boolean mtypeNeeded = true;
                StringBuilder tmp = new StringBuilder(code.getOuterData());
                if (tmp.length() > 0) {
                    tmp.delete(tmp.length() - 1, tmp.length());
                    mtypeNeeded = false;
                } else {
                    tmp.append("<mrk");
                }
                this.outputITSAttributes(code.getGenericAnnotations(), this.params.getEscapeGT(), mtypeNeeded, tmp, locToUse, false);
                tmp.append(">");
                return tmp.toString();
            }
            return "</mrk>";
        }
        return super.expandCodeContent(code, locToUse, context);
    }

    private void outputITSAttributes(GenericAnnotations anns, boolean escapeGT, boolean mtypeNeeded, StringBuilder output, LocaleId trgLocId, boolean writeMTConfAnnotatorsRef) {
        if (this.itsCont == null) {
            this.itsCont = new ITSContent(this.chsEnc, false, true);
        }
        this.itsCont.outputAnnotations(anns, output, true, true, mtypeNeeded, trgLocId);
        if (writeMTConfAnnotatorsRef) {
            if (anns == null) {
                return;
            }
            GenericAnnotation ga = anns.getFirstAnnotation("its-mtconfidence");
            if (ga == null) {
                return;
            }
            String ref = ga.getString("annotatorRef");
            if (ref == null) {
                return;
            }
            output.append(" its:annotatorsRef=\"mt-confidence|" + ref + "\"");
        }
    }

    private String getSegmentedOutput(TextContainer srcCont, TextContainer trgCont, LocaleId locToUse, EncoderContext context) {
        StringBuilder tmp = new StringBuilder();
        ISegments srcSegs = srcCont.getSegments();
        for (TextPart part : trgCont) {
            if (part.isSegment()) {
                int lev = 0;
                Segment trgSeg = (Segment)part;
                Segment srcSeg = srcSegs.get(trgSeg.id);
                if (srcSeg == null) {
                    this.logger.warn("No source segment found for target segment id='{}':\n\"{}\".", (Object)trgSeg.id, (Object)trgSeg.text.toText());
                }
                tmp.append(String.format("<mrk mid=\"%s\" mtype=\"seg\"", trgSeg.id));
                this.outputITSAttributes(trgSeg.getAnnotation(GenericAnnotations.class), this.params.getEscapeGT(), false, tmp, locToUse, true);
                tmp.append(">");
                if (this.getLayer() == null) {
                    tmp.append(this.getContent(trgSeg.text, locToUse, context));
                } else {
                    switch (context) {
                        case SKELETON: {
                            tmp.append(this.getLayer().endCode() + this.getLayer().startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.getLayer().midSegment(lev) + this.getContent(trgSeg.text, locToUse, EncoderContext.TEXT) + this.getLayer().endSegment() + this.getLayer().startCode());
                            break;
                        }
                        case INLINE: {
                            tmp.append(this.getLayer().endInline() + this.getLayer().startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.getLayer().midSegment(lev) + this.getContent(trgSeg.text, locToUse, EncoderContext.TEXT) + this.getLayer().endSegment() + this.getLayer().startInline());
                            break;
                        }
                        default: {
                            tmp.append(this.getLayer().startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.getLayer().midSegment(lev) + this.getContent(trgSeg.text, locToUse, EncoderContext.TEXT) + this.getLayer().endSegment());
                        }
                    }
                }
                tmp.append("</mrk>");
                continue;
            }
            tmp.append(this.getContent(part.text, locToUse, context));
        }
        return tmp.toString();
    }

    private boolean doSegments(ITextUnit tu) {
        switch (this.params.getOutputSegmentationType()) {
            case SEGMENTED: {
                return true;
            }
            case NOTSEGMENTED: {
                return false;
            }
            case ASNEEDED: {
                return !tu.getSource().contentIsOneSegment();
            }
            case ORIGINAL: {
                Property prop = tu.getProperty("wassegmented");
                if (prop == null) break;
                return prop.getValue().equals("true");
            }
        }
        return false;
    }

    @Override
    protected String getPropertyValue(INameable resource, String name, LocaleId locToUse, EncoderContext context) {
        GenericAnnotations anns;
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(resource.getMimeType());
        }
        Property prop = null;
        String value = null;
        if (locToUse == null) {
            prop = resource.getSourceProperty(name);
        } else if (locToUse.equals(LocaleId.EMPTY)) {
            prop = resource.getProperty(name);
        } else if (resource.hasTargetProperty(locToUse, name)) {
            prop = resource.getTargetProperty(locToUse, name);
        } else if ("approved".equals(name)) {
            value = "";
        } else {
            prop = resource.getSourceProperty(name);
        }
        if (value == null) {
            if (prop == null) {
                this.logger.warn("Property '{}' not found.", (Object)name);
                return "-ERR:PROP-NOT-FOUND-";
            }
            value = prop.getValue();
        }
        if (value == null) {
            this.logger.warn("Property value for '{}' is null.", (Object)name);
            return "-ERR:PROP-VALUE-NULL-";
        }
        if ("language".equals(name)) {
            LocaleId locId = LocaleId.fromString(value);
            if (locId.equals(this.inputLoc)) {
                value = this.outputLoc.toString();
            }
        } else if ("encoding".equals(name)) {
            value = this.outputEncoding;
        } else if ("approved".equals(name)) {
            if (!value.isEmpty()) {
                value = String.format(" approved=\"%s\"", value);
            }
        } else if ("locQualityIssuesRef".equals(name)) {
            ITSLQIAnnotations anns2 = resource.getAnnotation(ITSLQIAnnotations.class);
            if (anns2 == null) {
                value = "";
            }
        } else if ("provenanceRecordsRef".equals(name)) {
            ITSProvenanceAnnotations anns3 = resource.getAnnotation(ITSProvenanceAnnotations.class);
            if (anns3 == null) {
                value = "";
            }
        } else if ("mtConfidence".equals(name) && (anns = resource.getAnnotation(GenericAnnotations.class)) != null) {
            GenericAnnotation ga = anns.getFirstAnnotation("its-mtconfidence");
            value = ga != null ? " its:mtConfidence=\"" + ga.getDouble("its-mtconfidenceValue") + "\" its:annotatorsRef=\"mt-confidence|" + ga.getString("annotatorRef") + "\"" : "";
        }
        if (this.encoderManager == null) {
            if (this.getLayer() == null) {
                return value;
            }
            return this.getLayer().encode(value, context);
        }
        if (this.getLayer() == null) {
            return this.encoderManager.toNative(name, value);
        }
        return this.getLayer().encode(this.encoderManager.toNative(name, value), context);
    }

    public ITSStandoffManager getITSStandoffManager() {
        return this.itsStandoffManager;
    }

    public void setITSStandoffManager(ITSStandoffManager itsStandoffManager) {
        this.itsStandoffManager = itsStandoffManager;
    }

    public Parameters getParams() {
        return this.params;
    }

    public final XLIFFContent getFmt() {
        return this.fmt;
    }

    public final ITSContent getItsCont() {
        return this.itsCont;
    }

    public final Map<String, GenericAnnotations> getLqiStandoff() {
        return this.lqiStandoff;
    }

    public final Map<String, GenericAnnotations> getProvStandoff() {
        return this.provStandoff;
    }

    public final CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    protected void setParams(Parameters params) {
        this.params = params;
    }
}

