/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.gtt;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GTTClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String HYPHENS = "--";
    private static final String BOUNDARY = "END_OF_PART";
    private static final String LINEBREAK = "\r\n";
    private static final int RESCODE_OK = 200;
    private static final int RESCODE_CREATED = 201;
    private static final int MAXBUFFERSIZE = 8192;
    private DocumentBuilder docBuilder;
    private String credentials;
    private String clientApp;
    private String srcLang;
    private String trgLang;

    public GTTClient(String clientApp) {
        this.clientApp = clientApp;
        DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
        Fact.setValidating(false);
        try {
            Fact.setFeature("http://xml.org/sax/features/external-general-entities", false);
            Fact.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            this.logger.warn("Unsupported DocumentBuilderFactory feature. Possible security vulnerabilities.", e);
        }
        try {
            this.docBuilder = Fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiException("Error creating document builder.", e);
        }
    }

    public void setCredentials(String email, String password) {
        block12: {
            FilterOutputStream dos = null;
            try {
                URL url = new URL("https://www.google.com/accounts/ClientLogin");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                dos = new DataOutputStream(conn.getOutputStream());
                this.writeParameters((DataOutputStream)dos, "accountType", "GOOGLE", "Email", email, "Passwd", password, "service", "gtrans", "source", this.clientApp);
                ((DataOutputStream)dos).flush();
                dos.close();
                dos = null;
                int code = conn.getResponseCode();
                if (code == 200) {
                    String resp = this.readResponse(conn);
                    int n = resp.indexOf("Auth=");
                    if (n == -1) {
                        throw new OkapiException("Invalid response: Auth field missing.");
                    }
                    this.credentials = "GoogleLogin auth=" + resp.substring(n + 5).trim();
                    break block12;
                }
                throw new OkapiException("Cannot connect to Google Translator Toolkit:\n" + conn.getResponseMessage());
            }
            catch (IOException e) {
                throw new OkapiException("Cannot connect to Google Translator Toolkit.", e);
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void setLanguages(LocaleId srcLoc, LocaleId trgLoc) {
        this.srcLang = this.toInternalCode(srcLoc);
        this.trgLang = this.toInternalCode(trgLoc);
    }

    private String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        if (!code.startsWith("zh") && code.length() > 2) {
            code = code.substring(0, 2);
        }
        return code;
    }

    public String createTM(String name) {
        String id = null;
        FilterOutputStream dos = null;
        try {
            URL url = new URL("https://translate.google.com/toolkit/feeds/tm");
            HttpURLConnection conn = this.createConnection(url, "POST");
            conn.setRequestProperty("Content-Type", "application/atom+xml");
            dos = new DataOutputStream(conn.getOutputStream());
            String tmp = String.format("<?xml version='1.0' encoding='UTF-8'?><entry xmlns='http://www.w3.org/2005/Atom' xmlns:gtt='http://schemas.google.com/gtt/2009/11'><title>%s</title><gtt:scope>private</gtt:scope></entry>", name);
            ((DataOutputStream)dos).writeBytes(tmp);
            ((DataOutputStream)dos).flush();
            dos.close();
            int code = conn.getResponseCode();
            if (code == 201) {
                Document doc = this.docBuilder.parse(conn.getInputStream());
                Element elem = (Element)doc.getDocumentElement().getFirstChild();
                id = elem.getTextContent();
                id = id.substring(id.lastIndexOf(47) + 1);
            }
        }
        catch (IOException | SAXException e) {
            throw new OkapiException("Cannot create a TM.", e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return id;
    }

    public String uploadDocument(String path, String name, String tmId) {
        String id = null;
        FilterOutputStream dos = null;
        try (FileInputStream fis = new FileInputStream(path);){
            if (name == null) {
                name = path;
            }
            URL url = new URL("https://translate.google.com/toolkit/feeds/documents");
            HttpURLConnection conn = this.createConnection(url, "POST");
            conn.setRequestProperty("Content-Type", "multipart/related; boundary=END_OF_PART");
            conn.setRequestProperty("Slug", name);
            dos = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)dos).writeBytes("--END_OF_PART\r\n");
            ((DataOutputStream)dos).writeBytes("Content-Type: application/atom+xml\r\n\r\n");
            String tmp = String.format("<?xml version='1.0' encoding='UTF-8'?>\r\n<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gtt='http://schemas.google.com/gtt/2009/11'>\r\n<title>%s</title>\r\n<gtt:sourceLanguage>%s</gtt:sourceLanguage>\r\n<gtt:targetLanguage>%s</gtt:targetLanguage>\r\n", name, this.srcLang, this.trgLang);
            if (tmId != null) {
                tmp = tmp + "<gtt:translationMemory><link href='https://translate.google.com/toolkit/feeds/tm/" + tmId + "'/></gtt:translationMemory>";
            }
            tmp = tmp + "</entry>" + LINEBREAK + LINEBREAK;
            ((DataOutputStream)dos).writeBytes(tmp);
            ((DataOutputStream)dos).writeBytes("--END_OF_PART\r\n");
            ((DataOutputStream)dos).writeBytes("Content-Type: text/html\r\n\r\n");
            int bytesAvailable = fis.available();
            int bufferSize = Math.min(bytesAvailable, 8192);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fis.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                ((DataOutputStream)dos).write(buffer, 0, bufferSize);
                bytesAvailable = fis.available();
                bufferSize = Math.min(bytesAvailable, 8192);
                bytesRead = fis.read(buffer, 0, bufferSize);
            }
            ((DataOutputStream)dos).writeBytes("\r\n\r\n");
            ((DataOutputStream)dos).writeBytes("--END_OF_PART--\r\n");
            ((DataOutputStream)dos).flush();
            dos.close();
            int code = conn.getResponseCode();
            if (code == 201) {
                Document doc = this.docBuilder.parse(conn.getInputStream());
                Element elem = (Element)doc.getDocumentElement().getFirstChild();
                id = elem.getTextContent();
                id = id.substring(id.lastIndexOf(47) + 1);
            }
        }
        catch (IOException | SAXException e) {
            throw new OkapiException("Cannot upload document.", e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return id;
    }

    public void downloadDocument(String docId, File outputFile) {
        try {
            URL url = new URL("https://translate.google.com/toolkit/feeds/documents/export/" + docId);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", this.credentials);
            if (conn.getResponseCode() == 200) {
                String resp = this.readResponse(conn);
                Util.createDirectories(outputFile.getPath());
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
                osw.write(resp);
                osw.close();
            }
        }
        catch (IOException e) {
            throw new OkapiException("Cannot download document.", e);
        }
    }

    public int deleteDocument(String docId, boolean deletePermanently) {
        int code = 0;
        try {
            String tmp = "https://translate.google.com/toolkit/feeds/documents/" + docId;
            if (deletePermanently) {
                tmp = tmp + "?delete=true";
            }
            URL url = new URL(tmp);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("DELETE");
            conn.setRequestProperty("Authorization", this.credentials);
            code = conn.getResponseCode();
        }
        catch (IOException e) {
            throw new OkapiException("Cannot delete document.", e);
        }
        return code;
    }

    public int deleteTM(String tmId) {
        int code = 0;
        try {
            URL url = new URL("https://translate.google.com/toolkit/feeds/tm/" + tmId);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("DELETE");
            conn.setRequestProperty("Authorization", this.credentials);
            code = conn.getResponseCode();
        }
        catch (IOException e) {
            throw new OkapiException("Cannot delete a TM.", e);
        }
        return code;
    }

    private void writeParameters(DataOutputStream dos, String ... args) throws IOException {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                tmp.append("&");
            }
            tmp.append(String.format("%s=%s", args[i], URLEncoder.encode(args[i + 1], "UTF-8")));
            ++i;
        }
        dos.writeBytes(tmp.toString());
    }

    public Object[] getInformation(String resId, LocaleId locId) {
        return null;
    }

    public Object[] getResourceList(LocaleId srcLoc) {
        Object[] res = new Object[3];
        res[0] = null;
        return res;
    }

    private HttpURLConnection createConnection(URL url, String requestType) throws IOException {
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(requestType);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("Authorization", this.credentials);
        return conn;
    }

    private String readResponse(HttpURLConnection conn) throws IOException {
        StringBuilder tmp = new StringBuilder();
        try (InputStreamReader is = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(is);){
            String line;
            while ((line = reader.readLine()) != null) {
                tmp.append(line + "\n");
            }
        }
        return tmp.toString();
    }
}

