/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.virtualdb.jdbc.h2;

import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.virtualdb.IVDocument;
import net.sf.okapi.virtualdb.IVItem;
import net.sf.okapi.virtualdb.IVTextUnit;
import net.sf.okapi.virtualdb.jdbc.h2.H2Access;
import net.sf.okapi.virtualdb.jdbc.h2.H2ItemIterator;
import net.sf.okapi.virtualdb.jdbc.h2.H2Navigator;

public class H2Document
extends H2Navigator
implements IVDocument {
    H2Access db;
    private String id;
    private String name;
    private String type;
    private H2Document selfDoc;

    public H2Document(H2Access access, long key, String id, String name, String type) {
        this.db = access;
        this.key = key;
        this.id = id;
        this.name = name;
        this.type = type;
        this.selfDoc = this;
    }

    @Override
    public void fillPointers(long parent, long firstChild, long previous, long next) {
        this.parent = parent;
        this.firstChild = firstChild;
        this.previous = previous;
        this.next = next;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Ending getEndDocument() {
        throw new UnsupportedOperationException("getEndDocument");
    }

    @Override
    public IVItem getItem(String extractionId) {
        return this.db.getItemFromExtractionId(this, extractionId);
    }

    @Override
    public IVItem getItem(long key) {
        return this.db.getItemFromItemKey(this, key);
    }

    @Override
    public StartDocument getStartDocument() {
        throw new UnsupportedOperationException("getStartDocument");
    }

    @Override
    public IVTextUnit getTextUnit(String extractionId) {
        IVItem item = this.db.getItemFromExtractionId(this, extractionId);
        if (item instanceof IVTextUnit) {
            return (IVTextUnit)item;
        }
        return null;
    }

    @Override
    public IVItem getFirstChild() {
        return this.db.getItemFromItemKey(this, this.firstChild);
    }

    @Override
    public IVItem.ItemType getItemType() {
        return IVItem.ItemType.DOCUMENT;
    }

    @Override
    public Iterable<IVItem> items() {
        return () -> new H2ItemIterator(this.db, this.selfDoc, false);
    }

    @Override
    public Iterable<IVTextUnit> textUnits() {
        return () -> new H2ItemIterator(this.db, this.selfDoc, true);
    }

    @Override
    public IVDocument getDocument() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IVItem getNextSibling() {
        return this.db.getItemFromItemKey(this, this.next);
    }

    @Override
    public IVItem getParent() {
        return null;
    }

    @Override
    public IVItem getPreviousSibling() {
        return this.db.getItemFromItemKey(this, this.previous);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void save() {
    }
}

