/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.segmentation.SRXDocument;

public class Main {
    public static void main(String[] args) {
        try {
            SRXDocument doc = new SRXDocument();
            File f = new File("myRules.srx");
            doc.loadRules(f.getAbsolutePath());
            ISegmenter segmenter = doc.compileLanguageRules(LocaleId.fromString((String)"en"), null);
            int count = segmenter.computeSegments("Part 1. Part 2.");
            System.out.println("count=" + count);
            for (Range range : segmenter.getRanges()) {
                System.out.println(String.format("start=%d, end=%d", range.start, range.end));
            }
            TextFragment tf = new TextFragment();
            tf.append(TextFragment.TagType.OPENING, "span", "<span>");
            tf.append("Part 1.");
            tf.append(TextFragment.TagType.CLOSING, "span", "</span>");
            tf.append(" Part 2.");
            tf.append(TextFragment.TagType.PLACEHOLDER, "alone", "<alone/>");
            tf.append(" Part 3.");
            TextContainer tc = new TextContainer(tf);
            segmenter.computeSegments(tc);
            ISegments segs = tc.getSegments();
            segs.create(segmenter.getRanges());
            for (Segment seg : segs) {
                System.out.println("segment=[" + seg.toString() + "]");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

