/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.mymemory;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final String KEY = "key";
    public static final String USEMT = "useMT";
    public static final String SENDIP = "sendIP";
    private String key;
    private int useMT;
    private boolean sendIP;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getUseMT() {
        return this.useMT;
    }

    public void setUseMT(int useMT) {
        this.useMT = useMT;
    }

    public boolean getSendIP() {
        return this.sendIP;
    }

    public void setSendIP(boolean sendIP) {
        this.sendIP = sendIP;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.key = this.buffer.getEncodedString(KEY, this.key);
        this.useMT = this.buffer.getInteger(USEMT, this.useMT);
        this.sendIP = this.buffer.getBoolean(SENDIP, this.sendIP);
    }

    @Override
    public void reset() {
        this.key = "mmDemo123";
        this.useMT = 1;
        this.sendIP = true;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setEncodedString(KEY, this.key);
        this.buffer.setInteger(USEMT, this.useMT);
        this.buffer.setBoolean(SENDIP, this.sendIP);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(KEY, "Key", "Access key");
        desc.add(USEMT, "Provide also machine translation result", null);
        desc.add(SENDIP, "Send IP address (recommended for large volumes)", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("MyMemory TM Connector Settings");
        desc.addCheckboxPart(paramsDesc.get(USEMT));
        desc.addCheckboxPart(paramsDesc.get(SENDIP));
        return desc;
    }
}

