/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.steps;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.lib.extra.steps.SubfilterLogger;
import net.sf.okapi.lib.extra.steps.TextUnitLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuSsfLogger
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private StringBuilder sb;
    private LocaleId srcLoc;

    @Override
    public String getName() {
        return "Text Unit and Start Group Logger";
    }

    @Override
    public String getDescription() {
        return "Logs Text Unit and Start Group resources going through the pipeline.";
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.sb = new StringBuilder("\n\n");
        return super.handleStartBatch(event);
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = (StartDocument)event.getResource();
        this.srcLoc = sd.getLocale();
        return super.handleStartDocument(event);
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        this.sb.append(TextUnitLogger.getTuInfo(tu, this.srcLoc));
        return super.handleTextUnit(event);
    }

    @Override
    protected Event handleStartSubfilter(Event event) {
        StartSubfilter ssf = event.getStartSubfilter();
        this.sb.append(SubfilterLogger.getSsfInfo(ssf, this.srcLoc));
        return super.handleStartGroup(event);
    }

    @Override
    protected Event handleEndSubfilter(Event event) {
        EndSubfilter esf = event.getEndSubfilter();
        this.sb.append(SubfilterLogger.getEsfInfo(esf, this.srcLoc));
        return super.handleEndSubfilter(event);
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.logger.info(this.sb.toString());
        return super.handleEndBatch(event);
    }
}

