/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.batchtranslation;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.FolderInputPart;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String COMMAND = "command";
    private static final String ORIGIN = "origin";
    private static final String MARKASMT = "markAsMT";
    private static final String MAKETM = "makeTM";
    private static final String TMDIRECTORY = "tmDirectory";
    private static final String MAKETMX = "makeTMX";
    private static final String TMXPATH = "tmxPath";
    private static final String SENDTMX = "sendTMX";
    private static final String BLOCKSIZE = "blockSize";
    private static final String CHECKEXISTINGTM = "checkExistingTm";
    private static final String EXISTINGTM = "existingTm";
    private static final String SEGMENT = "segment";
    private static final String SRXPATH = "srxPath";
    private String command;
    private String origin;
    private boolean markAsMT;
    private boolean makeTM;
    private String tmDirectory;
    private boolean makeTMX;
    private String tmxPath;
    private boolean sendTMX;
    private int blockSize;
    private boolean checkExistingTm;
    private String existingTm;
    private boolean segment;
    private String srxPath;

    public Parameters() {
        this.reset();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean getMarkAsMT() {
        return this.markAsMT;
    }

    public void setMarkAsMT(boolean markAsMT) {
        this.markAsMT = markAsMT;
    }

    public boolean getMakeTMX() {
        return this.makeTMX;
    }

    public void setMakeTMX(boolean makeTMX) {
        this.makeTMX = makeTMX;
    }

    public String getTmxPath() {
        return this.tmxPath;
    }

    public void setTmxPath(String tmxPath) {
        this.tmxPath = tmxPath;
    }

    public boolean getSendTMX() {
        return this.sendTMX;
    }

    public void setSendTMX(boolean sendTMX) {
        this.sendTMX = sendTMX;
    }

    public boolean getMakeTM() {
        return this.makeTM;
    }

    public void setMakeTM(boolean makeTM) {
        this.makeTM = makeTM;
    }

    public String getTmDirectory() {
        return this.tmDirectory;
    }

    public void setTmDirectory(String tmDirectory) {
        this.tmDirectory = tmDirectory;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public boolean getCheckExistingTm() {
        return this.checkExistingTm;
    }

    public void setCheckExistingTm(boolean chekExistingTm) {
        this.checkExistingTm = chekExistingTm;
    }

    public String getExistingTm() {
        return this.existingTm;
    }

    public void setExistingTm(String existingTm) {
        this.existingTm = existingTm;
    }

    public boolean getSegment() {
        return this.segment;
    }

    public void setSegment(boolean segment) {
        this.segment = segment;
    }

    public String getSrxPath() {
        return this.srxPath;
    }

    public void setSrxPath(String srxPath) {
        this.srxPath = srxPath;
    }

    @Override
    public void reset() {
        this.command = "";
        this.origin = "";
        this.markAsMT = true;
        this.makeTM = false;
        this.tmDirectory = "";
        this.makeTMX = false;
        this.tmxPath = "";
        this.sendTMX = false;
        this.blockSize = 1000;
        this.checkExistingTm = false;
        this.existingTm = "";
        this.segment = false;
        this.srxPath = "";
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.command = this.buffer.getString(COMMAND, this.command);
        this.origin = this.buffer.getString(ORIGIN, this.origin);
        this.markAsMT = this.buffer.getBoolean(MARKASMT, this.markAsMT);
        this.makeTM = this.buffer.getBoolean(MAKETM, this.makeTM);
        this.tmDirectory = this.buffer.getString(TMDIRECTORY, this.tmDirectory);
        this.makeTMX = this.buffer.getBoolean(MAKETMX, this.makeTMX);
        this.tmxPath = this.buffer.getString(TMXPATH, this.tmxPath);
        this.sendTMX = this.buffer.getBoolean(SENDTMX, this.sendTMX);
        this.blockSize = this.buffer.getInteger(BLOCKSIZE, this.blockSize);
        this.checkExistingTm = this.buffer.getBoolean(CHECKEXISTINGTM, this.checkExistingTm);
        this.existingTm = this.buffer.getString(EXISTINGTM, this.existingTm);
        this.segment = this.buffer.getBoolean(SEGMENT, this.segment);
        this.srxPath = this.buffer.getString(SRXPATH, this.srxPath);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(COMMAND, this.command);
        this.buffer.setString(ORIGIN, this.origin);
        this.buffer.setBoolean(MARKASMT, this.markAsMT);
        this.buffer.setBoolean(MAKETM, this.makeTM);
        this.buffer.setString(TMDIRECTORY, this.tmDirectory);
        this.buffer.setBoolean(MAKETMX, this.makeTMX);
        this.buffer.setString(TMXPATH, this.tmxPath);
        this.buffer.setBoolean(SENDTMX, this.sendTMX);
        this.buffer.setInteger(BLOCKSIZE, this.blockSize);
        this.buffer.setBoolean(CHECKEXISTINGTM, this.checkExistingTm);
        this.buffer.setString(EXISTINGTM, this.existingTm);
        this.buffer.setBoolean(SEGMENT, this.segment);
        this.buffer.setString(SRXPATH, this.srxPath);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(COMMAND, "Command line", "Command line to execute the batch translation");
        desc.add(ORIGIN, "Origin identifier", "String that identifies the origin of the translation");
        desc.add(BLOCKSIZE, "Block size", "Maximum number of text units to process together");
        desc.add(MARKASMT, "Mark the generated translation as machine translation results", null);
        desc.add(SEGMENT, "Segment the text units, using the following SRX rules:", null);
        desc.add(SRXPATH, "", "Full path of the segmentation rules file to use");
        desc.add(MAKETM, "Import into the following Pensieve TM:", null);
        desc.add(TMDIRECTORY, "", "Location of the TM to create or use");
        desc.add(MAKETMX, "Create the following TMX document:", null);
        desc.add(TMXPATH, "", "Full path of the new TMX document to create");
        desc.add(SENDTMX, "Send the TMX document to the next step", null);
        desc.add(CHECKEXISTINGTM, "Check for existing entries in an existing Pensieve TM:", null);
        desc.add(EXISTINGTM, "", "Location of the TM to lookup");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Batch Translation", true, false);
        desc.addTextInputPart(paramDesc.get(COMMAND));
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(BLOCKSIZE));
        sip.setVertical(false);
        sip.setRange(1, Integer.MAX_VALUE);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(ORIGIN));
        tip.setAllowEmpty(true);
        tip.setVertical(false);
        desc.addCheckboxPart(paramDesc.get(MARKASMT));
        desc.addSeparatorPart();
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(SEGMENT));
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(SRXPATH), "SRX Path", false);
        pip.setBrowseFilters("SRX Documents (*.srx)\tAll Files (*.*)", "*.srx\t*.*");
        pip.setMasterPart(cbp, true);
        pip.setWithLabel(false);
        cbp = desc.addCheckboxPart(paramDesc.get(MAKETM));
        FolderInputPart fip = desc.addFolderInputPart(paramDesc.get(TMDIRECTORY), "TM Directory");
        fip.setMasterPart(cbp, true);
        fip.setWithLabel(false);
        cbp = desc.addCheckboxPart(paramDesc.get(MAKETMX));
        pip = desc.addPathInputPart(paramDesc.get(TMXPATH), "TMX Path", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setMasterPart(cbp, true);
        pip.setWithLabel(false);
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(SENDTMX));
        cbp2.setMasterPart(cbp, true);
        cbp = desc.addCheckboxPart(paramDesc.get(CHECKEXISTINGTM));
        fip = desc.addFolderInputPart(paramDesc.get(EXISTINGTM), "TM Directory");
        fip.setMasterPart(cbp, true);
        fip.setWithLabel(false);
        return desc;
    }
}

