/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;

@UsingParameters
public class RawDocumentWriterStep
extends BasePipelineStep {
    private URI outputURI;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @Override
    public String getDescription() {
        return "Write a RawDocument to an output file.";
    }

    @Override
    public String getName() {
        return "RawDocument Writer";
    }

    @Override
    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = (RawDocument)event.getResource();
        try {
            File outFile;
            rawDoc = (RawDocument)event.getResource();
            if (this.isLastOutputStep()) {
                outFile = new File(this.outputURI);
                Util.createDirectories(outFile.getAbsolutePath());
            } else {
                try {
                    outFile = File.createTempFile("okp-rdw_", ".tmp");
                }
                catch (Throwable e) {
                    throw new OkapiIOException("Cannot create temporary output.", e);
                }
                outFile.deleteOnExit();
            }
            Util.copy(rawDoc.getStream(), outFile);
            event.setResource(new RawDocument(outFile.toURI(), rawDoc.getEncoding(), rawDoc.getSourceLocale(), rawDoc.getTargetLocale()));
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error writing or copying a RawDocument.", e);
        }
        return event;
    }
}

