/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.diffleverage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.extra.diff.incava.DiffLists;
import net.sf.okapi.lib.search.lucene.analysis.AlphabeticNgramTokenizer;
import net.sf.okapi.lib.search.lucene.scorer.Util;
import net.sf.okapi.steps.diffleverage.DiffMatchAnnotation;
import net.sf.okapi.steps.diffleverage.FuzzyTextUnitComparator;
import net.sf.okapi.steps.diffleverage.Parameters;
import net.sf.okapi.steps.diffleverage.TextUnitComparator;

@UsingParameters(value=Parameters.class)
public class DiffLeverageStep
extends BasePipelineStep {
    private static final int NGRAM_SIZE = 3;
    private Parameters params = new Parameters();
    private IFilterConfigurationMapper fcMapper;
    private RawDocument oldSource;
    private RawDocument oldTarget;
    private List<ITextUnit> newTextUnits;
    private List<ITextUnit> oldTextUnits;
    private List<Event> newDocumentEvents;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private boolean done = true;
    private Comparator<ITextUnit> sourceComparator;
    private AlphabeticNgramTokenizer tokenizer;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.oldSource = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.THIRD_INPUT_RAWDOC)
    public void setTertiaryInput(RawDocument tertiaryInput) {
        this.oldTarget = tertiaryInput;
    }

    @Override
    public String getDescription() {
        return "Compare two source documents (i.e., different versions) and copy the old target content when we find a match. Can be a monolingual and bi-lingual input or three monolingual inputs. Paragraphs (TextUnits) must align in all cases";
    }

    @Override
    public String getName() {
        return "Diff Leverage";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.done = true;
        if (this.params.getFuzzyThreshold() >= 100) {
            this.sourceComparator = new TextUnitComparator(this.params.isCodesensitive());
        } else {
            this.tokenizer = Util.createNgramTokenizer(3, this.sourceLocale);
            this.sourceComparator = new FuzzyTextUnitComparator(this.params.isCodesensitive(), this.params.getFuzzyThreshold(), this.sourceLocale);
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        throw new OkapiBadStepInputException("Encountered a RAW_DOCUMENT event. Expected a filtered event stream.");
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.oldSource != null) {
            this.done = false;
            this.newTextUnits = new ArrayList<ITextUnit>();
            this.oldTextUnits = new ArrayList<ITextUnit>();
            this.newDocumentEvents = new LinkedList<Event>();
            this.getOldDocumentTextUnits();
        }
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        this.done = true;
        if (this.oldSource != null) {
            this.diffLeverage();
            this.newDocumentEvents.add(event);
            Event multi_event = new Event(EventType.MULTI_EVENT, new MultiEvent(this.newDocumentEvents));
            this.newTextUnits = null;
            this.oldTextUnits = null;
            this.newDocumentEvents = null;
            return multi_event;
        }
        return event;
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        if (this.oldSource != null) {
            this.newDocumentEvents.add(event);
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    protected Event handleEndSubDocument(Event event) {
        if (this.oldSource != null) {
            this.newDocumentEvents.add(event);
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    protected Event handleStartGroup(Event event) {
        if (this.oldSource != null) {
            this.newDocumentEvents.add(event);
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    protected Event handleEndGroup(Event event) {
        if (this.oldSource != null) {
            this.newDocumentEvents.add(event);
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        if (event.getTextUnit().getSource().hasBeenSegmented()) {
            throw new OkapiBadStepInputException("DiffLeverageStep only aligns unsegmented TextUnits");
        }
        if (this.oldSource != null) {
            this.newTextUnits.add(event.getTextUnit());
            this.newDocumentEvents.add(event);
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    protected Event handleDocumentPart(Event event) {
        if (this.oldSource != null) {
            this.newDocumentEvents.add(event);
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getOldDocumentTextUnits() {
        IFilter srcFilter = null;
        IFilter trgFilter = null;
        try {
            if (this.oldTarget != null) {
                trgFilter = this.fcMapper.createFilter(this.oldSource.getFilterConfigId(), null);
                trgFilter.open(this.oldTarget);
            }
            srcFilter = this.fcMapper.createFilter(this.oldSource.getFilterConfigId(), null);
            srcFilter.open(this.oldSource);
            while (srcFilter.hasNext()) {
                Event event = srcFilter.next();
                if (event.getEventType() != EventType.TEXT_UNIT) continue;
                ITextUnit tu = event.getTextUnit();
                if (this.oldTarget != null) {
                    Event e = this.synchronize(trgFilter, EventType.TEXT_UNIT);
                    tu.setTarget(this.targetLocale, e.getTextUnit().getSource());
                }
                this.oldTextUnits.add(tu);
            }
        }
        finally {
            if (srcFilter != null) {
                srcFilter.close();
            }
            if (trgFilter != null) {
                trgFilter.close();
            }
        }
    }

    private Event synchronize(IFilter filter, EventType untilType) {
        boolean found = false;
        Event event = null;
        while (!found && filter.hasNext()) {
            event = filter.next();
            boolean bl = found = event.getEventType() == untilType;
            if (!event.isTextUnit() || !event.getTextUnit().getSource().hasBeenSegmented()) continue;
            throw new OkapiBadStepInputException("DiffLeverageStep only aligns unsegmented TextUnits");
        }
        if (!found) {
            throw new RuntimeException("Different number of source or target TextUnits. The source and target documents are not paragraph aligned.");
        }
        return event;
    }

    private void diffLeverage() {
        DiffLists<ITextUnit> diffTextUnits = new DiffLists<ITextUnit>(this.oldTextUnits, this.newTextUnits, this.sourceComparator);
        diffTextUnits.diff();
        for (Map.Entry<Integer, Integer> m : diffTextUnits.getMatches().entrySet()) {
            ITextUnit oldTu = this.oldTextUnits.get(m.getKey());
            ITextUnit newTu = this.newTextUnits.get(m.getValue());
            int score = 100;
            TextContainer otc = null;
            otc = oldTu.getTarget(this.targetLocale);
            if (otc == null) continue;
            if (!this.params.isDiffOnly()) {
                if (this.params.getFuzzyThreshold() < 100) {
                    score = (int)Util.calculateNgramDiceCoefficient(oldTu.getSource().getFirstContent().toString(), newTu.getSource().getFirstContent().toString(), this.tokenizer);
                }
                newTu.getSource().getFirstContent().alignCodeIds(otc.getFirstContent());
                TextFragment atf = TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(newTu.getSource().getFirstContent(), otc.getFirstContent(), true, false, null, newTu);
                otc.setContent(atf);
                if (this.params.isCopyToTarget()) {
                    newTu.setTarget(this.targetLocale, otc);
                }
                AltTranslation alt = new AltTranslation(this.sourceLocale, this.targetLocale, newTu.getSource().getUnSegmentedContentCopy(), oldTu.getSource().getUnSegmentedContentCopy(), otc.getUnSegmentedContentCopy(), this.params.getFuzzyThreshold() >= 100 ? MatchType.EXACT_PREVIOUS_VERSION : MatchType.FUZZY_PREVIOUS_VERSION, score, this.getName());
                TextContainer ntc = newTu.createTarget(this.targetLocale, false, 2);
                AltTranslationsAnnotation alta = TextUnitUtil.addAltTranslation(ntc, alt);
                alta.sort();
            }
            TextContainer tc = newTu.createTarget(this.targetLocale, false, 2);
            tc.setAnnotation(new DiffMatchAnnotation());
        }
    }
}

