/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized.gmx;

import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.steps.wordcount.categorized.CategoryGroup;
import net.sf.okapi.steps.wordcount.categorized.CategoryHandler;
import net.sf.okapi.steps.wordcount.common.AltAnnotationBasedCountStep;

public class GMXFuzzyMatchWordCountStep
extends AltAnnotationBasedCountStep
implements CategoryHandler {
    public static final String METRIC = "FuzzyMatchedWordCount";

    @Override
    public String getMetric() {
        return METRIC;
    }

    @Override
    public String getDescription() {
        return "An accumulation of the word count for text units that have been fuzzy matched against a leveraged translation memory database. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Fuzzy Match Word Count";
    }

    @Override
    protected boolean accept(MatchType type) {
        return type == MatchType.EXACT_TEXT_ONLY_UNIQUE_ID || type == MatchType.EXACT_TEXT_ONLY_PREVIOUS_VERSION || type == MatchType.EXACT_TEXT_ONLY || type == MatchType.EXACT_REPAIRED || type == MatchType.FUZZY_UNIQUE_ID || type == MatchType.FUZZY_PREVIOUS_VERSION || type == MatchType.FUZZY || type == MatchType.FUZZY_REPAIRED;
    }

    @Override
    public CategoryGroup getCategoryGroup() {
        return CategoryGroup.GMX_WORD_COUNTS;
    }
}

