/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class TextOptions {
    public Font font;
    public Color foreground;
    public Color background;
    public boolean isBidirectional;
    private static final String SEPARATOR = "\t";

    public TextOptions(Device device, String info) {
        try {
            String[] parts = info.split(SEPARATOR);
            FontData fd = new FontData(parts[0]);
            this.font = new Font(device, fd);
            this.isBidirectional = parts[1].charAt(0) == '1';
            String[] values = parts[2].split(",");
            this.foreground = new Color(device, Integer.valueOf(values[0]), Integer.valueOf(values[1]), Integer.valueOf(values[2]));
            values = parts[3].split(",");
            this.background = new Color(device, Integer.valueOf(values[0]), Integer.valueOf(values[1]), Integer.valueOf(values[2]));
        }
        catch (Throwable e) {
            throw new RuntimeException("Error creation text options from string.");
        }
    }

    public TextOptions(Device device, StyledText control, int sizeIncrease) {
        Font tmp = control.getFont();
        FontData[] fontData = tmp.getFontData();
        fontData[0].setHeight(fontData[0].getHeight() + sizeIncrease);
        this.font = new Font(device, fontData[0]);
        this.isBidirectional = control.getOrientation() == 0x4000000;
        this.foreground = new Color(device, control.getForeground().getRGB());
        this.background = new Color(device, control.getBackground().getRGB());
    }

    public TextOptions(Device device, TextOptions options) {
        this.font = new Font(device, options.font.getFontData());
        this.isBidirectional = options.isBidirectional;
        this.foreground = new Color(device, options.foreground.getRGB());
        this.background = new Color(device, options.background.getRGB());
    }

    protected void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.foreground != null) {
            this.foreground.dispose();
        }
        if (this.background != null) {
            this.background.dispose();
        }
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        FontData[] data = this.font.getFontData();
        tmp.append(data[0].toString());
        tmp.append(SEPARATOR);
        tmp.append(this.isBidirectional ? "1" : "0");
        tmp.append(SEPARATOR);
        RGB rgb = this.foreground.getRGB();
        tmp.append(String.format("%d,%d,%d", rgb.red, rgb.green, rgb.blue));
        tmp.append(SEPARATOR);
        rgb = this.background.getRGB();
        tmp.append(String.format("%d,%d,%d", rgb.red, rgb.green, rgb.blue));
        return tmp.toString();
    }

    public void applyTo(StyledText control) {
        control.setBackground(this.background);
        control.setForeground(this.foreground);
        control.setFont(this.font);
        control.setOrientation(this.isBidirectional ? 0x4000000 : 0x2000000);
    }
}

