/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UIUtil {
    public static final int BUTTON_DEFAULT_WIDTH = 80;
    public static final int PFTYPE_WIN = 0;
    public static final int PFTYPE_MAC = 1;
    public static final int PFTYPE_UNIX = 2;

    public static void start(String command) {
        Program.launch(command);
    }

    public static void execute(String program, String parameter) {
        try {
            Runtime rt = Runtime.getRuntime();
            String[] command = new String[]{program, parameter};
            rt.exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getPlatformType() {
        if ("win32".equals(SWT.getPlatform())) {
            return 0;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            return 2;
        }
        if ("cocoa".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform())) {
            return 1;
        }
        if ("motif".equals(SWT.getPlatform())) {
            return 2;
        }
        return -1;
    }

    public static Button createGridButton(Composite parent, int style, String label, int width, int horizontalSpan) {
        Button newButton = new Button(parent, style);
        newButton.setText(label);
        GridData gdTmp = new GridData();
        if (horizontalSpan > 0) {
            gdTmp.horizontalSpan = horizontalSpan;
        }
        newButton.setLayoutData(gdTmp);
        if (width > -1) {
            UIUtil.ensureWidth(newButton, width);
        }
        return newButton;
    }

    public static void inheritIcon(Shell dialog, Shell parent) {
        if (parent == null) {
            return;
        }
        Image[] list = parent.getImages();
        if (list == null || list.length < 2) {
            dialog.setImage(parent.getImage());
        } else {
            dialog.setImages(list);
        }
    }

    public static Rectangle StringToRectangle(String data) {
        try {
            if (data == null) {
                return null;
            }
            String[] parts = data.split("[,; ]");
            if (parts.length != 4) {
                return null;
            }
            int x = Integer.valueOf(parts[0]);
            int y = Integer.valueOf(parts[1]);
            int w = Integer.valueOf(parts[2]);
            int h = Integer.valueOf(parts[3]);
            return new Rectangle(x, y, w, h);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void ensureWidth(Control control, int minimumWidth) {
        control.pack();
        Rectangle rect = control.getBounds();
        if (rect.width < minimumWidth) {
            GridData gd = (GridData)control.getLayoutData();
            if (gd == null) {
                gd = new GridData();
                control.setLayoutData(gd);
            }
            gd.widthHint = minimumWidth;
        }
    }

    public static void checkProjectFolderAfterPick(String path, Text edField, String projectDir) {
        if (path == null) {
            return;
        }
        edField.setText(path);
        edField.selectAll();
        edField.setFocus();
    }

    public static int getMinimumWidth(int minimumWidth, Button button, String alternateText) {
        int n = minimumWidth;
        button.pack();
        Point size = button.getSize();
        if (size.x > n) {
            n = size.x;
        }
        String tmp = button.getText();
        button.setText(alternateText);
        button.pack();
        size = button.getSize();
        if (size.x > n) {
            n = size.x;
        }
        button.setText(tmp);
        return n;
    }

    public static void setSameWidth(int minimumWidth, Control ... controls) {
        int min = minimumWidth;
        for (Control control : controls) {
            control.pack();
            Rectangle rect = control.getBounds();
            if (rect.width <= min) continue;
            min = rect.width;
        }
        for (Control control : controls) {
            GridData gdTmp = (GridData)control.getLayoutData();
            if (gdTmp == null) {
                gdTmp = new GridData();
                control.setLayoutData(gdTmp);
            }
            gdTmp.widthHint = min;
        }
    }

    public static void disposeTextStyle(TextStyle ts) {
        if (ts != null) {
            if (ts.background != null) {
                ts.background.dispose();
            }
            if (ts.foreground != null) {
                ts.foreground.dispose();
            }
            if (ts.font != null) {
                ts.font.dispose();
            }
        }
    }

    public static TextStyle cloneTextStyle(Device device, TextStyle ts) {
        if (ts == null) {
            return null;
        }
        TextStyle newTS = new TextStyle(ts);
        if (ts.background != null) {
            newTS.background = new Color(device, ts.background.getRGB());
        }
        if (ts.foreground != null) {
            newTS.foreground = new Color(device, ts.foreground.getRGB());
        }
        if (ts.font != null) {
            newTS.font = new Font(device, ts.font.getFontData());
        }
        return newTS;
    }

    public static void centerShell(Shell shell) {
        if (shell == null) {
            return;
        }
        Rectangle ar = shell.getBounds();
        Rectangle dr = shell.getDisplay().getBounds();
        if (ar.width > dr.width) {
            ar.width = dr.width;
        }
        if (ar.height > dr.height) {
            ar.height = dr.height;
        }
        shell.setBounds((dr.width - ar.width) / 2, (dr.height - ar.height) / 2, ar.width, ar.height);
    }
}

