/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.applications.rainbow.lib.LanguageItem;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LanguageManager {
    private Vector<LanguageItem> langs = new Vector();

    public void loadList(String p_sPath) {
        try {
            DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
            Fact.setValidating(false);
            Document Doc = Fact.newDocumentBuilder().parse(new File(p_sPath));
            NodeList NL = Doc.getElementsByTagName("language");
            this.langs.clear();
            for (int i = 0; i < NL.getLength(); ++i) {
                Node N = NL.item(i).getAttributes().getNamedItem("code");
                if (N == null) {
                    throw new RuntimeException("The attribute 'code' is missing.");
                }
                LanguageItem LI = new LanguageItem();
                LI.code = Util.getTextContent(N).toUpperCase();
                N = NL.item(i).getAttributes().getNamedItem("lcid");
                LI.lcid = N == null ? -1 : Integer.valueOf(Util.getTextContent(N));
                N = NL.item(i).getAttributes().getNamedItem("encoding");
                if (N == null) {
                    LI.setEncoding("UTF-8", Util.SUPPORTED_OS.WINDOWS);
                } else {
                    LI.setEncoding(Util.getTextContent(N), Util.SUPPORTED_OS.WINDOWS);
                }
                N = NL.item(i).getAttributes().getNamedItem("macEncoding");
                if (N != null) {
                    LI.setEncoding(Util.getTextContent(N), Util.SUPPORTED_OS.MAC);
                }
                if ((N = NL.item(i).getAttributes().getNamedItem("unixEncoding")) != null) {
                    LI.setEncoding(Util.getTextContent(N), Util.SUPPORTED_OS.LINUX);
                }
                for (N = NL.item(i).getFirstChild(); N != null; N = N.getNextSibling()) {
                    if (N.getNodeType() != 1 || !N.getNodeName().equals("name")) continue;
                    LI.name = Util.getTextContent(N);
                    break;
                }
                if (LI.name == null) {
                    throw new RuntimeException("The element 'name' is missing.");
                }
                this.langs.add(LI);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getCount() {
        return this.langs.size();
    }

    public LanguageItem getItem(int p_nIndex) {
        return this.langs.get(p_nIndex);
    }

    public LanguageItem GetItem(String p_sCode) {
        for (int i = 0; i < this.langs.size(); ++i) {
            if (!p_sCode.equalsIgnoreCase(this.langs.get((int)i).code)) continue;
            return this.langs.get(i);
        }
        return null;
    }

    public int GetLCID(int p_nIndex) {
        return this.langs.get((int)p_nIndex).lcid;
    }

    public String GetNameFromCode(String p_sCode) {
        for (int i = 0; i < this.langs.size(); ++i) {
            if (!p_sCode.equalsIgnoreCase(this.langs.get((int)i).code)) continue;
            return this.langs.get((int)i).name;
        }
        return p_sCode;
    }

    public int getIndexFromCode(String p_sCode) {
        if (p_sCode == null) {
            return -1;
        }
        for (int i = 0; i < this.langs.size(); ++i) {
            if (!p_sCode.equalsIgnoreCase(this.langs.get((int)i).code)) continue;
            return i;
        }
        return -1;
    }

    public String getDefaultEncodingFromCode(LocaleId language, Util.SUPPORTED_OS osType) {
        LanguageItem LI = this.GetItem(language.toString());
        if (LI == null) {
            return "UTF-8";
        }
        return LI.getEncoding(osType);
    }
}

