/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.packages.xliff;

import net.sf.okapi.applications.rainbow.packages.xliff.Options;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OptionsEditor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private Button chkGMode;
    private Button chkIncludeNoTranslate;
    private Button chkSetApprovedAsNoTranslate;
    private Button chkCopySource;
    private Button chkIncludeAltTrans;
    private Options params;
    private IHelp help;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Options)params;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    @Override
    public IParameters createParameters() {
        return new Options();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("XLIFF Package Options");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        Composite cmpTmp = new Composite((Composite)this.shell, 2048);
        cmpTmp.setLayoutData((Object)new GridData(1808));
        cmpTmp.setLayout((Layout)new GridLayout());
        this.chkIncludeNoTranslate = new Button(cmpTmp, 32);
        this.chkIncludeNoTranslate.setText("Include non-translatable text units");
        this.chkIncludeNoTranslate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsEditor.this.updateNoTranslateCases();
            }
        });
        this.chkSetApprovedAsNoTranslate = new Button(cmpTmp, 32);
        this.chkSetApprovedAsNoTranslate.setText("Set approved entries as non-translatable");
        GridData gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.chkSetApprovedAsNoTranslate.setLayoutData((Object)gdTmp);
        this.chkSetApprovedAsNoTranslate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsEditor.this.updateNoTranslateCases();
            }
        });
        this.chkGMode = new Button(cmpTmp, 32);
        this.chkGMode.setText("Use <g></g> and <x/> notation");
        this.chkCopySource = new Button(cmpTmp, 32);
        this.chkCopySource.setText("Copy source text in target if no target is available");
        this.chkIncludeAltTrans = new Button(cmpTmp, 32);
        this.chkIncludeAltTrans.setText("Include <alt-trans> elements");
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (OptionsEditor.this.help != null) {
                        OptionsEditor.this.help.showWiki("Rainbow - XLIFF Package Options");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!OptionsEditor.this.saveData()) {
                        return;
                    }
                    OptionsEditor.this.result = true;
                }
                OptionsEditor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        pnlActions.setLayoutData(gdTmp);
        pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 300) {
            startSize.x = 300;
        }
        if (startSize.y < 200) {
            startSize.y = 200;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkGMode.setSelection(this.params.gMode);
        this.chkIncludeNoTranslate.setSelection(this.params.includeNoTranslate);
        this.chkSetApprovedAsNoTranslate.setSelection(this.params.setApprovedAsNoTranslate);
        this.chkCopySource.setSelection(this.params.copySource);
        this.chkIncludeAltTrans.setSelection(this.params.includeAltTrans);
        this.updateNoTranslateCases();
    }

    private boolean saveData() {
        this.params.gMode = this.chkGMode.getSelection();
        this.params.includeNoTranslate = this.chkIncludeNoTranslate.getSelection();
        this.params.setApprovedAsNoTranslate = this.chkSetApprovedAsNoTranslate.getSelection();
        this.params.copySource = this.chkCopySource.getSelection();
        this.params.includeAltTrans = this.chkIncludeAltTrans.getSelection();
        return true;
    }

    private void updateNoTranslateCases() {
        if (!this.chkIncludeNoTranslate.getSelection()) {
            this.chkSetApprovedAsNoTranslate.setSelection(false);
        }
        this.chkSetApprovedAsNoTranslate.setEnabled(this.chkIncludeNoTranslate.getSelection());
    }
}

