/*
 * Decompiled with CFR 0.152.
 */
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.connectors.apertium.ApertiumMTConnector;
import net.sf.okapi.connectors.opentran.OpenTranTMConnector;

public class Main {
    public static void main(String[] args) {
        try {
            QueryResult res;
            System.out.println("------------------------------------------------------------");
            System.out.println("Accessing Apertium resources");
            ApertiumMTConnector mtConnector = new ApertiumMTConnector();
            mtConnector.setLanguages(LocaleId.fromString((String)"en"), LocaleId.fromString((String)"eo"));
            mtConnector.open();
            System.out.println("Apertium MT Service:");
            System.out.println(mtConnector.getSettingsDisplay());
            mtConnector.query("Open the file");
            if (mtConnector.hasNext()) {
                res = mtConnector.next();
                System.out.println("   Original: " + res.source.toText());
                System.out.println("Translation: " + res.target.toText());
            }
            System.out.println("------------------------------------------------------------");
            System.out.println("Accessing OpenTran resources");
            System.out.println("Note that the public OpenTran server is sometimes blocked");
            System.out.println("or down, so this example may not run properly.");
            OpenTranTMConnector connector = new OpenTranTMConnector();
            connector.setLanguages(LocaleId.fromString((String)"en"), LocaleId.fromString((String)"fr"));
            connector.open();
            String query = "Open the file";
            connector.query(query);
            System.out.println(String.format("OpenTran-TM results for \"%s\":", query));
            while (connector.hasNext()) {
                res = connector.next();
                System.out.println("- Source: " + res.source.toText());
                System.out.println("  Target: " + res.target.toText());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

