/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import net.sf.okapi.common.ReaderInputStream;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;

public final class MemMappedCharSequence
implements CharSequence {
    private CharBuffer text;
    private MappedByteBuffer byteBuffer;
    private File tempUTF16BEfile;
    public static final int NO_BREAK = -1;

    public MemMappedCharSequence(String string, boolean lowercase) {
        this.text = CharBuffer.wrap(string, 0, string.length());
        if (lowercase) {
            this.toLowercase();
        }
    }

    public MemMappedCharSequence(String string) {
        this(string, false);
    }

    public MemMappedCharSequence(Reader inputSource) {
        this(inputSource, false);
    }

    public MemMappedCharSequence(Reader inputSource, boolean lowercase) {
        try {
            this.createMemMappedCharBuffer(Channels.newChannel(new ReaderInputStream(inputSource, "UTF-16BE")), "UTF-16BE", lowercase);
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException("UTF-16BE encoding not supported", e);
        }
    }

    public MemMappedCharSequence(InputStream inputSource, String encoding) {
        this(inputSource, encoding, false);
    }

    public MemMappedCharSequence(InputStream inputSource, String encoding, boolean lowercase) {
        this.createMemMappedCharBuffer(Channels.newChannel(inputSource), encoding, lowercase);
    }

    public MemMappedCharSequence(URL inputSource, String encoding) {
        this(inputSource, encoding, false);
    }

    public MemMappedCharSequence(URL inputSource, String encoding, boolean lowercase) {
        try {
            this.createMemMappedCharBuffer(Channels.newChannel(inputSource.openStream()), encoding, lowercase);
        }
        catch (IOException e) {
            throw new OkapiIOException("Cannot open URL stream: " + inputSource.toString(), e);
        }
    }

    private void createMemMappedCharBuffer(ReadableByteChannel inputSource, String encoding, boolean lowercase) {
        this.text = null;
        AbstractInterruptibleChannel fc = null;
        this.tempUTF16BEfile = null;
        try {
            this.tempUTF16BEfile = File.createTempFile("memmap", ".tmp");
            BufferedWriter tempOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempUTF16BEfile), "UTF-16BE"));
            MemMappedCharSequence.decodeChannel(inputSource, tempOut, Charset.forName(encoding));
            tempOut.close();
            String mode = "r";
            FileChannel.MapMode mapMode = FileChannel.MapMode.READ_ONLY;
            if (lowercase) {
                mode = "rw";
                mapMode = FileChannel.MapMode.PRIVATE;
            }
            fc = new RandomAccessFile(this.tempUTF16BEfile, mode).getChannel();
            this.byteBuffer = ((FileChannel)fc).map(mapMode, 0L, ((FileChannel)fc).size());
            this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
            this.text = this.byteBuffer.asCharBuffer();
            if (lowercase) {
                this.toLowercase();
            }
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException("Cannot create memory mapped file", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Cannot create memory mapped file", e);
        }
        finally {
            if (this.tempUTF16BEfile != null) {
                this.tempUTF16BEfile.deleteOnExit();
            }
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public boolean containsAt(String str, int pos) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == this.text.get(pos + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public char charAt(int index) {
        return this.text.get(index);
    }

    public int indexOf(char searchChar, int fromIndex) {
        return this.indexOf(searchChar, fromIndex, -1);
    }

    public int indexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int i;
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > this.text.length() ? this.text.length() : breakAtIndex;
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (i < actualBreakAtIndex) {
            if (this.text.get(i) == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(char searchChar, int fromIndex) {
        return this.lastIndexOf(searchChar, fromIndex, -1);
    }

    public int lastIndexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int i;
        int n = i = fromIndex > this.text.length() ? this.text.length() : fromIndex;
        while (i > breakAtIndex) {
            if (this.text.get(i) == searchChar) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int indexOf(String searchString, int fromIndex) {
        return searchString.length() == 1 ? this.indexOf(searchString.charAt(0), fromIndex, -1) : this.indexOf(searchString.toCharArray(), fromIndex, -1);
    }

    public int indexOf(char[] searchCharArray, int fromIndex) {
        return this.indexOf(searchCharArray, fromIndex, -1);
    }

    public int indexOf(String searchString, int fromIndex, int breakAtIndex) {
        return searchString.length() == 1 ? this.indexOf(searchString.charAt(0), fromIndex, breakAtIndex) : this.indexOf(searchString.toCharArray(), fromIndex, breakAtIndex);
    }

    public int indexOf(char[] searchCharArray, int fromIndex, int breakAtIndex) {
        int i;
        if (searchCharArray.length == 0) {
            return fromIndex;
        }
        char firstChar = searchCharArray[0];
        int lastPossibleBreakAtIndex = this.text.length() - searchCharArray.length + 1;
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > lastPossibleBreakAtIndex ? lastPossibleBreakAtIndex : breakAtIndex;
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (i < actualBreakAtIndex) {
            block5: {
                if (this.text.get(i) == firstChar) {
                    for (int j = 1; j < searchCharArray.length; ++j) {
                        if (searchCharArray[j] == this.text.get(j + i)) {
                            continue;
                        }
                        break block5;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(String searchString, int fromIndex) {
        return searchString.length() == 1 ? this.lastIndexOf(searchString.charAt(0), fromIndex, -1) : this.lastIndexOf(searchString.toCharArray(), fromIndex, -1);
    }

    public int lastIndexOf(char[] searchCharArray, int fromIndex) {
        return this.lastIndexOf(searchCharArray, fromIndex, -1);
    }

    public int lastIndexOf(String searchString, int fromIndex, int breakAtIndex) {
        return searchString.length() == 1 ? this.lastIndexOf(searchString.charAt(0), fromIndex, breakAtIndex) : this.lastIndexOf(searchString.toCharArray(), fromIndex, breakAtIndex);
    }

    public int lastIndexOf(char[] searchCharArray, int fromIndex, int breakAtIndex) {
        if (searchCharArray.length == 0) {
            return fromIndex;
        }
        int rightIndex = this.text.length() - searchCharArray.length;
        if (breakAtIndex > rightIndex) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        int lastCharIndex = searchCharArray.length - 1;
        char lastChar = searchCharArray[lastCharIndex];
        int actualBreakAtPos = breakAtIndex + lastCharIndex;
        block0: for (int i = fromIndex + lastCharIndex; i > actualBreakAtPos; --i) {
            if (this.text.get(i) != lastChar) continue;
            int startIndex = i - lastCharIndex;
            for (int j = lastCharIndex - 1; j >= 0; --j) {
                if (searchCharArray[j] != this.text.get(j + startIndex)) continue block0;
            }
            return startIndex;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.text.length();
    }

    public String substring(int beginIndex, int endIndex) {
        return this.text.subSequence(beginIndex, endIndex).toString();
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    @Override
    public String toString() {
        this.text.rewind();
        return this.text.toString();
    }

    public void toLowercase() {
        this.text.rewind();
        for (int i = 0; i < this.text.length(); ++i) {
            this.text.put(i, Character.toLowerCase(this.text.get(i)));
        }
    }

    public char[] array() {
        return this.text.array();
    }

    public static void decodeChannel(ReadableByteChannel source, Writer writer, Charset charset) throws UnsupportedCharsetException, IOException {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer bb = ByteBuffer.allocateDirect(16384);
        CharBuffer cb = CharBuffer.allocate(57);
        CoderResult result = CoderResult.UNDERFLOW;
        boolean eof = false;
        while (!eof) {
            if (result == CoderResult.UNDERFLOW) {
                bb.clear();
                eof = source.read(bb) == -1;
                bb.flip();
            }
            if ((result = decoder.decode(bb, cb, eof)).isError()) {
                throw new RuntimeException("Cannot map byte to char using charset: " + charset.displayName());
            }
            if (result != CoderResult.OVERFLOW) continue;
            MemMappedCharSequence.drainCharBuf(cb, writer);
        }
        while (decoder.flush(cb) == CoderResult.OVERFLOW) {
            MemMappedCharSequence.drainCharBuf(cb, writer);
        }
        MemMappedCharSequence.drainCharBuf(cb, writer);
        writer.flush();
    }

    private static void drainCharBuf(CharBuffer cb, Writer writer) throws IOException {
        cb.flip();
        if (cb.hasRemaining()) {
            writer.write(cb.toString());
        }
        cb.clear();
    }

    public void close() {
        if (this.byteBuffer == null) {
            return;
        }
        this.tempUTF16BEfile.delete();
    }
}

