/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.XMLEncoder;

public class TSEncoder
extends XMLEncoder {
    @Override
    public String encode(String text, EncoderContext context) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff') {
                escaped.append(super.encode(ch, context));
                continue;
            }
            escaped.append("<byte value=\"x" + Integer.toHexString(ch) + "\">");
        }
        return escaped.toString();
    }

    @Override
    public String toNative(String propertyName, String value) {
        if (propertyName.equals("approved")) {
            if (value != null && value.equals("yes")) {
                return "";
            }
            return " type=\"unfinished\"";
        }
        return value;
    }
}

