/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.copyormove;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.steps.copyormove.Parameters;

public class CopyOrMoveStep
extends BasePipelineStep {
    private Parameters params;
    private URI outputURI;

    public CopyOrMoveStep() {
        this.reset();
    }

    @Override
    public String getName() {
        return "Copy Or Move";
    }

    @Override
    public String getDescription() {
        return "Copies or moves the listed files to the specified location. Expects: raw documents. Sends back: raw documents.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @Override
    public Event handleRawDocument(Event event) {
        File file = new File(event.getRawDocument().getInputURI());
        File output = new File(this.outputURI);
        if (this.params.getCopyOption().equals("overwrite")) {
            Util.copyFile(file.getPath(), output.getPath(), this.params.isMove());
        } else if (this.params.getCopyOption().equals("backup")) {
            if (output.exists() && !output.renameTo(new File(this.outputURI.toString() + ".bak"))) {
                Util.copyFile(output.getPath(), output.getPath().replace(".txt", ".txt.bak"), true);
            }
            Util.copyFile(file.getPath(), output.getPath(), this.params.isMove());
        } else if (!output.exists()) {
            Util.copyFile(file.getPath(), output.getPath(), this.params.isMove());
        }
        return event;
    }

    private void reset() {
        this.params = new Parameters();
    }
}

