/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.alignment;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.applications.rainbow.utilities.BaseFilterDrivenUtility;
import net.sf.okapi.applications.rainbow.utilities.alignment.Aligner;
import net.sf.okapi.applications.rainbow.utilities.alignment.DbStore;
import net.sf.okapi.applications.rainbow.utilities.alignment.DbStoreBuilder;
import net.sf.okapi.applications.rainbow.utilities.alignment.Parameters;
import net.sf.okapi.common.ConfigurationString;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.tm.simpletm.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility
extends BaseFilterDrivenUtility {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private String fileName;
    private DbStoreBuilder dbStoreBuilder;
    private DbStore dbStore;
    private TMXWriter tmxWriter = null;
    private TMXWriter tmxWriterForUnknown = null;
    private Database simpleTm = null;
    private IFilter trgFilter;
    private ISegmenter srcSeg;
    private ISegmenter trgSeg;
    private int aligned;
    private int alignedTotal;
    private int noText;
    private int noTextTotal;
    private int count;
    private int countTotal;
    private int manual;
    private int manualTotal;
    private Aligner aligner;
    private boolean stopProcess;
    private int targetCount;
    private Map<String, String> originalAttributes;
    private Map<String, String> assignedAttributes;

    public Utility() {
        this.needsSelfOutput = false;
    }

    @Override
    public String getName() {
        return "oku_alignment";
    }

    @Override
    public void preprocess() {
        String trgSrxPath = this.params.getTargetSrxPath().replace("${ProjDir}", this.projectDir);
        if (this.params.getSegment()) {
            String srcSrxPath = this.params.getSourceSrxPath().replace("${ProjDir}", this.projectDir);
            SRXDocument doc = new SRXDocument();
            doc.loadRules(srcSrxPath);
            if (doc.hasWarning()) {
                this.logger.warn(doc.getWarning());
            }
            this.srcSeg = doc.compileLanguageRules(this.srcLang, null);
            if (!srcSrxPath.equals(trgSrxPath)) {
                doc.loadRules(trgSrxPath);
                if (doc.hasWarning()) {
                    this.logger.warn(doc.getWarning());
                }
            }
            this.trgSeg = doc.compileLanguageRules(this.trgLang, null);
        }
        if (this.params.getCreateTMX()) {
            if (this.tmxWriter != null) {
                this.tmxWriter.close();
                this.tmxWriter = null;
            }
            this.tmxWriter = new TMXWriter(this.params.getTmxPath().replace("${ProjDir}", this.projectDir));
            this.tmxWriter.setTradosWorkarounds(this.params.getUseTradosWorkarounds());
            this.tmxWriter.writeStartDocument(this.srcLang, this.trgLang, this.getName(), null, this.params.getSegment() ? "sentence" : "paragraph", null, null);
        }
        if (this.params.getCreateTMXForUnknown()) {
            if (this.tmxWriterForUnknown != null) {
                this.tmxWriterForUnknown.close();
                this.tmxWriterForUnknown = null;
            }
            this.tmxWriterForUnknown = new TMXWriter(this.params.getTmxForUnknownPath().replace("${ProjDir}", this.projectDir));
            this.tmxWriterForUnknown.setTradosWorkarounds(this.params.getUseTradosWorkarounds());
            this.tmxWriterForUnknown.writeStartDocument(this.srcLang, this.trgLang, this.getName(), null, this.params.getSegment() ? "sentence" : "paragraph", null, null);
        }
        if (this.params.getCreateTM()) {
            this.simpleTm = new Database();
            this.simpleTm.create(this.params.getTmPath().replace("${ProjDir}", this.projectDir), true, this.trgLang);
        }
        if (this.params.getCreateAttributes()) {
            ConfigurationString cfgString = new ConfigurationString(this.params.getAttributes());
            this.originalAttributes = cfgString.toMap();
            this.assignedAttributes = new LinkedHashMap<String, String>();
        }
        if (this.params.getUseExclusion()) {
            if (this.tmxWriter != null) {
                this.tmxWriter.setExclusionOption(this.params.getExclusion());
            }
            if (this.tmxWriterForUnknown != null) {
                this.tmxWriterForUnknown.setExclusionOption(this.params.getExclusion());
            }
        } else {
            if (this.tmxWriter != null) {
                this.tmxWriter.setExclusionOption(null);
            }
            if (this.tmxWriterForUnknown != null) {
                this.tmxWriterForUnknown.setExclusionOption(null);
            }
        }
        this.dbStoreBuilder = new DbStoreBuilder();
        this.dbStoreBuilder.setSegmenter(this.trgSeg);
        this.dbStoreBuilder.setOptions(this.trgLang, null);
        if (this.aligner == null) {
            this.aligner = new Aligner(this.shell, this.help);
            this.aligner.setInfo(trgSrxPath, this.params.getCheckSingleSegUnit(), this.params.getUseAutoCorrection(), this.srcLang, this.trgLang, this.params.getMtKey());
        }
        this.alignedTotal = 0;
        this.noTextTotal = 0;
        this.countTotal = 0;
        this.manualTotal = 0;
    }

    @Override
    public void postprocess() {
        this.logger.info("Total translatable text units = {}", (Object)this.countTotal);
        this.logger.info("Total without text = {}", (Object)this.noTextTotal);
        this.logger.info("Total aligned = {} (manually modified = {})", (Object)this.alignedTotal, (Object)this.manualTotal);
        if (this.aligner != null) {
            this.aligner.closeWithoutWarning();
            this.aligner = null;
        }
        if (this.tmxWriter != null) {
            this.tmxWriter.writeEndDocument();
            this.tmxWriter.close();
            this.tmxWriter = null;
        }
        if (this.tmxWriterForUnknown != null) {
            this.tmxWriterForUnknown.writeEndDocument();
            this.tmxWriterForUnknown.close();
            this.tmxWriterForUnknown = null;
        }
        if (this.simpleTm != null) {
            this.simpleTm.close();
            this.simpleTm = null;
        }
        if (this.dbStore != null) {
            this.dbStore.close();
            this.dbStore = null;
        }
        this.srcSeg = null;
        this.trgSeg = null;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean needsRoots() {
        return false;
    }

    @Override
    public void setParameters(IParameters paramsObject) {
        this.params = (Parameters)paramsObject;
    }

    @Override
    public boolean isFilterDriven() {
        return true;
    }

    @Override
    public int inputCountRequested() {
        return 2;
    }

    @Override
    public String getFolderAfterProcess() {
        if (this.params.getCreateTMX()) {
            return Util.getDirectoryName(this.params.getTmxPath().replace("${ProjDir}", this.projectDir));
        }
        if (this.params.getCreateTM()) {
            return Util.getDirectoryName(this.params.getTmPath().replace("${ProjDir}", this.projectDir));
        }
        return Util.getDirectoryName(this.params.getTmxForUnknownPath().replace("${ProjDir}", this.projectDir));
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
        }
        return event;
    }

    private void processStartDocument(StartDocument resource) {
        this.fileName = Util.getFilename(resource.getName(), true);
        this.readTargetToDb();
        this.dbStore = this.dbStoreBuilder.getDbStore();
        this.targetCount = this.dbStore.getTextUnitCount();
        this.aligned = 0;
        this.noText = 0;
        this.count = 0;
        this.manual = 0;
        this.aligner.setDocumentName(resource.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTargetToDb() {
        try {
            this.trgFilter = this.mapper.createFilter(this.getInputFilterSettings(1), this.trgFilter);
            File f = new File(this.getInputPath(1));
            RawDocument res = new RawDocument(f.toURI(), this.getInputEncoding(1), this.srcLang, this.trgLang);
            this.trgFilter.open(res, false);
            while (this.trgFilter.hasNext()) {
                this.dbStoreBuilder.handleEvent(this.trgFilter.next());
            }
        }
        finally {
            if (this.trgFilter != null) {
                this.trgFilter.close();
            }
        }
    }

    private void processEndDocument() {
        this.alignedTotal += this.aligned;
        this.noTextTotal += this.noText;
        this.countTotal += this.count;
        this.manualTotal += this.manual;
        this.logger.info("Translatable text units = {}", (Object)this.count);
        this.logger.info("Without text = {}", (Object)this.noText);
        this.logger.info("Aligned = {} (manually modified = {})", (Object)this.aligned, (Object)this.manual);
    }

    private void processTextUnit(ITextUnit tu) {
        TextContainer trgTC;
        if (this.stopProcess) {
            return;
        }
        if (!tu.isTranslatable()) {
            return;
        }
        ++this.count;
        if (this.params.getSegment()) {
            this.srcSeg.computeSegments(tu.getSource());
            tu.getSource().getSegments().create(this.srcSeg.getRanges());
            if (!tu.getSource().hasBeenSegmented() && !tu.getSource().hasText(false)) {
                ++this.noText;
                return;
            }
        }
        if ((trgTC = this.dbStore.findEntry(tu.getName())) != null) {
            tu.setTarget(this.trgLang, trgTC);
            if (!tu.getSource().hasBeenSegmented() && trgTC.count() > 0) {
                trgTC.getSegments().joinAll();
            }
            switch (this.aligner.align(tu, this.count, this.targetCount)) {
                case 1: {
                    ++this.aligned;
                    if (this.aligner.wasModifiedManually()) {
                        ++this.manual;
                    }
                    if (this.params.getCreateAttributes()) {
                        for (String key : this.originalAttributes.keySet()) {
                            String value = this.originalAttributes.get(key);
                            if ("${filename}".equals(value)) {
                                this.assignedAttributes.put(key, this.fileName);
                                continue;
                            }
                            if ("${resname}".equals(value)) {
                                this.assignedAttributes.put(key, tu.getName());
                                continue;
                            }
                            this.assignedAttributes.put(key, value);
                        }
                    }
                    if (tu.hasTargetProperty(this.trgLang, "Att::AlignStatus")) {
                        this.assignedAttributes.put("Att::AlignStatus", tu.getTargetProperty(this.trgLang, "Att::AlignStatus").getValue());
                    } else {
                        this.assignedAttributes.remove("Att::AlignStatus");
                    }
                    if (this.params.getCreateTMX()) {
                        this.tmxWriter.writeItem(tu, this.assignedAttributes);
                    }
                    if (this.params.getCreateTM()) {
                        this.simpleTm.addEntry(tu, tu.getName(), this.fileName);
                    }
                    return;
                }
                case 2: {
                    break;
                }
                case 0: {
                    this.stopProcess = true;
                    this.cancel();
                }
            }
        }
        if (!this.stopProcess) {
            this.logger.info("Not aligned: {}", (Object)tu.getName());
            if (this.tmxWriterForUnknown != null) {
                tu.removeTarget(this.trgLang);
                this.tmxWriterForUnknown.writeItem(tu, this.assignedAttributes);
            }
        }
    }
}

