/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.editor;

import java.io.File;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDocumentDialog;
import net.sf.okapi.lib.ui.editor.PairEditorPanel;
import net.sf.okapi.virtualdb.IVDocument;
import net.sf.okapi.virtualdb.IVRepository;
import net.sf.okapi.virtualdb.IVTextUnit;
import net.sf.okapi.virtualdb.jdbc.IDBAccess;
import net.sf.okapi.virtualdb.jdbc.Repository;
import net.sf.okapi.virtualdb.jdbc.h2.H2Access;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PairEditorUserTest {
    private Shell shell;
    private IFilterConfigurationMapper fcMapper;
    private PairEditorPanel editPanel;
    private Text edInfo;
    private Button btFirst;
    private Button btLast;
    private Button btNext;
    private Button btPrevious;
    private Button btSave;
    private Button chkSegmentMode;
    private LocaleId srcLoc = LocaleId.ENGLISH;
    private LocaleId trgLoc = LocaleId.FRENCH;
    private RawDocument rawDoc;
    private int current = -1;
    private int curSeg = -1;
    private ISegments srcSegs;
    private ISegments trgSegs;
    private ITextUnit tu;
    private TextContainer srcCont;
    private TextContainer trgCont;
    private boolean segmentMode = true;
    private String inPath;
    private String inConfig;
    private String outEncoding;
    private String outPath;
    private int TUCount;
    private ArrayList<ITextUnit> textUnits = new ArrayList();
    private ArrayList<Long> keys = new ArrayList();
    private IVRepository repo;
    private IVDocument vdoc;
    private IVTextUnit vtu;
    private boolean useRepository;
    private static final String WINDOW_TITLE = "Fragment Editor Testing Console";

    public PairEditorUserTest(Object parent, IFilterConfigurationMapper fcMapper, boolean useRepository) {
        if (parent == null) {
            Display dispMain = new Display();
            parent = new Shell(dispMain);
        }
        this.fcMapper = fcMapper;
        this.shell = new Shell((Shell)parent, 66800);
        this.shell.setText(WINDOW_TITLE);
        this.shell.setLayout(new GridLayout());
        this.useRepository = useRepository;
        if (useRepository) {
            String home = System.getProperty("user.home");
            H2Access h2db = new H2Access(home, fcMapper);
            this.repo = new Repository((IDBAccess)h2db);
            h2db.create("tmpRepository");
        }
        this.createContent();
        if (!useRepository) {
            this.createInitialExtractedText();
        }
        this.updateButtons();
        Dialogs.centerWindow(this.shell, (Shell)parent);
    }

    protected void finalize() {
        this.dispose();
    }

    private void dispose() {
    }

    public void showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void createContent() {
        Composite comp = new Composite(this.shell, 2048);
        comp.setLayout(new GridLayout(6, true));
        comp.setLayoutData(new GridData(1808));
        Button btOpen = new Button(comp, 8);
        btOpen.setText("&Open File...");
        btOpen.setLayoutData(new GridData(768));
        btOpen.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PairEditorUserTest.this.openDocument(PairEditorUserTest.this.inPath);
            }
        });
        this.btFirst = new Button(comp, 8);
        this.btFirst.setText("&First");
        this.btFirst.setLayoutData(new GridData(768));
        this.btFirst.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PairEditorUserTest.this.displayFirst();
            }
        });
        this.btPrevious = new Button(comp, 8);
        this.btPrevious.setText("&Previous");
        this.btPrevious.setLayoutData(new GridData(768));
        this.btPrevious.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PairEditorUserTest.this.displayPrevious();
            }
        });
        this.btNext = new Button(comp, 8);
        this.btNext.setText("&Next");
        this.btNext.setLayoutData(new GridData(768));
        this.btNext.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PairEditorUserTest.this.displayNext();
            }
        });
        this.btLast = new Button(comp, 8);
        this.btLast.setText("&Last");
        this.btLast.setLayoutData(new GridData(768));
        this.btLast.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PairEditorUserTest.this.displayLast();
            }
        });
        this.btSave = new Button(comp, 8);
        this.btSave.setText("&Save Output");
        this.btSave.setLayoutData(new GridData(768));
        this.btSave.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PairEditorUserTest.this.saveOutput();
            }
        });
        this.chkSegmentMode = new Button(comp, 32);
        this.chkSegmentMode.setText("&Segment mode");
        this.chkSegmentMode.setSelection(this.segmentMode);
        this.chkSegmentMode.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PairEditorUserTest.this.switchMode(!PairEditorUserTest.this.segmentMode);
            }
        });
        this.edInfo = new Text(comp, 2048);
        this.edInfo.setEditable(false);
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 5;
        this.edInfo.setLayoutData(gdTmp);
        this.editPanel = new PairEditorPanel(comp, 512);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 6;
        this.editPanel.setLayoutData(gdTmp);
        this.editPanel.clear();
        DropTarget dropTarget = new DropTarget(this.shell, 19);
        dropTarget.setTransfer(new FileTransfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetAdapter(){

            @Override
            public void drop(DropTargetEvent e) {
                String[] paths;
                FileTransfer FT = FileTransfer.getInstance();
                if (FT.isSupportedType(e.currentDataType) && (paths = (String[])e.data) != null) {
                    for (String path : paths) {
                        if (!PairEditorUserTest.this.openDocument(path)) break;
                    }
                }
            }
        });
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        this.shell.setSize(680, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openDocument(String path) {
        IFilter filter = null;
        try {
            InputDocumentDialog dlg = new InputDocumentDialog(this.shell, "Open File", this.fcMapper, false);
            dlg.setData(path, this.inConfig, "UTF-8", this.srcLoc, this.trgLoc);
            Object[] data = dlg.showDialog();
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            this.inPath = (String)data[0];
            this.inConfig = (String)data[1];
            File inFile = new File(this.inPath);
            this.shell.setText("Fragment Editor Testing Console - " + inFile.getName() + " (" + this.inConfig + ")");
            this.srcLoc = (LocaleId)data[3];
            this.trgLoc = (LocaleId)data[4];
            this.rawDoc = new RawDocument(inFile.toURI(), (String)data[2], this.srcLoc, this.trgLoc);
            this.rawDoc.setFilterConfigId(this.inConfig);
            if (this.fcMapper instanceof FilterConfigurationMapper) {
                ((FilterConfigurationMapper)this.fcMapper).updateCustomConfigurations();
            }
            filter = this.fcMapper.createFilter(this.rawDoc.getFilterConfigId());
            this.outEncoding = null;
            this.outPath = null;
            this.current = -1;
            this.curSeg = -1;
            this.srcSegs = null;
            this.trgSegs = null;
            this.TUCount = 0;
            if (this.useRepository) {
                if (this.vdoc != null) {
                    this.repo.removeDocument(this.vdoc);
                }
                this.repo.importDocument(this.rawDoc);
                this.vdoc = this.repo.getFirstDocument();
                this.keys = new ArrayList();
                for (IVTextUnit vtu : this.vdoc.textUnits()) {
                    this.keys.add(vtu.getKey());
                }
                this.TUCount = this.keys.size();
            } else {
                this.textUnits = new ArrayList();
                filter.open(this.rawDoc);
                while (filter.hasNext()) {
                    Event event = filter.next();
                    if (event.getEventType() != EventType.TEXT_UNIT) continue;
                    this.textUnits.add(event.getTextUnit());
                }
                this.TUCount = this.textUnits.size();
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error when opening document.\n" + e.getMessage(), null);
            boolean bl = false;
            return bl;
        }
        finally {
            if (filter != null) {
                filter.close();
            }
            this.displayFirst();
        }
        return true;
    }

    private void updateButtons() {
        this.btSave.setEnabled(this.rawDoc != null && this.TUCount > 0);
        if (this.segmentMode) {
            this.btPrevious.setEnabled(this.current > 0 && (this.curSeg > 0 || this.TUCount > 0));
            this.btNext.setEnabled(this.TUCount > 0 && (this.curSeg < this.srcSegs.count() - 1 || this.current < this.TUCount - 1));
        } else {
            this.btPrevious.setEnabled(this.current > 0 && this.TUCount > 0);
            this.btNext.setEnabled(this.TUCount > 0 && this.current < this.TUCount - 1);
        }
        this.btFirst.setEnabled(this.btPrevious.getEnabled());
        this.btLast.setEnabled(this.btNext.getEnabled());
    }

    private void getNewCurrent(int index, boolean firstSegment) {
        try {
            if (index < 0) {
                return;
            }
            if (this.useRepository) {
                this.vtu = (IVTextUnit)this.vdoc.getItem(this.keys.get(index).longValue());
                this.tu = this.vtu.getTextUnit();
            } else {
                this.tu = this.textUnits.get(index);
            }
            this.srcCont = this.tu.getSource();
            if (this.segmentMode) {
                this.srcSegs = this.srcCont.getSegments();
            }
            this.trgCont = this.tu.getTarget(this.trgLoc);
            if (this.trgCont == null) {
                this.trgCont = this.tu.createTarget(this.trgLoc, false, 7);
                this.trgSegs = this.trgCont.getSegments();
                for (Segment seg : this.trgSegs) {
                    seg.text.clear();
                }
            } else if (this.segmentMode) {
                this.trgSegs = this.trgCont.getSegments();
            }
            if (this.segmentMode) {
                this.curSeg = firstSegment ? 0 : this.srcSegs.count() - 1;
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error when accessing text unit.\n" + e.getMessage(), null);
        }
    }

    private void displayCurrent() {
        if (this.current < 0) {
            this.editPanel.clear();
            this.edInfo.setText("");
        } else {
            if (this.segmentMode) {
                Segment srcSeg = this.srcSegs.get(this.curSeg);
                Segment trgSeg = this.trgSegs.get(srcSeg.getId());
                if (trgSeg == null) {
                    trgSeg = new Segment(srcSeg.getId(), new TextFragment());
                    this.trgSegs.append(trgSeg);
                }
                this.editPanel.setTextFragments(srcSeg.text, trgSeg.text);
                this.edInfo.setText(String.format("TU ID=%s / %d of %d / seg=%s", this.tu.getId(), this.current + 1, this.TUCount, srcSeg.getId()));
            } else {
                this.editPanel.setTextContainers(this.srcCont, this.trgCont);
                this.edInfo.setText(String.format("TU ID=%s / %d of %d / full content", this.tu.getId(), this.current + 1, this.TUCount));
            }
            this.editPanel.setEnabled(this.tu.isTranslatable());
            if (!this.editPanel.getEnabled()) {
                this.edInfo.setText(this.edInfo.getText() + " NOT TRANSLATABLE!");
            }
        }
        this.updateButtons();
    }

    private void displayPrevious() {
        long start = System.currentTimeMillis();
        if (this.current < 0) {
            return;
        }
        if (!this.saveCurrent()) {
            return;
        }
        if (this.segmentMode) {
            if (this.curSeg == 0) {
                if (this.current == 0) {
                    return;
                }
                this.getNewCurrent(--this.current, false);
            } else {
                --this.curSeg;
            }
        } else {
            if (this.current == 0) {
                return;
            }
            this.getNewCurrent(--this.current, false);
        }
        this.displayCurrent();
        System.out.println(String.format("displayPrevious = %d", System.currentTimeMillis() - start));
    }

    private void displayNext() {
        long start = System.currentTimeMillis();
        if (this.current < 0) {
            return;
        }
        if (!this.saveCurrent()) {
            return;
        }
        if (this.segmentMode) {
            if (this.curSeg >= this.srcSegs.count() - 1) {
                if (this.current >= this.TUCount - 1) {
                    return;
                }
                this.getNewCurrent(++this.current, true);
            } else {
                ++this.curSeg;
            }
        } else {
            if (this.current >= this.TUCount - 1) {
                return;
            }
            this.getNewCurrent(++this.current, true);
        }
        this.displayCurrent();
        System.out.println(String.format("displayNext = %d", System.currentTimeMillis() - start));
    }

    private void displayFirst() {
        if (!this.saveCurrent()) {
            return;
        }
        if (this.TUCount > 0) {
            this.current = 0;
            this.getNewCurrent(this.current, true);
        } else {
            this.current = -1;
        }
        this.displayCurrent();
    }

    private void switchMode(boolean newSegmentMode) {
        if (this.current < 0) {
            this.segmentMode = newSegmentMode;
            return;
        }
        if (!this.saveCurrent()) {
            return;
        }
        if (this.segmentMode) {
            this.segmentMode = newSegmentMode;
        } else {
            this.segmentMode = newSegmentMode;
            this.getNewCurrent(this.current, true);
        }
        this.displayCurrent();
    }

    private void displayLast() {
        if (this.current < 0) {
            return;
        }
        if (!this.saveCurrent()) {
            return;
        }
        if (this.TUCount > 0) {
            this.current = this.TUCount - 1;
            this.getNewCurrent(this.current, false);
        } else {
            this.current = -1;
        }
        this.displayCurrent();
    }

    private boolean saveCurrent() {
        if (this.current == -1) {
            return true;
        }
        if (!this.editPanel.isModified()) {
            return true;
        }
        if (!this.editPanel.applyChanges()) {
            return false;
        }
        if (this.vtu != null) {
            this.vtu.save();
        }
        return true;
    }

    private void saveOutput() {
        if (!this.saveCurrent()) {
            return;
        }
        IFilter filter = null;
        IFilterWriter writer = null;
        try {
            filter = this.fcMapper.createFilter(this.rawDoc.getFilterConfigId());
            filter.open(this.rawDoc);
            int tuIndex = 0;
            while (filter.hasNext()) {
                Event event = filter.next();
                switch (event.getEventType()) {
                    case START_DOCUMENT: {
                        StartDocument sd = (StartDocument)event.getResource();
                        this.outEncoding = this.rawDoc.getEncoding();
                        this.outPath = new File(this.rawDoc.getInputURI()).getPath();
                        this.outPath = Util.getDirectoryName((String)this.outPath) + File.separator + Util.getFilename((String)this.outPath, (boolean)false) + ".out" + Util.getExtension((String)this.outPath);
                        writer = sd.getFilterWriter();
                        writer.setOptions(this.trgLoc, this.outEncoding);
                        writer.setOutput(this.outPath);
                        break;
                    }
                    case TEXT_UNIT: {
                        ITextUnit updTU;
                        ITextUnit oriTU = event.getTextUnit();
                        if (this.useRepository) {
                            IVTextUnit updVTU = (IVTextUnit)this.vdoc.getItem(this.keys.get(tuIndex).longValue());
                            updTU = updVTU.getTextUnit();
                        } else {
                            updTU = this.textUnits.get(tuIndex);
                        }
                        if (!oriTU.getId().equals(updTU.getId())) {
                            throw new RuntimeException("Text units de-synchronized: the underlying file has changed.");
                        }
                        TextContainer tc = updTU.getTarget(this.trgLoc);
                        if (tc != null) {
                            oriTU.setTarget(this.trgLoc, tc);
                        }
                        ++tuIndex;
                        break;
                    }
                }
                writer.handleEvent(event);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error when saving document.\n" + e.getMessage(), null);
        }
    }

    private void createInitialExtractedText() {
        this.rawDoc = null;
        this.textUnits = new ArrayList();
        TextFragment srcFrag = new TextFragment("This is a dummy entry of ");
        srcFrag.append(TextFragment.TagType.OPENING, "emph", "<em>");
        srcFrag.append("extracted text");
        srcFrag.append(TextFragment.TagType.CLOSING, "emph", "</em>");
        srcFrag.append(". But you can also test REAL files too.");
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "SomeCode", "<br/>");
        srcFrag.append("Click ");
        srcFrag.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcFrag.append("Next");
        srcFrag.append(TextFragment.TagType.CLOSING, "emph", "</b>");
        srcFrag.append(" to learn how.");
        TextUnit tu = new TextUnit("id1");
        tu.setSource(new TextContainer(srcFrag));
        this.textUnits.add((ITextUnit)tu);
        srcFrag = new TextFragment("To get the text of a file: Click");
        srcFrag.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcFrag.append("Open File");
        srcFrag.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcFrag.append(". Then select the document to open, the filter configuration to use, and the default encoding.");
        tu = new TextUnit("id2");
        tu.setSource(new TextContainer(srcFrag));
        this.textUnits.add((ITextUnit)tu);
        this.TUCount = this.textUnits.size();
        this.displayFirst();
    }
}

